/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetAliasesAction
extends BaseRestHandler {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RestGetAliasesAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/_aliases"), new RestHandler.Route(RestRequest.Method.GET, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/_alias/{name}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_alias/{name}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_alias/{name}"));
    }

    @Override
    public String getName() {
        return "get_aliases_action";
    }

    static RestResponse buildRestResponse(boolean aliasesExplicitlyRequested, String[] requestedAliases, Map<String, List<AliasMetadata>> responseAliasMap, Map<String, List<DataStreamAlias>> dataStreamAliases, XContentBuilder builder) throws Exception {
        RestStatus status;
        int i;
        HashSet<String> indicesToDisplay = new HashSet<String>();
        HashSet<String> returnedAliasNames = new HashSet<String>();
        for (Map.Entry<String, List<AliasMetadata>> cursor : responseAliasMap.entrySet()) {
            for (AliasMetadata aliasMetadata : cursor.getValue()) {
                if (aliasesExplicitlyRequested) {
                    indicesToDisplay.add(cursor.getKey());
                }
                returnedAliasNames.add(aliasMetadata.alias());
            }
        }
        dataStreamAliases.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).forEach(dataStreamAlias -> returnedAliasNames.add(dataStreamAlias.getName()));
        TreeSet<String> missingAliases = new TreeSet<String>();
        int firstWildcardIndex = requestedAliases.length;
        for (i = 0; i < requestedAliases.length; ++i) {
            if (!Regex.isSimpleMatchPattern(requestedAliases[i])) continue;
            firstWildcardIndex = i;
            break;
        }
        for (i = 0; i < requestedAliases.length; ++i) {
            int j;
            if ("_all".equals(requestedAliases[i]) || Regex.isSimpleMatchPattern(requestedAliases[i]) || i > firstWildcardIndex && requestedAliases[i].charAt(0) == '-') continue;
            for (j = Math.max(i + 1, firstWildcardIndex); j < requestedAliases.length && (requestedAliases[j].charAt(0) != '-' || !Regex.simpleMatch(requestedAliases[j].substring(1), requestedAliases[i]) && !"_all".equals(requestedAliases[j].substring(1))); ++j) {
            }
            if (j != requestedAliases.length || returnedAliasNames.contains(requestedAliases[i])) continue;
            missingAliases.add(requestedAliases[i]);
        }
        builder.startObject();
        if (missingAliases.isEmpty()) {
            status = RestStatus.OK;
        } else {
            status = RestStatus.NOT_FOUND;
            String message = missingAliases.size() == 1 ? String.format(Locale.ROOT, "alias [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases)) : String.format(Locale.ROOT, "aliases [%s] missing", Strings.collectionToCommaDelimitedString(missingAliases));
            builder.field("error", message);
            builder.field("status", status.getStatus());
        }
        for (Map.Entry<String, List<AliasMetadata>> entry2 : responseAliasMap.entrySet()) {
            if (aliasesExplicitlyRequested && !indicesToDisplay.contains(entry2.getKey())) continue;
            builder.startObject(entry2.getKey());
            builder.startObject("aliases");
            for (SimpleDiffable<AliasMetadata> alias : entry2.getValue()) {
                AliasMetadata.Builder.toXContent((AliasMetadata)alias, builder, ToXContent.EMPTY_PARAMS);
            }
            builder.endObject();
            builder.endObject();
        }
        for (Map.Entry<String, List<SimpleDiffable<AliasMetadata>>> entry3 : dataStreamAliases.entrySet()) {
            builder.startObject(entry3.getKey());
            builder.startObject("aliases");
            for (SimpleDiffable<AliasMetadata> alias : entry3.getValue()) {
                builder.startObject(((DataStreamAlias)alias).getName());
                if (entry3.getKey().equals(((DataStreamAlias)alias).getWriteDataStream())) {
                    builder.field("is_write_index", true);
                }
                if (((DataStreamAlias)alias).getFilter(entry3.getKey()) != null) {
                    builder.field("filter", (Map)XContentHelper.convertToMap(((DataStreamAlias)alias).getFilter(entry3.getKey()).uncompressed(), true).v2());
                }
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return new RestResponse(status, builder);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final boolean namesProvided = request.hasParam("name");
        final String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        TimeValue masterNodeTimeout = RestUtils.getMasterNodeTimeout(request);
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(masterNodeTimeout, aliases);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        if (request.getRestApiVersion() == RestApiVersion.V_8 && request.hasParam("local")) {
            boolean localParam = request.paramAsBoolean("local", false);
            DEPRECATION_LOGGER.critical(DeprecationCategory.API, "get-aliases-local", "the [?local={}] query parameter to get-aliases requests has no effect and will be removed in a future version", localParam);
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(this, channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                return RestGetAliasesAction.buildRestResponse(namesProvided, aliases, response.getAliases(), response.getDataStreamAliases(), builder);
            }
        });
    }
}

