/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;

public class InvalidRepository
extends AbstractLifecycleComponent
implements Repository {
    private final RepositoryMetadata repositoryMetadata;
    private final RepositoryException creationException;

    public InvalidRepository(RepositoryMetadata repositoryMetadata, RepositoryException creationException) {
        this.repositoryMetadata = repositoryMetadata;
        this.creationException = creationException;
    }

    private RepositoryException createCreationException() {
        return new RepositoryException(this.repositoryMetadata.name(), "repository type [" + this.repositoryMetadata.type() + "] failed to create on current node", this.creationException, new Object[0]);
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.repositoryMetadata;
    }

    @Override
    public void getSnapshotInfo(Collection<SnapshotId> snapshotIds, boolean abortOnFailure, BooleanSupplier isCancelled, CheckedConsumer<SnapshotInfo, Exception> consumer, ActionListener<Void> listener) {
        listener.onFailure(this.createCreationException());
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        throw this.createCreationException();
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        throw this.createCreationException();
    }

    @Override
    public void getRepositoryData(Executor responseExecutor, ActionListener<RepositoryData> listener) {
        listener.onFailure(this.createCreationException());
    }

    @Override
    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        finalizeSnapshotContext.onFailure(this.createCreationException());
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryDataGeneration, IndexVersion minimumNodeVersion, ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
        repositoryDataUpdateListener.onFailure(this.createCreationException());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        throw this.createCreationException();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        throw this.createCreationException();
    }

    @Override
    public String startVerification() {
        throw this.createCreationException();
    }

    @Override
    public void endVerification(String verificationToken) {
        throw this.createCreationException();
    }

    @Override
    public void verify(String verificationToken, DiscoveryNode localNode) {
        throw this.createCreationException();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void snapshotShard(SnapshotShardContext snapshotShardContext) {
        snapshotShardContext.onFailure(this.createCreationException());
    }

    @Override
    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        listener.onFailure(this.createCreationException());
    }

    @Override
    public IndexShardSnapshotStatus.Copy getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        throw this.createCreationException();
    }

    @Override
    public void updateState(ClusterState state) {
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        listener.onFailure(this.createCreationException());
    }

    @Override
    public void awaitIdle() {
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }
}

