/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.scanners;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.scanners.NameToPluginInfo;
import org.elasticsearch.plugins.scanners.NamedComponentReader;
import org.elasticsearch.plugins.scanners.PluginInfo;

public class StablePluginsRegistry {
    private final Map<String, NameToPluginInfo> namedComponents;
    private final NamedComponentReader namedComponentReader;

    public StablePluginsRegistry() {
        this(new NamedComponentReader(), new HashMap<String, NameToPluginInfo>());
    }

    public StablePluginsRegistry(NamedComponentReader namedComponentReader, Map<String, NameToPluginInfo> namedComponents) {
        this.namedComponentReader = namedComponentReader;
        this.namedComponents = namedComponents;
    }

    public void scanBundleForStablePlugins(PluginBundle bundle, ClassLoader pluginClassLoader) {
        Map<String, NameToPluginInfo> namedComponentsFromPlugin = this.namedComponentReader.findNamedComponents(bundle, pluginClassLoader);
        for (Map.Entry<String, NameToPluginInfo> entry : namedComponentsFromPlugin.entrySet()) {
            this.namedComponents.compute(entry.getKey(), (k, v) -> v != null ? v.put((NameToPluginInfo)entry.getValue()) : (NameToPluginInfo)entry.getValue());
        }
    }

    public Collection<PluginInfo> getPluginInfosForExtensible(String extensibleClassName) {
        NameToPluginInfo nameToPluginInfo = this.namedComponents.get(extensibleClassName);
        if (nameToPluginInfo != null) {
            return nameToPluginInfo.nameToPluginInfoMap().values();
        }
        return Collections.emptyList();
    }
}

