/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksNodeService;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;

public class AllocatedPersistentTask
extends CancellableTask {
    private static final Logger logger = LogManager.getLogger(AllocatedPersistentTask.class);
    private final AtomicReference<State> state = new AtomicReference<State>(State.STARTED);
    private volatile String persistentTaskId;
    private volatile long allocationId;
    @Nullable
    private volatile Exception failure;
    private volatile PersistentTasksService persistentTasksService;
    private volatile TaskManager taskManager;

    public AllocatedPersistentTask(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        super(id, type, action, description, parentTask, headers);
    }

    @Override
    public Task.Status getStatus() {
        return new PersistentTasksNodeService.Status(this.state.get());
    }

    public void updatePersistentTaskState(PersistentTaskState state, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.persistentTasksService.sendUpdateStateRequest(this.persistentTaskId, this.allocationId, state, TimeValue.THIRTY_SECONDS, listener);
    }

    public String getPersistentTaskId() {
        return this.persistentTaskId;
    }

    protected void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        this.persistentTasksService = persistentTasksService;
        this.taskManager = taskManager;
        this.persistentTaskId = persistentTaskId;
        this.allocationId = allocationId;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    public void waitForPersistentTask(Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> predicate, @Nullable TimeValue timeout, PersistentTasksService.WaitForPersistentTaskListener<?> listener) {
        this.persistentTasksService.waitForPersistentTaskCondition(this.persistentTaskId, predicate, timeout, listener);
    }

    protected final boolean isCompleted() {
        return this.state.get() == State.COMPLETED || this.state.get() == State.LOCAL_ABORTED;
    }

    protected boolean markAsCancelled() {
        return this.state.compareAndSet(State.STARTED, State.PENDING_CANCEL);
    }

    public void markAsCompleted() {
        this.completeAndNotifyIfNeeded(null, null);
    }

    public void markAsFailed(Exception e) {
        if ("by user request".equals(this.getReasonCancelled())) {
            this.completeAndNotifyIfNeeded(null, null);
        } else {
            this.completeAndNotifyIfNeeded(e, null);
        }
    }

    public void markAsLocallyAborted(String localAbortReason) {
        this.completeAndNotifyIfNeeded(null, Objects.requireNonNull(localAbortReason));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void completeAndNotifyIfNeeded(@Nullable Exception failure, @Nullable String localAbortReason) {
        assert (failure == null || localAbortReason == null) : "completion notification has both exception " + String.valueOf(failure) + " and local abort reason " + localAbortReason;
        State desiredState = localAbortReason == null ? State.COMPLETED : State.LOCAL_ABORTED;
        State prevState = this.state.getAndUpdate(currentState -> currentState != State.COMPLETED && currentState != State.LOCAL_ABORTED ? desiredState : currentState);
        if (prevState == State.COMPLETED || prevState == State.LOCAL_ABORTED) {
            if (desiredState != State.COMPLETED) throw new IllegalStateException("attempt to locally abort task [" + this.getAction() + "] with id [" + this.getPersistentTaskId() + "] which has already been " + (prevState == State.COMPLETED ? "completed" : "locally aborted"));
            if (prevState != State.COMPLETED) throw new IllegalStateException("attempt to " + (failure != null ? "fail" : "complete") + " task [" + this.getAction() + "] with id [" + this.getPersistentTaskId() + "] which has been locally aborted");
            logger.warn("attempt to complete task [{}] with id [{}] in the [{}] state", (Object)this.getAction(), (Object)this.getPersistentTaskId(), (Object)prevState);
            return;
        }
        if (failure != null) {
            logger.warn(() -> "task [" + this.getPersistentTaskId() + "] failed with an exception", (Throwable)failure);
        } else if (localAbortReason != null) {
            logger.debug("task [{}] aborted locally: [{}]", (Object)this.getPersistentTaskId(), (Object)localAbortReason);
        }
        try {
            this.failure = failure;
            if (prevState != State.STARTED) return;
            logger.trace("sending notification for completed task [{}] with id [{}]", (Object)this.getAction(), (Object)this.getPersistentTaskId());
            this.persistentTasksService.sendCompletionRequest(this.getPersistentTaskId(), this.getAllocationId(), failure, localAbortReason, TimeValue.THIRTY_SECONDS, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

                @Override
                public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
                    logger.trace("notification for task [{}] with id [{}] was successful", (Object)AllocatedPersistentTask.this.getAction(), (Object)AllocatedPersistentTask.this.getPersistentTaskId());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> Strings.format((String)"notification for task [%s] with id [%s] failed", (Object[])new Object[]{AllocatedPersistentTask.this.getAction(), AllocatedPersistentTask.this.getPersistentTaskId()}), (Throwable)e);
                }
            });
            return;
        }
        finally {
            this.taskManager.unregister(this);
        }
    }

    public static enum State {
        STARTED,
        PENDING_CANCEL,
        COMPLETED,
        LOCAL_ABORTED;

    }
}

