/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.function.LongSupplier;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class SourceFieldMetrics {
    public static final SourceFieldMetrics NOOP = new SourceFieldMetrics(MeterRegistry.NOOP, () -> 0L);
    public static final String SYNTHETIC_SOURCE_LOAD_LATENCY = "es.mapper.synthetic_source.load.latency.histogram";
    public static final String SYNTHETIC_SOURCE_INCOMPATIBLE_MAPPING = "es.mapper.synthetic_source.incompatible_mapping.total";
    private final LongSupplier relativeTimeSupplier;
    private final LongHistogram syntheticSourceLoadLatency;
    private final LongCounter syntheticSourceIncompatibleMapping;

    public SourceFieldMetrics(MeterRegistry meterRegistry, LongSupplier relativeTimeSupplier) {
        this.syntheticSourceLoadLatency = meterRegistry.registerLongHistogram(SYNTHETIC_SOURCE_LOAD_LATENCY, "Time it takes to load fields and construct synthetic source", "ms");
        this.syntheticSourceIncompatibleMapping = meterRegistry.registerLongCounter(SYNTHETIC_SOURCE_INCOMPATIBLE_MAPPING, "Number of create/update index operations using mapping not compatible with synthetic source", "count");
        this.relativeTimeSupplier = relativeTimeSupplier;
    }

    public LongSupplier getRelativeTimeSupplier() {
        return this.relativeTimeSupplier;
    }

    public void recordSyntheticSourceLoadLatency(TimeValue value) {
        this.syntheticSourceLoadLatency.record(value.millis());
    }

    public void recordSyntheticSourceIncompatibleMapping() {
        this.syntheticSourceIncompatibleMapping.increment();
    }
}

