/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.DynamicFieldType;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;

final class FieldTypeLookup {
    private final Map<String, MappedFieldType> fullNameToFieldType;
    private final Map<String, String> fullSubfieldNameToParentPath;
    private final Map<String, DynamicFieldType> dynamicFieldTypes;
    private final Map<String, Set<String>> fieldToCopiedFields;
    private final Set<String> copyToDestinationFields;
    private final int maxParentPathDots;

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        this(fieldMappers, fieldAliasMappers, List.of(), List.of());
    }

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Collection<PassThroughObjectMapper> passThroughMappers, Collection<RuntimeField> runtimeFields) {
        FieldMapper fieldMapper;
        HashMap<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
        HashMap fullSubfieldNameToParentPath = new HashMap();
        HashMap<String, DynamicFieldType> dynamicFieldTypes = new HashMap<String, DynamicFieldType>();
        HashMap fieldToCopiedFields = new HashMap();
        HashSet<String> copiedFields = new HashSet<String>();
        for (FieldMapper fieldMapper2 : fieldMappers) {
            String fieldName = fieldMapper2.fullPath();
            MappedFieldType mappedFieldType = fieldMapper2.fieldType();
            fullNameToFieldType.put(mappedFieldType.name(), mappedFieldType);
            fieldMapper2.sourcePathUsedBy().forEachRemaining(mapper -> fullSubfieldNameToParentPath.put(mapper.fullPath(), fieldName));
            if (mappedFieldType instanceof DynamicFieldType) {
                dynamicFieldTypes.put(mappedFieldType.name(), (DynamicFieldType)((Object)mappedFieldType));
            }
            for (String targetField : fieldMapper2.copyTo().copyToFields()) {
                copiedFields.add(targetField);
                Set sourcePath = (Set)fieldToCopiedFields.get(targetField);
                if (sourcePath == null) {
                    HashSet<String> fieldCopiedFields = new HashSet<String>();
                    fieldCopiedFields.add(targetField);
                    fieldToCopiedFields.put(targetField, fieldCopiedFields);
                }
                ((Set)fieldToCopiedFields.get(targetField)).add(fieldName);
            }
        }
        int maxParentPathDots = 0;
        for (String dynamicRoot : dynamicFieldTypes.keySet()) {
            maxParentPathDots = Math.max(maxParentPathDots, FieldTypeLookup.dotCount(dynamicRoot));
        }
        this.maxParentPathDots = maxParentPathDots;
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String string = fieldAliasMapper.fullPath();
            String path = fieldAliasMapper.targetPath();
            MappedFieldType fieldType = (MappedFieldType)fullNameToFieldType.get(path);
            if (fieldType == null) continue;
            fullNameToFieldType.put(string, fieldType);
            if (!(fieldType instanceof DynamicFieldType)) continue;
            dynamicFieldTypes.put(string, (DynamicFieldType)((Object)fieldType));
        }
        HashMap<String, PassThroughObjectMapper> hashMap = new HashMap<String, PassThroughObjectMapper>();
        for (PassThroughObjectMapper passThroughObjectMapper : passThroughMappers) {
            for (Mapper subfield : passThroughObjectMapper.mappers.values()) {
                String name;
                PassThroughObjectMapper conflict;
                if (!(subfield instanceof FieldMapper) || (conflict = hashMap.put(name = (fieldMapper = (FieldMapper)subfield).leafName(), passThroughObjectMapper)) == null || conflict.priority() <= passThroughObjectMapper.priority()) continue;
                hashMap.put(name, conflict);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Mapper mapper2;
            String name = (String)entry.getKey();
            if (fullNameToFieldType.containsKey(name) || !((mapper2 = ((PassThroughObjectMapper)entry.getValue()).getMapper(name)) instanceof FieldMapper)) continue;
            fieldMapper = (FieldMapper)mapper2;
            MappedFieldType fieldType = fieldMapper.fieldType();
            fullNameToFieldType.put(name, fieldType);
            if (!(fieldType instanceof DynamicFieldType)) continue;
            dynamicFieldTypes.put(name, (DynamicFieldType)((Object)fieldType));
        }
        for (MappedFieldType mappedFieldType : RuntimeField.collectFieldTypes(runtimeFields).values()) {
            fullNameToFieldType.put(mappedFieldType.name(), mappedFieldType);
        }
        this.fullNameToFieldType = Map.copyOf(fullNameToFieldType);
        this.fullSubfieldNameToParentPath = Map.copyOf(fullSubfieldNameToParentPath);
        this.dynamicFieldTypes = Map.copyOf(dynamicFieldTypes);
        fieldToCopiedFields.entrySet().forEach(e -> e.setValue(Set.copyOf((Collection)e.getValue())));
        this.fieldToCopiedFields = Map.copyOf(fieldToCopiedFields);
        this.copyToDestinationFields = Set.copyOf(copiedFields);
    }

    public static int dotCount(String path) {
        int dotCount = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '.') continue;
            ++dotCount;
        }
        return dotCount;
    }

    MappedFieldType get(String field) {
        MappedFieldType fieldType = this.fullNameToFieldType.get(field);
        if (fieldType != null) {
            return fieldType;
        }
        return this.getDynamicField(field);
    }

    int getMaxParentPathDots() {
        return this.maxParentPathDots;
    }

    private MappedFieldType getDynamicField(String field) {
        String parentField;
        DynamicFieldType dft;
        if (this.dynamicFieldTypes.isEmpty()) {
            return null;
        }
        int dotIndex = -1;
        int fieldDepth = -1;
        do {
            if (++fieldDepth > this.maxParentPathDots) {
                return null;
            }
            if ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) continue;
            return null;
        } while ((dft = this.dynamicFieldTypes.get(parentField = field.substring(0, dotIndex))) == null || Objects.equals(field, parentField));
        String key = field.substring(dotIndex + 1);
        return dft.getChildFieldType(key);
    }

    Set<String> getMatchingFieldNames(String pattern) {
        if (Regex.isMatchAllPattern(pattern)) {
            return this.fullNameToFieldType.keySet();
        }
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return this.get(pattern) == null ? Collections.emptySet() : Collections.singleton(pattern);
        }
        return this.fullNameToFieldType.keySet().stream().filter(field -> Regex.simpleMatch(pattern, field)).collect(Collectors.toUnmodifiableSet());
    }

    Set<String> sourcePaths(String field) {
        if (this.fullNameToFieldType.isEmpty()) {
            return Set.of();
        }
        MappedFieldType fieldType = this.getDynamicField(field);
        if (fieldType != null) {
            return Set.of(field);
        }
        String resolvedField = field;
        if (this.fullSubfieldNameToParentPath.containsKey(field)) {
            resolvedField = this.fullSubfieldNameToParentPath.get(field);
        }
        return this.fieldToCopiedFields.containsKey(resolvedField) ? this.fieldToCopiedFields.get(resolvedField) : Set.of(resolvedField);
    }

    public String parentField(String field) {
        return this.fullSubfieldNameToParentPath.get(field);
    }

    public Map<String, MappedFieldType> getFullNameToFieldType() {
        return this.fullNameToFieldType;
    }

    public Set<String> getCopyToDestinationFields() {
        return this.copyToDestinationFields;
    }
}

