/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http;

import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.http.HttpRouteStats;

public class HttpRouteStatsTracker {
    private static final int BUCKET_COUNT = HttpRouteStatsTracker.getBucketUpperBounds().length + 1;
    private static final int LAST_BUCKET_LOWER_BOUND = HttpRouteStatsTracker.getBucketUpperBounds()[BUCKET_COUNT - 2];
    private final StatsTracker requestStats = new StatsTracker();
    private final StatsTracker responseStats = new StatsTracker();
    private final HandlingTimeTracker responseTimeTracker = new HandlingTimeTracker();

    public static int[] getBucketUpperBounds() {
        int[] bounds = new int[31];
        for (int i = 0; i < bounds.length; ++i) {
            bounds[i] = 1 << i;
        }
        return bounds;
    }

    private static int bucket(long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            return HttpRouteStatsTracker.bucket(Integer.MAX_VALUE);
        }
        assert (contentLength >= 0L);
        return HttpRouteStatsTracker.bucket((int)contentLength);
    }

    private static int bucket(int contentLength) {
        if (contentLength <= 0) {
            return 0;
        }
        if (LAST_BUCKET_LOWER_BOUND <= contentLength) {
            return BUCKET_COUNT - 1;
        }
        return 32 - Integer.numberOfLeadingZeros(contentLength);
    }

    public void addRequestStats(int contentLength) {
        this.requestStats.addStats(contentLength);
    }

    public void addResponseStats(long contentLength) {
        this.responseStats.addStats(contentLength);
    }

    public void addResponseTime(long timeMillis) {
        this.responseTimeTracker.addHandlingTime(timeMillis);
    }

    public HttpRouteStats getStats() {
        return new HttpRouteStats(this.requestStats.count().longValue(), this.requestStats.totalSize().longValue(), this.requestStats.getHistogram(), this.responseStats.count().longValue(), this.responseStats.totalSize().longValue(), this.responseStats.getHistogram(), this.responseTimeTracker.getHistogram());
    }

    private record StatsTracker(LongAdder count, LongAdder totalSize, AtomicLongArray histogram) {
        StatsTracker {
            assert (count.longValue() == 0L);
            assert (totalSize.longValue() == 0L);
            assert (histogram.length() == BUCKET_COUNT);
        }

        StatsTracker() {
            this(new LongAdder(), new LongAdder(), new AtomicLongArray(BUCKET_COUNT));
        }

        void addStats(long contentLength) {
            this.count().increment();
            this.totalSize().add(contentLength);
            this.histogram().incrementAndGet(HttpRouteStatsTracker.bucket(contentLength));
        }

        long[] getHistogram() {
            long[] histogramCopy = new long[BUCKET_COUNT];
            for (int i = 0; i < BUCKET_COUNT; ++i) {
                histogramCopy[i] = this.histogram().get(i);
            }
            return histogramCopy;
        }
    }
}

