/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node;

import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class HealthIndicatorDisplayValues {
    public static String getNodeName(DiscoveryNode node) {
        if (node.getName() != null) {
            return String.format(Locale.ROOT, "[%s][%s]", node.getId(), node.getName());
        }
        return String.format(Locale.ROOT, "[%s]", node.getId());
    }

    public static String getTruncatedIndices(Set<String> indices, Metadata clusterMetadata) {
        int maxIndices = 10;
        Object truncatedIndicesString = indices.stream().sorted(HealthIndicatorDisplayValues.indicesComparatorByPriorityAndName(clusterMetadata)).limit(10L).collect(Collectors.joining(", "));
        if (10 < indices.size()) {
            truncatedIndicesString = (String)truncatedIndicesString + ", ...";
        }
        return truncatedIndicesString;
    }

    public static <T> String getSortedUniqueValuesString(Collection<T> values, Predicate<T> predicate, Function<T, String> toString) {
        return values.stream().filter(predicate).map(toString).distinct().sorted().collect(Collectors.joining(", "));
    }

    public static <T> String getSortedUniqueValuesString(Collection<T> values, Function<T, String> toString) {
        return values.stream().map(toString).distinct().sorted().collect(Collectors.joining(", "));
    }

    public static String indices(int count) {
        return count == 1 ? "index" : "indices";
    }

    public static String are(int count) {
        return count == 1 ? "is" : "are";
    }

    public static String these(int count) {
        return count == 1 ? "this" : "these";
    }

    public static String regularNoun(String noun, int count) {
        return count == 1 ? noun : noun + "s";
    }

    public static String regularVerb(String verb, int count) {
        return count == 1 ? verb + "s" : verb;
    }

    public static Comparator<String> indicesComparatorByPriorityAndName(Metadata clusterMetadata) {
        return Comparator.comparingInt(indexName -> {
            IndexMetadata indexMetadata = clusterMetadata.index((String)indexName);
            return indexMetadata == null ? -1 : indexMetadata.priority();
        }).reversed().thenComparing(Comparator.naturalOrder());
    }
}

