/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AbstractThrottledTaskRunner;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Releasable;

public class PrioritizedThrottledTaskRunner<T extends AbstractRunnable> {
    private final AbstractThrottledTaskRunner<TaskWrapper<T>> runner;
    private final PriorityBlockingQueue<TaskWrapper<T>> queue = new PriorityBlockingQueue();

    public PrioritizedThrottledTaskRunner(String name, int maxRunningTasks, Executor executor) {
        this.runner = new AbstractThrottledTaskRunner<TaskWrapper<TaskWrapper<T>>>(name, maxRunningTasks, executor, this.queue);
    }

    public void enqueueTask(T task) {
        this.runner.enqueueTask(new TaskWrapper<T>(task));
    }

    public int runningTasks() {
        return this.runner.runningTasks();
    }

    public int queueSize() {
        return this.queue.size();
    }

    private static class TaskWrapper<T extends AbstractRunnable>
    implements ActionListener<Releasable>,
    Comparable<TaskWrapper<T>> {
        private final T task;

        TaskWrapper(T task) {
            this.task = task;
        }

        @Override
        public int compareTo(TaskWrapper<T> o) {
            return ((Comparable)this.task).compareTo(o.task);
        }

        public String toString() {
            return this.task.toString();
        }

        @Override
        public void onResponse(Releasable releasable) {
            try (Releasable releasable2 = releasable;){
                ((AbstractRunnable)this.task).run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            assert (e instanceof EsRejectedExecutionException) : e;
            try {
                ((AbstractRunnable)this.task).onRejection(e);
            }
            finally {
                ((AbstractRunnable)this.task).onAfter();
            }
        }
    }
}

