/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public abstract class EsRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final CounterMetric rejected = new CounterMetric();
    private LongCounter rejectionCounter = null;

    public long rejected() {
        return this.rejected.count();
    }

    protected void incrementRejections() {
        this.rejected.inc();
        if (this.rejectionCounter != null) {
            this.rejectionCounter.increment();
        }
    }

    public void registerCounter(MeterRegistry meterRegistry, String metric_name, String threadpool_name) {
        this.rejectionCounter = meterRegistry.registerLongCounter(metric_name, "number of rejected threads for " + threadpool_name, "count");
        this.rejectionCounter.incrementBy(this.rejected());
    }

    protected static EsRejectedExecutionException newRejectedException(Runnable r, ThreadPoolExecutor executor, boolean isExecutorShutdown) {
        StringBuilder builder = new StringBuilder("rejected execution of ").append(r).append(" on ").append(executor);
        if (isExecutorShutdown) {
            builder.append(" (shutdown)");
        }
        return new EsRejectedExecutionException(builder.toString(), isExecutorShutdown);
    }
}

