/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.ByteUtils;

public final class Numbers {
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);

    private Numbers() {
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        return ByteUtils.readShortBE(bytes, offset);
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        return ByteUtils.readIntBE(bytes, offset);
    }

    public static long bytesToLong(byte[] bytes, int offset) {
        return ByteUtils.readLongBE(bytes, offset);
    }

    public static long bytesToLong(BytesRef bytes) {
        return Numbers.bytesToLong(bytes.bytes, bytes.offset);
    }

    public static byte[] intToBytes(int val) {
        byte[] arr = new byte[4];
        ByteUtils.writeIntBE(val, arr, 0);
        return arr;
    }

    public static byte[] shortToBytes(int val) {
        byte[] arr = new byte[2];
        ByteUtils.writeShortBE((short)val, arr, 0);
        return arr;
    }

    public static byte[] longToBytes(long val) {
        byte[] arr = new byte[8];
        ByteUtils.writeLongBE(val, arr, 0);
        return arr;
    }

    public static byte[] doubleToBytes(double val) {
        return Numbers.longToBytes(Double.doubleToRawLongBits(val));
    }

    public static boolean isValidDouble(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static long toLongExact(Number n) {
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return n.longValue();
        }
        if (n instanceof Float || n instanceof Double) {
            double d = n.doubleValue();
            if (d != (double)Math.round(d)) {
                throw new IllegalArgumentException(String.valueOf(n) + " is not an integer value");
            }
            return n.longValue();
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigIntegerExact().longValueExact();
        }
        if (n instanceof BigInteger) {
            return ((BigInteger)n).longValueExact();
        }
        throw new IllegalArgumentException("Cannot check whether [" + String.valueOf(n) + "] of class [" + n.getClass().getName() + "] is actually a long");
    }

    public static long toLong(String stringValue, boolean coerce) {
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigInteger bigIntegerValue;
            try {
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE) <= 0) {
                    throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
                }
                bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            if (bigIntegerValue.compareTo(MAX_LONG_VALUE) > 0 || bigIntegerValue.compareTo(MIN_LONG_VALUE) < 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
            }
            return bigIntegerValue.longValue();
        }
    }

    public static int toIntExact(Number n) {
        return Math.toIntExact(Numbers.toLongExact(n));
    }

    public static short toShortExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((short)l)) {
            throw new ArithmeticException("short overflow: " + l);
        }
        return (short)l;
    }

    public static byte toByteExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((byte)l)) {
            throw new ArithmeticException("byte overflow: " + l);
        }
        return (byte)l;
    }

    public static boolean isPositiveNumeric(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

