/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class NodeReplacementAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_replacement";
    static final Decision YES__RECONCILING = Decision.single(Decision.Type.YES, "node_replacement", "this decider is ignored during reconciliation", new Object[0]);
    static final Decision YES__NO_REPLACEMENTS = Decision.single(Decision.Type.YES, "node_replacement", "there are no ongoing node replacements", new Object[0]);
    static final Decision YES__NO_APPLICABLE_REPLACEMENTS = Decision.single(Decision.Type.YES, "node_replacement", "none of the ongoing node replacements relate to the allocation of this shard", new Object[0]);

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return YES__NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.replacementFromSourceToTarget(allocation, shardRouting.currentNodeId(), node.node().getName())) {
            return allocation.decision(Decision.YES, NAME, "node [%s] is replacing node [%s], and may receive shards from it", node.nodeId(), shardRouting.currentNodeId());
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, shardRouting.currentNodeId())) {
            if (allocation.isReconciling()) {
                return YES__RECONCILING;
            }
            return allocation.decision(Decision.NO, NAME, "node [%s] is being replaced, and its shards may only be allocated to the replacement target [%s]", shardRouting.currentNodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, shardRouting.currentNodeId()));
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.nodeId())) {
            return allocation.decision(Decision.NO, NAME, "node [%s] is being replaced by [%s], so no data may be allocated to it", node.nodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, node.nodeId()), shardRouting.currentNodeId());
        }
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.node().getName())) {
            if (allocation.isReconciling() && !shardRouting.unassigned()) {
                return YES__RECONCILING;
            }
            SingleNodeShutdownMetadata shutdown = allocation.replacementTargetShutdowns().get(node.node().getName());
            return allocation.decision(Decision.NO, NAME, "node [%s] is replacing the vacating node [%s], only data currently allocated to the source node may be allocated to it until the replacement is complete", node.nodeId(), shutdown == null ? null : shutdown.getNodeId(), shardRouting.currentNodeId());
        }
        return YES__NO_APPLICABLE_REPLACEMENTS;
    }

    @Override
    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return YES__NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.nodeId())) {
            return allocation.decision(Decision.NO, NAME, "node [%s] is being replaced by node [%s], so no data may remain on it", node.nodeId(), NodeReplacementAllocationDecider.getReplacementName(allocation, node.nodeId()));
        }
        return YES__NO_APPLICABLE_REPLACEMENTS;
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return YES__NO_REPLACEMENTS;
        }
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.getName())) {
            boolean hasShardsAllocatedOnSourceOrTarget;
            SingleNodeShutdownMetadata shutdown = allocation.replacementTargetShutdowns().get(node.getName());
            String sourceNodeId = shutdown != null ? shutdown.getNodeId() : null;
            boolean bl = hasShardsAllocatedOnSourceOrTarget = NodeReplacementAllocationDecider.hasShardOnNode(indexMetadata, node.getId(), allocation) || sourceNodeId != null && NodeReplacementAllocationDecider.hasShardOnNode(indexMetadata, sourceNodeId, allocation);
            if (hasShardsAllocatedOnSourceOrTarget) {
                return allocation.decision(Decision.YES, NAME, "node [%s] is a node replacement target for node [%s], shard can auto expand to it as it was already present on the source node", node.getId(), sourceNodeId);
            }
            return allocation.decision(Decision.NO, NAME, "node [%s] is a node replacement target for node [%s], shards cannot auto expand to be on it until the replacement is complete", node.getId(), sourceNodeId);
        }
        if (NodeReplacementAllocationDecider.isReplacementSource(allocation, node.getId())) {
            boolean hasShardOnSource;
            SingleNodeShutdownMetadata shutdown = allocation.getClusterState().metadata().nodeShutdowns().get(node.getId());
            String replacementNodeName = shutdown != null ? shutdown.getTargetNodeName() : null;
            boolean bl = hasShardOnSource = NodeReplacementAllocationDecider.hasShardOnNode(indexMetadata, node.getId(), allocation) && shutdown != null && !allocation.getClusterState().getNodes().hasByName(replacementNodeName);
            if (hasShardOnSource) {
                return allocation.decision(Decision.YES, NAME, "node [%s] is being replaced by [%s], shards can auto expand to be on it while replacement node has not joined the cluster", node.getId(), replacementNodeName);
            }
            return allocation.decision(Decision.NO, NAME, "node [%s] is being replaced by [%s], shards cannot auto expand to be on it", node.getId(), replacementNodeName);
        }
        return YES__NO_APPLICABLE_REPLACEMENTS;
    }

    private static boolean hasShardOnNode(IndexMetadata indexMetadata, String nodeId, RoutingAllocation allocation) {
        RoutingNode node = allocation.routingNodes().node(nodeId);
        return node != null && node.numberOfOwningShardsForIndex(indexMetadata.getIndex()) >= 1;
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (NodeReplacementAllocationDecider.replacementFromSourceToTarget(allocation, shardRouting.currentNodeId(), node.node().getName())) {
            return allocation.decision(Decision.YES, NAME, "node [%s] is being replaced by node [%s], and can be force vacated to the target", shardRouting.currentNodeId(), node.nodeId());
        }
        return allocation.decision(Decision.NO, NAME, "shard is not on the source of a node replacement relocated to the replacement target", new Object[0]);
    }

    @Override
    public Decision canAllocateReplicaWhenThereIsRetentionLease(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (NodeReplacementAllocationDecider.isReplacementTargetName(allocation, node.node().getName())) {
            return allocation.decision(Decision.YES, NAME, "node [%s] is a node replacement target and can have a previously allocated replica re-allocated to it", node.nodeId());
        }
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static boolean replacementOngoing(RoutingAllocation allocation) {
        return !allocation.replacementTargetShutdowns().isEmpty();
    }

    private static boolean replacementFromSourceToTarget(RoutingAllocation allocation, String sourceNodeId, String targetNodeName) {
        if (!NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        if (sourceNodeId == null || targetNodeName == null) {
            return false;
        }
        SingleNodeShutdownMetadata shutdown = allocation.metadata().nodeShutdowns().get(sourceNodeId, SingleNodeShutdownMetadata.Type.REPLACE);
        return shutdown != null && shutdown.getTargetNodeName().equals(targetNodeName);
    }

    private static boolean isReplacementSource(RoutingAllocation allocation, String nodeId) {
        if (nodeId == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        return allocation.metadata().nodeShutdowns().contains(nodeId, SingleNodeShutdownMetadata.Type.REPLACE);
    }

    private static boolean isReplacementTargetName(RoutingAllocation allocation, String nodeName) {
        if (nodeName == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return false;
        }
        return allocation.replacementTargetShutdowns().get(nodeName) != null;
    }

    private static String getReplacementName(RoutingAllocation allocation, String nodeIdBeingReplaced) {
        if (nodeIdBeingReplaced == null || !NodeReplacementAllocationDecider.replacementOngoing(allocation)) {
            return null;
        }
        SingleNodeShutdownMetadata metadata = allocation.metadata().nodeShutdowns().get(nodeIdBeingReplaced, SingleNodeShutdownMetadata.Type.REPLACE);
        return metadata != null ? metadata.getTargetNodeName() : null;
    }
}

