/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.routing.PlainShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.shard.ShardId;

public class PlainShardIterator
extends PlainShardsIterator
implements ShardIterator {
    private final ShardId shardId;

    public static PlainShardIterator allSearchableShards(ShardIterator shardIterator) {
        return new PlainShardIterator(shardIterator.shardId(), PlainShardIterator.shardsThatCanHandleSearches(shardIterator));
    }

    private static List<ShardRouting> shardsThatCanHandleSearches(ShardIterator iterator) {
        ArrayList<ShardRouting> shardsThatCanHandleSearches = new ArrayList<ShardRouting>(iterator.size());
        for (ShardRouting shardRouting : iterator) {
            if (!shardRouting.isSearchable()) continue;
            shardsThatCanHandleSearches.add(shardRouting);
        }
        return shardsThatCanHandleSearches;
    }

    public PlainShardIterator(ShardId shardId, List<ShardRouting> shards) {
        super(shards);
        this.shardId = shardId;
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardIterator that = (ShardIterator)o;
        return this.shardId.equals(that.shardId());
    }

    @Override
    public int hashCode() {
        return this.shardId.hashCode();
    }

    @Override
    public int compareTo(ShardIterator o) {
        return this.shardId.compareTo(o.shardId());
    }
}

