/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ItemUsage
implements Writeable,
ToXContentObject {
    private final Set<String> indices;
    private final Set<String> dataStreams;
    private final Set<String> composableTemplates;

    public ItemUsage(@Nullable Collection<String> indices, @Nullable Collection<String> dataStreams, @Nullable Collection<String> composableTemplates) {
        this.indices = indices == null ? null : new HashSet<String>(indices);
        this.dataStreams = dataStreams == null ? null : new HashSet<String>(dataStreams);
        this.composableTemplates = composableTemplates == null ? null : new HashSet<String>(composableTemplates);
    }

    public ItemUsage(StreamInput in) throws IOException {
        this.indices = in.readBoolean() ? in.readCollectionAsSet(StreamInput::readString) : null;
        this.dataStreams = in.readBoolean() ? in.readCollectionAsSet(StreamInput::readString) : null;
        this.composableTemplates = in.readBoolean() ? in.readCollectionAsSet(StreamInput::readString) : null;
    }

    public Set<String> getIndices() {
        return this.indices;
    }

    public Set<String> getDataStreams() {
        return this.dataStreams;
    }

    public Set<String> getComposableTemplates() {
        return this.composableTemplates;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indices != null) {
            builder.stringListField("indices", this.indices);
        }
        if (this.dataStreams != null) {
            builder.stringListField("data_streams", this.dataStreams);
        }
        if (this.composableTemplates != null) {
            builder.stringListField("composable_templates", this.composableTemplates);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalStringCollection(this.indices);
        out.writeOptionalStringCollection(this.dataStreams);
        out.writeOptionalStringCollection(this.composableTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.dataStreams, this.composableTemplates);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemUsage other = (ItemUsage)obj;
        return Objects.equals(this.indices, other.indices) && Objects.equals(this.dataStreams, other.dataStreams) && Objects.equals(this.composableTemplates, other.composableTemplates);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

