/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStateSerializationStats
implements Writeable,
ToXContentObject {
    public static final ClusterStateSerializationStats EMPTY = new ClusterStateSerializationStats(0L, 0L, 0L, 0L, 0L, 0L);
    private final long fullStateCount;
    private final long totalUncompressedFullStateBytes;
    private final long totalCompressedFullStateBytes;
    private final long diffCount;
    private final long totalUncompressedDiffBytes;
    private final long totalCompressedDiffBytes;

    public ClusterStateSerializationStats(long fullStateCount, long totalUncompressedFullStateBytes, long totalCompressedFullStateBytes, long diffCount, long totalUncompressedDiffBytes, long totalCompressedDiffBytes) {
        this.fullStateCount = fullStateCount;
        this.totalUncompressedFullStateBytes = totalUncompressedFullStateBytes;
        this.totalCompressedFullStateBytes = totalCompressedFullStateBytes;
        this.diffCount = diffCount;
        this.totalUncompressedDiffBytes = totalUncompressedDiffBytes;
        this.totalCompressedDiffBytes = totalCompressedDiffBytes;
    }

    public ClusterStateSerializationStats(StreamInput in) throws IOException {
        this.fullStateCount = in.readVLong();
        this.totalUncompressedFullStateBytes = in.readVLong();
        this.totalCompressedFullStateBytes = in.readVLong();
        this.diffCount = in.readVLong();
        this.totalUncompressedDiffBytes = in.readVLong();
        this.totalCompressedDiffBytes = in.readVLong();
    }

    public long getFullStateCount() {
        return this.fullStateCount;
    }

    public long getTotalUncompressedFullStateBytes() {
        return this.totalUncompressedFullStateBytes;
    }

    public long getTotalCompressedFullStateBytes() {
        return this.totalCompressedFullStateBytes;
    }

    public long getDiffCount() {
        return this.diffCount;
    }

    public long getTotalUncompressedDiffBytes() {
        return this.totalUncompressedDiffBytes;
    }

    public long getTotalCompressedDiffBytes() {
        return this.totalCompressedDiffBytes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("full_states");
        builder.field("count", this.fullStateCount);
        builder.humanReadableField("uncompressed_size_in_bytes", "uncompressed_size", (Object)ByteSizeValue.ofBytes(this.totalUncompressedFullStateBytes));
        builder.humanReadableField("compressed_size_in_bytes", "compressed_size", (Object)ByteSizeValue.ofBytes(this.totalCompressedFullStateBytes));
        builder.endObject();
        builder.startObject("diffs");
        builder.field("count", this.diffCount);
        builder.humanReadableField("uncompressed_size_in_bytes", "uncompressed_size", (Object)ByteSizeValue.ofBytes(this.totalUncompressedDiffBytes));
        builder.humanReadableField("compressed_size_in_bytes", "compressed_size", (Object)ByteSizeValue.ofBytes(this.totalCompressedDiffBytes));
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fullStateCount);
        out.writeVLong(this.totalUncompressedFullStateBytes);
        out.writeVLong(this.totalCompressedFullStateBytes);
        out.writeVLong(this.diffCount);
        out.writeVLong(this.totalUncompressedDiffBytes);
        out.writeVLong(this.totalCompressedDiffBytes);
    }
}

