/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.autosharding;

import java.util.Arrays;
import org.elasticsearch.action.datastreams.autosharding.AutoShardingType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public record AutoShardingResult(AutoShardingType type, int currentNumberOfShards, int targetNumberOfShards, TimeValue coolDownRemaining, @Nullable Double writeLoad) {
    static final String COOLDOWN_PREVENTING_TYPES = Arrays.toString((Object[])new AutoShardingType[]{AutoShardingType.COOLDOWN_PREVENTED_DECREASE, AutoShardingType.COOLDOWN_PREVENTED_INCREASE});
    public static final AutoShardingResult NOT_APPLICABLE_RESULT = new AutoShardingResult(AutoShardingType.NOT_APPLICABLE, -1, -1, TimeValue.MAX_VALUE, null);

    public AutoShardingResult {
        if ((type.equals((Object)AutoShardingType.INCREASE_SHARDS) || type.equals((Object)AutoShardingType.DECREASE_SHARDS)) && !coolDownRemaining.equals((Object)TimeValue.ZERO)) {
            throw new IllegalArgumentException("The increase/decrease shards events must have a cooldown period of zero. Use one of [" + COOLDOWN_PREVENTING_TYPES + "] types indead");
        }
    }
}

