/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.indices.analyze.TransportReloadAnalyzersAction;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ReloadAnalyzersResponse
extends BroadcastResponse {
    private final Map<String, ReloadDetails> reloadDetails;
    static final ParseField RELOAD_DETAILS_FIELD = new ParseField("reload_details", new String[0]);
    static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    static final ParseField RELOADED_ANALYZERS_FIELD = new ParseField("reloaded_analyzers", new String[0]);
    static final ParseField RELOADED_NODE_IDS_FIELD = new ParseField("reloaded_node_ids", new String[0]);

    public ReloadAnalyzersResponse(StreamInput in) throws IOException {
        super(in);
        this.reloadDetails = in.readMap(ReloadDetails::new);
    }

    public ReloadAnalyzersResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, ReloadDetails> reloadedIndicesNodes) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.reloadDetails = reloadedIndicesNodes;
    }

    public final Map<String, ReloadDetails> getReloadDetails() {
        return this.reloadDetails;
    }

    @Override
    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(RELOAD_DETAILS_FIELD.getPreferredName());
        for (Map.Entry<String, ReloadDetails> indexDetails : this.reloadDetails.entrySet()) {
            builder.startObject();
            ReloadDetails value = indexDetails.getValue();
            builder.field(INDEX_FIELD.getPreferredName(), value.getIndexName());
            builder.stringListField(RELOADED_ANALYZERS_FIELD.getPreferredName(), value.getReloadedAnalyzers());
            builder.stringListField(RELOADED_NODE_IDS_FIELD.getPreferredName(), value.getReloadedIndicesNodes());
            builder.endObject();
        }
        builder.endArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.reloadDetails, StreamOutput::writeWriteable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReloadAnalyzersResponse that = (ReloadAnalyzersResponse)o;
        return Objects.equals(this.reloadDetails, that.reloadDetails);
    }

    public int hashCode() {
        return Objects.hash(this.reloadDetails);
    }

    public static class ReloadDetails
    implements Writeable {
        private final String indexName;
        private final Set<String> reloadedIndicesNodes;
        private final Set<String> reloadedAnalyzers;

        public ReloadDetails(String name, Set<String> reloadedIndicesNodes, Set<String> reloadedAnalyzers) {
            this.indexName = name;
            this.reloadedIndicesNodes = reloadedIndicesNodes;
            this.reloadedAnalyzers = reloadedAnalyzers;
        }

        ReloadDetails(StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.reloadedIndicesNodes = new HashSet<String>(in.readCollectionAsList(StreamInput::readString));
            this.reloadedAnalyzers = new HashSet<String>(in.readCollectionAsList(StreamInput::readString));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            out.writeStringCollection(this.reloadedIndicesNodes);
            out.writeStringCollection(this.reloadedAnalyzers);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public Set<String> getReloadedIndicesNodes() {
            return this.reloadedIndicesNodes;
        }

        public Set<String> getReloadedAnalyzers() {
            return this.reloadedAnalyzers;
        }

        void merge(TransportReloadAnalyzersAction.ReloadResult other) {
            assert (this.indexName.equals(other.index));
            this.reloadedAnalyzers.addAll(other.reloadedSearchAnalyzers);
            this.reloadedIndicesNodes.add(other.nodeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReloadDetails that = (ReloadDetails)o;
            return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.reloadedIndicesNodes, that.reloadedIndicesNodes) && Objects.equals(this.reloadedAnalyzers, that.reloadedAnalyzers);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.reloadedIndicesNodes, this.reloadedAnalyzers);
        }
    }
}

