/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class NodePrevalidateShardPathResponse
extends BaseNodeResponse {
    private final Set<ShardId> shardIds;

    protected NodePrevalidateShardPathResponse(DiscoveryNode node, Set<ShardId> shardIds) {
        super(node);
        this.shardIds = Set.copyOf((Collection)Objects.requireNonNull(shardIds));
    }

    protected NodePrevalidateShardPathResponse(StreamInput in) throws IOException {
        super(in);
        this.shardIds = in.readCollectionAsImmutableSet(ShardId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.shardIds);
    }

    public Set<ShardId> getShardIds() {
        return this.shardIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePrevalidateShardPathResponse)) {
            return false;
        }
        NodePrevalidateShardPathResponse other = (NodePrevalidateShardPathResponse)o;
        return Objects.equals(this.shardIds, other.shardIds) && Objects.equals(this.getNode(), other.getNode());
    }

    public int hashCode() {
        return Objects.hash(this.shardIds, this.getNode());
    }
}

