/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodeHotThreads;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import org.elasticsearch.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.monitor.jvm.HotThreads;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesHotThreadsAction
extends TransportNodesAction<NodesHotThreadsRequest, NodesHotThreadsResponse, NodeRequest, NodeHotThreads, Void> {
    public static final ActionType<NodesHotThreadsResponse> TYPE = new ActionType("cluster:monitor/nodes/hot_threads");

    @Inject
    public TransportNodesHotThreadsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodeRequest::new, threadPool.executor("generic"));
    }

    @Override
    protected NodesHotThreadsResponse newResponse(NodesHotThreadsRequest request, List<NodeHotThreads> responses, List<FailedNodeException> failures) {
        return new NodesHotThreadsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(NodesHotThreadsRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeHotThreads newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeHotThreads(in);
    }

    @Override
    protected NodeHotThreads nodeOperation(NodeRequest request, Task task) {
        HotThreads hotThreads = new HotThreads().busiestThreads(request.requestOptions.threads()).type(request.requestOptions.reportType()).sortOrder(request.requestOptions.sortOrder()).interval(request.requestOptions.interval()).threadElementsSnapshotCount(request.requestOptions.snapshots()).ignoreIdleThreads(request.requestOptions.ignoreIdleThreads());
        RecyclerBytesStreamOutput out = this.transportService.newNetworkBytesStream();
        Releasable trackedResource = LeakTracker.wrap(out);
        boolean success = false;
        try {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)Streams.flushOnCloseStream(out), StandardCharsets.UTF_8);){
                hotThreads.detect(writer);
            }
            NodeHotThreads result = new NodeHotThreads(this.clusterService.localNode(), new ReleasableBytesReference(out.bytes(), trackedResource));
            success = true;
            NodeHotThreads nodeHotThreads = result;
            return nodeHotThreads;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to detect hot threads", (Throwable)e, new Object[0]);
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)trackedResource);
            }
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        final HotThreads.RequestOptions requestOptions;

        NodeRequest(NodesHotThreadsRequest request) {
            this.requestOptions = request.requestOptions;
        }

        NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.requestOptions = HotThreads.RequestOptions.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.requestOptions.writeTo(out);
        }
    }
}

