/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import co.elastic.apm.agent.premain.ExcludeJvmBootstrapCheck;
import co.elastic.apm.agent.premain.JavaVersionBootstrapCheck;
import co.elastic.apm.agent.premain.JvmToolBootstrapCheck;
import co.elastic.apm.agent.premain.VerifyNoneBootstrapCheck;
import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;
import co.elastic.apm.agent.premain.common.util.SystemStandardOutputLogger;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;

class BootstrapChecks {
    private final List<BootstrapCheck> bootstrapChecks;
    private final boolean bootstrapChecksEnabled;

    BootstrapChecks(boolean bootstrapChecksEnabled, BootstrapCheck ... bootstrapChecks) {
        this.bootstrapChecks = Arrays.asList(bootstrapChecks);
        this.bootstrapChecksEnabled = bootstrapChecksEnabled;
    }

    static BootstrapChecks defaults() {
        if (System.getSecurityManager() == null) {
            return BootstrapChecks.createDefaults();
        }
        return AccessController.doPrivileged(new PrivilegedAction<BootstrapChecks>(){

            @Override
            public BootstrapChecks run() {
                return BootstrapChecks.createDefaults();
            }
        });
    }

    private static BootstrapChecks createDefaults() {
        boolean bootstrapChecksDisabled = Boolean.parseBoolean(System.getProperty("elastic.apm.disable_bootstrap_checks")) || Boolean.parseBoolean(System.getenv("ELASTIC_APM_DISABLE_BOOTSTRAP_CHECKS"));
        String cmd = System.getProperty("sun.java.command");
        return new BootstrapChecks(!bootstrapChecksDisabled, new JavaVersionBootstrapCheck(JvmRuntimeInfo.ofCurrentVM()), new VerifyNoneBootstrapCheck(ManagementFactory.getRuntimeMXBean()), new JvmToolBootstrapCheck(cmd), new ExcludeJvmBootstrapCheck(cmd));
    }

    boolean isPassing() {
        BootstrapCheck.BootstrapCheckResult result = new BootstrapCheck.BootstrapCheckResult();
        for (BootstrapCheck check : this.bootstrapChecks) {
            check.doBootstrapCheck(result);
        }
        if (result.isEmpty()) {
            return true;
        }
        boolean isPassing = true;
        if (result.hasErrors()) {
            if (this.bootstrapChecksEnabled) {
                isPassing = false;
                SystemStandardOutputLogger.stdErrWarn("Failed to start agent because of failing bootstrap checks.");
                SystemStandardOutputLogger.stdErrInfo("To override Java bootstrap checks, set the 'elastic.apm.disable_bootstrap_checks' System property, or the `ELASTIC_APM_DISABLE_BOOTSTRAP_CHECKS` environment variable, `to 'true'.");
            } else {
                SystemStandardOutputLogger.stdErrWarn("Bootstrap checks have failed. The agent will still start because bootstrap check have been disabled.");
            }
            SystemStandardOutputLogger.stdErrInfo("Note that we can not offer support for issues related to disabled bootstrap checks.");
            for (String msg : result.getErrors()) {
                SystemStandardOutputLogger.stdErrError(msg);
            }
        }
        if (result.hasWarnings()) {
            for (String msg : result.getWarnings()) {
                SystemStandardOutputLogger.stdErrWarn(msg);
            }
        }
        return isPassing;
    }
}

