/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.MaxScoreCollector;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.join.mapper.Joiner;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;

class ParentChildInnerHitContextBuilder
extends InnerHitContextBuilder {
    private final String typeName;
    private final boolean fetchChildInnerHits;

    ParentChildInnerHitContextBuilder(String typeName, boolean fetchChildInnerHits, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
        super(query, innerHitBuilder, children);
        this.typeName = typeName;
        this.fetchChildInnerHits = fetchChildInnerHits;
    }

    protected void doBuild(SearchContext context, InnerHitsContext innerHitsContext) throws IOException {
        SearchExecutionContext searchExecutionContext = context.getSearchExecutionContext();
        Joiner joiner = Joiner.getJoiner(searchExecutionContext);
        if (joiner != null) {
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.typeName;
            JoinFieldInnerHitSubContext joinFieldInnerHits = new JoinFieldInnerHitSubContext(name, context, this.typeName, this.fetchChildInnerHits, joiner);
            this.setupInnerHitsContext(searchExecutionContext, joinFieldInnerHits);
            innerHitsContext.addInnerHitDefinition((InnerHitsContext.InnerHitSubContext)joinFieldInnerHits);
        } else if (!this.innerHitBuilder.isIgnoreUnmapped()) {
            throw new IllegalStateException("no join field has been configured");
        }
    }

    static final class JoinFieldInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final String typeName;
        private final boolean fetchChildInnerHits;
        private final Joiner joiner;

        JoinFieldInnerHitSubContext(String name, SearchContext context, String typeName, boolean fetchChildInnerHits, Joiner joiner) {
            super(name, context);
            this.typeName = typeName;
            this.fetchChildInnerHits = fetchChildInnerHits;
            this.joiner = joiner;
        }

        public TopDocsAndMaxScore topDocs(SearchHit hit) throws IOException {
            TopScoreDocCollector topDocsCollector;
            Query q;
            Weight innerHitQueryWeight = this.getInnerHitQueryWeight();
            String joinName = JoinFieldInnerHitSubContext.getSortedDocValue(this.joiner.getJoinField(), this.context, hit.docId());
            if (joinName == null) {
                return new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
            }
            SearchExecutionContext context = this.context.getSearchExecutionContext();
            if (this.fetchChildInnerHits) {
                TermQuery hitQuery = new TermQuery(new Term(this.joiner.parentJoinField(this.typeName), hit.getId()));
                q = new BooleanQuery.Builder().add((Query)hitQuery, BooleanClause.Occur.FILTER).add((Query)new TermQuery(new Term(this.joiner.getJoinField(), this.typeName)), BooleanClause.Occur.FILTER).build();
            } else {
                String parentId = JoinFieldInnerHitSubContext.getSortedDocValue(this.joiner.childJoinField(this.typeName), this.context, hit.docId());
                if (parentId == null) {
                    return new TopDocsAndMaxScore(Lucene.EMPTY_TOP_DOCS, Float.NaN);
                }
                q = this.context.getSearchExecutionContext().getFieldType("_id").termQuery((Object)parentId, context);
            }
            Weight weight = this.context.searcher().createWeight(this.context.searcher().rewrite(q), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            if (this.size() == 0) {
                TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                    InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)totalHitCountCollector, (LeafReaderContext)ctx);
                }
                return new TopDocsAndMaxScore(new TopDocs(new TotalHits((long)totalHitCountCollector.getTotalHits(), TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN);
            }
            int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
            MaxScoreCollector maxScoreCollector = null;
            if (this.sort() != null) {
                topDocsCollector = new TopFieldCollectorManager(this.sort().sort, topN, null, Integer.MAX_VALUE, false).newCollector();
                if (this.trackScores()) {
                    maxScoreCollector = new MaxScoreCollector();
                }
            } else {
                topDocsCollector = new TopScoreDocCollectorManager(topN, null, Integer.MAX_VALUE, false).newCollector();
                maxScoreCollector = new MaxScoreCollector();
            }
            for (LeafReaderContext ctx : this.context.searcher().getIndexReader().leaves()) {
                InnerHitsContext.intersect((Weight)weight, (Weight)innerHitQueryWeight, (Collector)MultiCollector.wrap((Collector[])new Collector[]{topDocsCollector, maxScoreCollector}), (LeafReaderContext)ctx);
            }
            TopDocs topDocs = topDocsCollector.topDocs(this.from(), this.size());
            float maxScore = Float.NaN;
            if (maxScoreCollector != null) {
                maxScore = maxScoreCollector.getMaxScore();
            }
            return new TopDocsAndMaxScore(topDocs, maxScore);
        }

        private static String getSortedDocValue(String field, SearchContext context, int docId) {
            try {
                List ctxs = context.searcher().getIndexReader().leaves();
                LeafReaderContext ctx = (LeafReaderContext)ctxs.get(ReaderUtil.subIndex((int)docId, (List)ctxs));
                SortedDocValues docValues = ctx.reader().getSortedDocValues(field);
                int segmentDocId = docId - ctx.docBase;
                if (docValues == null || !docValues.advanceExact(segmentDocId)) {
                    return null;
                }
                int ord = docValues.ordValue();
                BytesRef joinName = docValues.lookupOrd(ord);
                return joinName.utf8ToString();
            }
            catch (IOException e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }
}

