/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import java.util.Arrays;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.AccessAnyD;
import org.ojalgo.structure.FactoryAnyD;
import org.ojalgo.structure.MutateAnyD;
import org.ojalgo.tensor.ArrayBasedTensor;
import org.ojalgo.tensor.TensorFactoryAnyD;

public final class AnyTensor<N extends Comparable<N>>
extends ArrayBasedTensor<N, AnyTensor<N>>
implements AccessAnyD<N>,
MutateAnyD.Receiver<N> {
    private final ArrayAnyD<N> myArray;
    private final ArrayAnyD.Factory<N> myFactory;

    public static <N extends Comparable<N>> TensorFactoryAnyD<N, AnyTensor<N>> factory(DenseArray.Factory<N> arrayFactory) {
        return new TensorFactoryAnyD(new Factory<N>(arrayFactory));
    }

    AnyTensor(ArrayAnyD.Factory<N> factory, int rank, int dimensions) {
        super(rank, dimensions, factory.function(), factory.scalar());
        long[] shape = new long[rank];
        Arrays.fill(shape, (long)dimensions);
        this.myFactory = factory;
        this.myArray = factory.make(shape);
    }

    @Override
    public AnyTensor<N> add(AnyTensor<N> addend) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.add(((AnyTensor)retVal).getArray(), this.myArray, addend);
        return retVal;
    }

    @Override
    public AnyTensor<N> conjugate() {
        ArrayBasedTensor retVal = this.newSameShape();
        ArrayAnyD<N> array = ((AnyTensor)retVal).getArray();
        long[] transp = (long[])((AnyTensor)retVal).shape().clone();
        int max = this.rank() - 1;
        array.loopAll((long[] ref) -> {
            for (int i = 0; i < transp.length; ++i) {
                transp[max - i] = ref[i];
            }
            array.set(transp, this.myArray.doubleValue(ref));
        });
        return retVal;
    }

    @Override
    public long count(int dimension) {
        return this.myArray.count(dimension);
    }

    @Override
    public double doubleValue(long[] ref) {
        return this.myArray.doubleValue(ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof AnyTensor)) {
            return false;
        }
        AnyTensor other = (AnyTensor)obj;
        if (this.myArray == null ? other.myArray != null : !this.myArray.equals(other.myArray)) {
            return false;
        }
        return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myArray.fillOne(index, values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myArray.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<?> supplier) {
        this.myArray.fillOne(index, supplier);
    }

    @Override
    public void fillOne(long[] reference, N value) {
        this.myArray.fillOne(reference, value);
    }

    @Override
    public void fillOne(long[] reference, NullaryFunction<?> supplier) {
        this.myArray.fillOne(reference, supplier);
    }

    @Override
    public void fillSet(int dimension, long dimensionalIndex, N value) {
        this.myArray.fillSet(dimension, dimensionalIndex, value);
    }

    @Override
    public void fillSet(int dimension, long dimensionalIndex, NullaryFunction<?> supplier) {
        this.myArray.fillSet(dimension, dimensionalIndex, supplier);
    }

    @Override
    public void fillSet(long[] initial, int dimension, N value) {
        this.myArray.fillSet(initial, dimension, value);
    }

    @Override
    public void fillSet(long[] initial, int dimension, NullaryFunction<?> supplier) {
        this.myArray.fillSet(initial, dimension, supplier);
    }

    @Override
    public N get(long[] ref) {
        return this.myArray.get(ref);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myArray == null ? 0 : this.myArray.hashCode());
        result = 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        return result;
    }

    @Override
    public AnyTensor<N> multiply(double scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((AnyTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public AnyTensor<N> multiply(N scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((AnyTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public AnyTensor<N> negate() {
        ArrayBasedTensor retVal = this.newSameShape();
        this.negate(((AnyTensor)retVal).getArray(), this.myArray);
        return retVal;
    }

    @Override
    public double norm() {
        return this.norm(this.myArray);
    }

    @Override
    public void set(long[] reference, Comparable<?> value) {
        this.myArray.set(reference, value);
    }

    @Override
    public void set(long[] reference, double value) {
        this.myArray.set(reference, value);
    }

    @Override
    public long[] shape() {
        return this.myArray.shape();
    }

    public String toString() {
        return AccessAnyD.toString(this.myArray);
    }

    ArrayAnyD<N> getArray() {
        return this.myArray;
    }

    @Override
    AnyTensor<N> newSameShape() {
        return new AnyTensor<N>(this.myFactory, this.rank(), this.dimensions());
    }

    static final class Factory<N extends Comparable<N>>
    extends ArrayBasedTensor.Factory<N>
    implements FactoryAnyD<AnyTensor<N>> {
        private final ArrayAnyD.Factory<N> myFactory;

        Factory(DenseArray.Factory<N> arrayFactory) {
            super(arrayFactory);
            this.myFactory = ArrayAnyD.factory(arrayFactory);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Factory)) {
                return false;
            }
            Factory other = (Factory)obj;
            return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
            return result;
        }

        @Override
        public AnyTensor<N> make(long ... structure) {
            int rank = structure.length;
            long dimensions = structure[0];
            if (rank <= 0 || dimensions <= 0L) {
                throw new IllegalArgumentException();
            }
            for (int i = 1; i < rank; ++i) {
                if (structure[i] == dimensions) continue;
                throw new IllegalArgumentException();
            }
            return new AnyTensor<N>(this.myFactory, rank, Math.toIntExact(dimensions));
        }
    }
}

