/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractContinuous;
import org.ojalgo.random.Normal;
import org.ojalgo.random.SampleSet;
import org.ojalgo.structure.Access1D;

public class LogNormal
extends AbstractContinuous {
    private final Normal myNormal;

    public static LogNormal estimate(Access1D<?> rawSamples) {
        int size = rawSamples.size();
        Array1D logSamples = (Array1D)Array1D.PRIMITIVE64.make(size);
        for (int i = 0; i < size; ++i) {
            logSamples.set((long)i, PrimitiveMath.LOG.invoke(rawSamples.doubleValue(i)));
        }
        SampleSet sampleSet = SampleSet.wrap(logSamples);
        return new LogNormal(sampleSet.getMean(), sampleSet.getStandardDeviation());
    }

    public static LogNormal make(double mean, double variance) {
        double tmpVar = PrimitiveMath.LOG1P.invoke(variance / (mean * mean));
        double location = PrimitiveMath.LOG.invoke(mean) - PrimitiveMath.HALF * tmpVar;
        double scale = PrimitiveMath.SQRT.invoke(tmpVar);
        return new LogNormal(location, scale);
    }

    public LogNormal() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public LogNormal(double location, double scale) {
        this.myNormal = new Normal(location, scale);
    }

    @Override
    public double getDensity(double value) {
        return this.myNormal.getDensity(PrimitiveMath.LOG.invoke(value)) / value;
    }

    @Override
    public double getDistribution(double value) {
        return this.myNormal.getDistribution(PrimitiveMath.LOG.invoke(value));
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.EXP.invoke(this.myNormal.getExpected() + this.myNormal.getVariance() * PrimitiveMath.HALF);
    }

    public double getGeometricMean() {
        return PrimitiveMath.EXP.invoke(this.myNormal.getExpected());
    }

    public double getGeometricStandardDeviation() {
        return PrimitiveMath.EXP.invoke(this.myNormal.getStandardDeviation());
    }

    @Override
    public double getQuantile(double probability) {
        this.checkProbabilty(probability);
        return PrimitiveMath.EXP.invoke(this.myNormal.getQuantile(probability));
    }

    @Override
    public double getVariance() {
        double tmpVariance = this.myNormal.getVariance();
        return PrimitiveMath.EXPM1.invoke(tmpVariance) * PrimitiveMath.EXP.invoke(PrimitiveMath.TWO * this.myNormal.getExpected() + tmpVariance);
    }

    @Override
    public void setSeed(long seed) {
        this.myNormal.setSeed(seed);
    }

    @Override
    protected double generate() {
        return PrimitiveMath.EXP.invoke(this.myNormal.generate());
    }
}

