/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.BasicLogger;

public final class ResourceLocator {
    public static KeyedValues DEFAULTS = new KeyedValues();
    static final String UTF_8 = StandardCharsets.UTF_8.name();
    private transient Request myRequest = null;
    private final Session mySession = new Session();

    public static Session session() {
        return new Session();
    }

    static String urldecode(String encoded) {
        try {
            return URLDecoder.decode(encoded, UTF_8);
        }
        catch (UnsupportedEncodingException exception) {
            return null;
        }
    }

    static String urlencode(String unencoded) {
        try {
            return URLEncoder.encode(unencoded, UTF_8);
        }
        catch (UnsupportedEncodingException exception) {
            return null;
        }
    }

    public ResourceLocator() {
    }

    public ResourceLocator(String url) {
        this.myRequest = this.mySession.request(url);
    }

    public ResourceLocator form(String key, String value) {
        this.request().form(key, value);
        return this;
    }

    public ResourceLocator fragment(String fragment) {
        this.request().fragment(fragment);
        return this;
    }

    public Reader getStreamReader() {
        return this.response().getStreamReader();
    }

    public ResourceLocator host(String host) {
        this.request().host(host);
        return this;
    }

    public ResourceLocator method(Method method) {
        this.request().method(method);
        return this;
    }

    public ResourceLocator path(String path) {
        this.request().path(path);
        return this;
    }

    public ResourceLocator port(int port) {
        this.request().port(port);
        return this;
    }

    public ResourceLocator query(String key, String value) {
        this.request().query(key, value);
        return this;
    }

    public ResourceLocator scheme(String scheme) {
        this.request().scheme(scheme);
        return this;
    }

    public String toString() {
        return this.request().toString();
    }

    private Request request() {
        if (this.myRequest == null) {
            this.myRequest = this.mySession.request();
        }
        return this.myRequest;
    }

    private Response response() {
        return new Response(this.request());
    }

    public static final class Session
    implements BasicLogger.Printable {
        private final CookieManager myCookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        private final KeyedValues myParameters = new KeyedValues(DEFAULTS.getValues());

        Session() {
            CookieHandler.setDefault(this.myCookieManager);
        }

        public String getParameterValue(String key) {
            return this.myParameters.get(key);
        }

        public Session parameter(String key, String value) {
            if (value != null) {
                this.myParameters.put(key, value);
            } else {
                this.myParameters.remove(key);
            }
            return this;
        }

        @Override
        public void print(BasicLogger.Printer receiver) {
            receiver.println("Session parameters: {}", this.myParameters);
            receiver.println("Session cookies: {}", this.myCookieManager.getCookieStore().getCookies());
        }

        public Request request() {
            return new Request(this);
        }

        public Request request(String url) {
            try {
                return new Request(this, new URL(url));
            }
            catch (MalformedURLException exception) {
                throw new ProgrammingError(exception);
            }
        }

        public void reset() {
            this.myParameters.clear();
            this.myCookieManager.getCookieStore().removeAll();
        }

        CookieManager getCookieManager() {
            return this.myCookieManager;
        }
    }

    public static final class Response
    implements BasicLogger.Printable {
        private final URLConnection myConnection;
        private final Session mySession;
        private transient String myString;

        Response(Request request) {
            String form;
            this.mySession = request.getSession();
            this.myConnection = request.newConnection();
            if (this.myConnection instanceof HttpURLConnection) {
                request.configure((HttpURLConnection)this.myConnection);
            }
            if ((form = request.form()) != null && form.length() > 0) {
                this.myConnection.setDoOutput(true);
                try (DataOutputStream output = new DataOutputStream(this.myConnection.getOutputStream());){
                    output.write(form.getBytes(UTF_8));
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }

        public Request getRequest() {
            return new Request(this.mySession, this.myConnection.getURL());
        }

        public int getStatusCode() {
            if (this.myConnection instanceof HttpURLConnection) {
                try {
                    return ((HttpURLConnection)this.myConnection).getResponseCode();
                }
                catch (IOException exception) {
                    return -1;
                }
            }
            return -1;
        }

        public Reader getStreamReader() {
            return new InputStreamReader(this.getInputStream());
        }

        public boolean isResponseOK() {
            int statusCode = this.getStatusCode();
            return 200 <= statusCode && statusCode < 300;
        }

        @Override
        public void print(BasicLogger.Printer receiver) {
            receiver.println("Response body: {}", this.toString());
            receiver.println("Response headers: {}", this.myConnection.getHeaderFields());
            receiver.println("<Recreated>");
            this.getRequest().print(receiver);
            receiver.println("</Recreated>");
            this.mySession.print(receiver);
        }

        public String toString() {
            if (this.myString == null) {
                StringBuilder builder = new StringBuilder();
                String line = null;
                try (BufferedReader reader = new BufferedReader(this.getStreamReader());){
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                this.myString = builder.toString();
            }
            return this.myString;
        }

        InputStream getInputStream() {
            InputStream retVal = null;
            try {
                retVal = this.myConnection.getInputStream();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            return retVal;
        }
    }

    public static final class Request
    implements BasicLogger.Printable {
        private final KeyedValues myForm = new KeyedValues();
        private String myFragment = null;
        private String myHost = null;
        private Method myMethod = Method.GET;
        private String myPath = "";
        private int myPort = -1;
        private final KeyedValues myQuery = new KeyedValues();
        private String myScheme = "https";
        private final Session mySession;

        Request(Session session) {
            this.mySession = session;
        }

        Request(Session session, URL url) {
            this.mySession = session;
            this.myScheme = url.getProtocol();
            this.myHost = url.getHost();
            this.myPort = url.getPort();
            this.myPath = url.getPath();
            this.myQuery.parse(url.getQuery());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Request)) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.myForm, other.myForm) && Objects.equals(this.myFragment, other.myFragment) && Objects.equals(this.myHost, other.myHost) && this.myMethod == other.myMethod && Objects.equals(this.myPath, other.myPath) && this.myPort == other.myPort && Objects.equals(this.myQuery, other.myQuery) && Objects.equals(this.myScheme, other.myScheme) && Objects.equals(this.mySession, other.mySession);
        }

        public Request form(String form) {
            this.myQuery.parse(form);
            return this;
        }

        public Request form(String key, String value) {
            ProgrammingError.throwIfNull((Object)key);
            if (value != null) {
                this.myForm.put(key, value);
            } else {
                this.myForm.remove(key);
            }
            return this;
        }

        public Request fragment(String fragment) {
            this.myFragment = fragment;
            return this;
        }

        public String getFormValue(String key) {
            return this.myForm.get(key);
        }

        public String getQueryValue(String key) {
            return this.myQuery.get(key);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myForm, this.myFragment, this.myHost, this.myMethod, this.myPath, this.myPort, this.myQuery, this.myScheme, this.mySession});
        }

        public Request host(String host) {
            this.myHost = host;
            return this;
        }

        public Request method(Method method) {
            this.myMethod = method;
            return this;
        }

        public Request path(String path) {
            ProgrammingError.throwIfNull((Object)path);
            this.myPath = path;
            return this;
        }

        public Request port(int port) {
            this.myPort = port;
            return this;
        }

        @Override
        public void print(BasicLogger.Printer receiver) {
            this.mySession.print(receiver);
            receiver.println("Request URL: {}", this.toURL());
            if (this.myForm.size() > 0) {
                receiver.println("Request form: {}", this.myForm);
            }
        }

        public Request query(String query) {
            this.myQuery.parse(query);
            return this;
        }

        public Request query(String key, String value) {
            ProgrammingError.throwIfNull((Object)key);
            if (value != null) {
                this.myQuery.put(key, value);
            } else {
                this.myQuery.remove(key);
            }
            return this;
        }

        public Response response() {
            return new Response(this);
        }

        public Request scheme(String scheme) {
            this.myScheme = scheme;
            return this;
        }

        public String toString() {
            return this.toURL().toString();
        }

        private String query() {
            if (this.myQuery.isEmpty()) {
                return null;
            }
            return this.myQuery.toString();
        }

        private URL toURL() {
            try {
                URI uri = new URI(this.myScheme, null, this.myHost, this.myPort, this.myPath, this.query(), this.myFragment);
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException xcptn) {
                throw new ProgrammingError(xcptn);
            }
        }

        void configure(HttpURLConnection connection) {
            try {
                connection.setRequestMethod(this.myMethod.name());
            }
            catch (ProtocolException exception) {
                throw new ProgrammingError(exception);
            }
        }

        String form() {
            if (this.myForm.isEmpty()) {
                return null;
            }
            return this.myForm.toString();
        }

        Session getSession() {
            return this.mySession;
        }

        URLConnection newConnection() {
            URLConnection retVal = null;
            try {
                CookieHandler.setDefault(this.mySession.getCookieManager());
                retVal = this.toURL().openConnection();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            return retVal;
        }
    }

    public static enum Method {
        DELETE,
        GET,
        HEAD,
        OPTIONS,
        POST,
        PUT,
        TRACE;

    }

    public static class KeyedValues
    implements Map<String, String> {
        private final Set<String> myOrderedKeys = new LinkedHashSet<String>();
        private final Properties myValues;

        public KeyedValues() {
            this.myValues = new Properties();
        }

        KeyedValues(Properties defaults) {
            this.myValues = new Properties(defaults);
        }

        @Override
        public void clear() {
            this.myOrderedKeys.clear();
            this.myValues.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.myValues.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.myValues.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.myValues.entrySet().stream().map(e -> new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return e.getKey().toString();
                }

                @Override
                public String getValue() {
                    return e.getValue().toString();
                }

                @Override
                public String setValue(String value) {
                    String prev = e.getValue().toString();
                    e.setValue(value);
                    return prev;
                }
            }).collect(Collectors.toSet());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof KeyedValues)) {
                return false;
            }
            KeyedValues other = (KeyedValues)obj;
            return Objects.equals(this.myOrderedKeys, other.myOrderedKeys) && Objects.equals(this.myValues, other.myValues);
        }

        @Override
        public String get(Object key) {
            return this.myValues.getProperty(key.toString());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.myOrderedKeys, this.myValues);
        }

        @Override
        public boolean isEmpty() {
            return this.myValues.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.myValues.stringPropertyNames();
        }

        public void parse(String keysAndValues) {
            if (keysAndValues != null) {
                String[] pairs = keysAndValues.split("&");
                for (int i = 0; i < pairs.length; ++i) {
                    String pair = pairs[i];
                    int split = pair.indexOf("=");
                    String key = pair.substring(0, split);
                    String value = pair.substring(split + 1);
                    this.put(key, value);
                }
            }
        }

        @Override
        public String put(String key, String value) {
            this.myOrderedKeys.add(key);
            return String.valueOf(this.myValues.setProperty(key, value));
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.myValues.putAll(m);
        }

        @Override
        public String remove(Object key) {
            this.myOrderedKeys.remove(key);
            Object removed = this.myValues.remove(key);
            return removed != null ? removed.toString() : null;
        }

        @Override
        public int size() {
            return this.myValues.size();
        }

        public String toString() {
            return this.myOrderedKeys.stream().map(key -> key + "=" + this.myValues.getProperty((String)key)).collect(Collectors.joining("&"));
        }

        @Override
        public Collection<String> values() {
            return this.myValues.values().stream().map(Object::toString).collect(Collectors.toList());
        }

        Set<String> getOrderedKeys() {
            return this.myOrderedKeys;
        }

        Properties getValues() {
            return this.myValues;
        }
    }
}

