/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import java.util.function.DoubleConsumer;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.structure.Structure2D;

public final class VisitAll
implements ArrayOperation {
    public static int THRESHOLD = 128;

    public static void visit(double[] target, DoubleConsumer visitor) {
        VisitAll.visit(target, 0, target.length, visitor);
    }

    public static void visit(double[] target, int first, int limit, DoubleConsumer visitor) {
        int lim = Math.min(limit, target.length);
        for (int i = first; i < lim; ++i) {
            visitor.accept(target[i]);
        }
    }

    public static void visitAll(double[][] target, DoubleConsumer visitor) {
        int tmpLength = target.length;
        for (int i = 0; i < tmpLength; ++i) {
            int tmpInnerLength = target[i].length;
            for (int j = 0; j < tmpInnerLength; ++j) {
                visitor.accept(target[i][j]);
            }
        }
    }

    public static void visitColumn(double[][] target, int row, int col, DoubleConsumer visitor) {
        int limit = target.length;
        for (int i = row; i < limit; ++i) {
            visitor.accept(target[i][col]);
        }
    }

    public static void visitDiagonal(double[][] target, int row, int col, DoubleConsumer visitor) {
        int limit = target.length;
        int ij = 0;
        while (row + ij < limit && col + ij < target[row + ij].length) {
            visitor.accept(target[row + ij][col + ij]);
            ++ij;
        }
    }

    public static void visitRange(double[][] target, int first, int limit, DoubleConsumer visitor) {
        int tmpStructure = target.length;
        for (int index = first; index < limit; ++index) {
            visitor.accept(target[Structure2D.row(index, tmpStructure)][Structure2D.column(index, tmpStructure)]);
        }
    }

    public static void visitRow(double[][] target, int row, int col, DoubleConsumer visitor) {
        double[] targetRow = target[row];
        int limit = targetRow.length;
        for (int j = col; j < limit; ++j) {
            visitor.accept(targetRow[j]);
        }
    }
}

