/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;

final class GoogleCloudStorageOperationsStats {
    private final AtomicLong getCount = new AtomicLong();
    private final AtomicLong listCount = new AtomicLong();
    private final AtomicLong putCount = new AtomicLong();
    private final AtomicLong postCount = new AtomicLong();
    private final String bucketName;

    GoogleCloudStorageOperationsStats(String bucketName) {
        this.bucketName = bucketName;
    }

    void trackGetOperation() {
        this.getCount.incrementAndGet();
    }

    void trackPutOperation() {
        this.putCount.incrementAndGet();
    }

    void trackPostOperation() {
        this.postCount.incrementAndGet();
    }

    void trackListOperation() {
        this.listCount.incrementAndGet();
    }

    String getTrackedBucket() {
        return this.bucketName;
    }

    Map<String, BlobStoreActionStats> toMap() {
        HashMap<String, BlobStoreActionStats> results = new HashMap<String, BlobStoreActionStats>();
        long getOperations = this.getCount.get();
        results.put("GetObject", new BlobStoreActionStats(getOperations, getOperations));
        long listOperations = this.listCount.get();
        results.put("ListObjects", new BlobStoreActionStats(listOperations, listOperations));
        long insertOperations = this.postCount.get() + this.putCount.get();
        results.put("InsertObject", new BlobStoreActionStats(insertOperations, insertOperations));
        return results;
    }
}

