/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class ReplaceStatsFilteredAggWithEval
extends OptimizerRules.OptimizerRule<Aggregate> {
    @Override
    protected LogicalPlan rule(Aggregate aggregate) {
        int oldAggSize = aggregate.aggregates().size();
        ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(oldAggSize);
        ArrayList<Alias> newEvals = new ArrayList<Alias>(oldAggSize);
        ArrayList<Attribute> newProjections = new ArrayList<Attribute>(oldAggSize);
        for (NamedExpression namedExpression : aggregate.aggregates()) {
            Literal literal;
            AggregateFunction aggFunction;
            Alias alias;
            Expression expression;
            if (namedExpression instanceof Alias && (expression = (alias = (Alias)namedExpression).child()) instanceof AggregateFunction && (aggFunction = (AggregateFunction)expression).hasFilter() && (expression = aggFunction.filter()) instanceof Literal && Boolean.FALSE.equals((literal = (Literal)expression).value())) {
                Long value = aggFunction instanceof Count || aggFunction instanceof CountDistinct ? Long.valueOf(0L) : null;
                Alias newAlias = alias.replaceChild((Expression)Literal.of((Expression)aggFunction, (Object)value));
                newEvals.add(newAlias);
                newProjections.add(newAlias.toAttribute());
                continue;
            }
            newAggs.add(namedExpression);
            newProjections.add(namedExpression.toAttribute());
        }
        LogicalPlan plan = aggregate;
        if (!newEvals.isEmpty()) {
            if (newAggs.isEmpty()) {
                plan = ReplaceStatsFilteredAggWithEval.localRelation(aggregate.source(), newEvals);
            } else {
                plan = aggregate.with(aggregate.child(), aggregate.groupings(), newAggs);
                plan = new Eval(aggregate.source(), plan, newEvals);
                plan = new Project(aggregate.source(), plan, newProjections);
            }
        }
        return plan;
    }

    private static LocalRelation localRelation(Source source, List<Alias> newEvals) {
        Block[] blocks = new Block[newEvals.size()];
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(newEvals.size());
        for (int i = 0; i < newEvals.size(); ++i) {
            Alias alias = newEvals.get(i);
            attributes.add(alias.toAttribute());
            blocks[i] = BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, (Object)((Literal)alias.child()).value(), (int)1);
        }
        return new LocalRelation(source, attributes, LocalSupplier.of(blocks));
    }
}

