/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.fulltext;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.esql.parser.ParsingException;

abstract class FullTextUtils {
    private static final String DELIMITER = ";";

    FullTextUtils() {
    }

    static Map<String, String> parseSettings(String options, Source source) {
        if (!Strings.hasText((String)options)) {
            return Collections.emptyMap();
        }
        String[] list = Strings.delimitedListToStringArray((String)options, (String)DELIMITER);
        LinkedHashMap op = Maps.newLinkedHashMapWithExpectedSize((int)list.length);
        for (String entry : list) {
            String[] split = FullTextUtils.splitInTwo(entry, "=");
            if (split == null) {
                throw new ParsingException(source, "Cannot parse entry {} in options {}", entry, options);
            }
            String previous = op.put(split[0], split[1]);
            if (previous == null) continue;
            throw new ParsingException(source, "Duplicate option {} detected in options {}", entry, options);
        }
        return op;
    }

    static Map<String, Float> parseFields(Map<String, String> options, Source source) {
        return FullTextUtils.parseFields(options.get("fields"), source);
    }

    static Map<String, Float> parseFields(String fieldString, Source source) {
        if (!Strings.hasText((String)fieldString)) {
            return Collections.emptyMap();
        }
        Set fieldNames = Strings.commaDelimitedListToSet((String)fieldString);
        Float defaultBoost = Float.valueOf(1.0f);
        LinkedHashMap<String, Float> fields = new LinkedHashMap<String, Float>();
        for (String fieldName : fieldNames) {
            if (fieldName.contains("^")) {
                String[] split = FullTextUtils.splitInTwo(fieldName, "^");
                if (split == null) {
                    fields.put(fieldName, defaultBoost);
                    continue;
                }
                try {
                    fields.put(split[0], Float.valueOf(Float.parseFloat(split[1])));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new ParsingException(source, "Cannot parse boosting for {}", fieldName);
                }
            }
            fields.put(fieldName, defaultBoost);
        }
        return fields;
    }

    private static String[] splitInTwo(String string, String delimiter) {
        String[] split = Strings.split((String)string, (String)delimiter);
        if (split == null || split.length != 2) {
            return null;
        }
        return split;
    }

    static FullTextPredicate.Operator operator(Map<String, String> options, String key) {
        String value = options.get(key);
        return value != null ? FullTextPredicate.Operator.valueOf(value.toUpperCase(Locale.ROOT)) : null;
    }
}

