/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjointGeoSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;

public class SpatialDisjoint
extends SpatialRelatesFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "SpatialDisjoint", SpatialDisjoint::new);
    public static final SpatialRelatesFunction.SpatialRelations GEO = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.DISJOINT, SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "ST_Disjoint"));
    public static final SpatialRelatesFunction.SpatialRelations CARTESIAN = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.DISJOINT, SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("ST_Disjoint"));
    private static final Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorMap = new HashMap();

    @FunctionInfo(returnType={"boolean"}, description="Returns whether the two geometries or geometry columns are disjoint.\nThis is the inverse of the <<esql-st_intersects,ST_INTERSECTS>> function.\nIn mathematical terms: ST_Disjoint(A, B) \u21d4 A \u22c2 B = \u2205", examples={@Example(file="spatial_shapes", tag="st_disjoint-airport_city_boundaries")})
    public SpatialDisjoint(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Expression of type `geo_point`, `cartesian_point`, `geo_shape` or `cartesian_shape`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_*` and `cartesian_*` parameters.") Expression right) {
        this(source, left, right, false, false);
    }

    private SpatialDisjoint(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues);
    }

    private SpatialDisjoint(StreamInput in) throws IOException {
        super(in, false, false);
    }

    public String getWriteableName() {
        return SpatialDisjoint.ENTRY.name;
    }

    @Override
    public ShapeRelation queryRelation() {
        return ShapeRelation.DISJOINT;
    }

    @Override
    public SpatialDisjoint withDocValues(boolean foundLeft, boolean foundRight) {
        boolean leftDV = this.leftDocValues || foundLeft;
        boolean rightDV = this.rightDocValues || foundRight;
        return new SpatialDisjoint(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    protected SpatialDisjoint replaceChildren(Expression newLeft, Expression newRight) {
        return new SpatialDisjoint(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, SpatialDisjoint::new, (Object)this.left(), (Object)this.right());
    }

    public Object fold(FoldContext ctx) {
        try {
            GeometryDocValueReader docValueReader = SpatialRelatesUtils.asGeometryDocValueReader(ctx, this.crsType(), this.left());
            Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(ctx, this.crsType(), this.right());
            return this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.geometryRelatesGeometry(docValueReader, component2D) : CARTESIAN.geometryRelatesGeometry(docValueReader, component2D);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to fold constant fields: " + e.getMessage(), e);
        }
    }

    @Override
    Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules() {
        return evaluatorMap;
    }

    static void processGeoSourceAndConstant(BooleanBlock.Builder results, int p, BytesRefBlock left, Component2D right) throws IOException {
        GEO.processSourceAndConstant(results, p, left, right);
    }

    static void processGeoSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        GEO.processSourceAndSource(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D right) throws IOException {
        GEO.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processGeoPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        GEO.processPointDocValuesAndSource(builder, p, left, right);
    }

    static void processCartesianSourceAndConstant(BooleanBlock.Builder builder, int p, BytesRefBlock left, Component2D right) throws IOException {
        CARTESIAN.processSourceAndConstant(builder, p, left, right);
    }

    static void processCartesianSourceAndSource(BooleanBlock.Builder builder, int p, BytesRefBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processSourceAndSource(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndConstant(BooleanBlock.Builder builder, int p, LongBlock left, Component2D right) throws IOException {
        CARTESIAN.processPointDocValuesAndConstant(builder, p, left, right);
    }

    static void processCartesianPointDocValuesAndSource(BooleanBlock.Builder builder, int p, LongBlock left, BytesRefBlock right) throws IOException {
        CARTESIAN.processPointDocValuesAndSource(builder, p, left, right);
    }

    static {
        for (DataType spatialType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.GEO_POINT, DataType.GEO_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointGeoSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointGeoSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointGeoPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointGeoPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
        for (DataType spatialType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
            for (DataType otherType : new DataType[]{DataType.CARTESIAN_POINT, DataType.CARTESIAN_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointCartesianSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointCartesianSourceAndConstantEvaluator.Factory::new)));
                if (!DataType.isSpatialPoint((DataType)spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointCartesianPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialDisjointCartesianPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
    }
}

