/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYGeometry;

public class LuceneComponent2DUtils {
    public static Component2D[] createLatLonComponents(LatLonGeometry ... latLonGeometries) {
        if (latLonGeometries == null) {
            throw new IllegalArgumentException("geometries must not be null");
        }
        if (latLonGeometries.length == 0) {
            throw new IllegalArgumentException("geometries must not be empty");
        }
        ArrayList<Component2D> components = new ArrayList<Component2D>(latLonGeometries.length);
        for (int i = 0; i < latLonGeometries.length; ++i) {
            Rectangle rectangle;
            if (latLonGeometries[i] == null) {
                throw new IllegalArgumentException("geometries[" + i + "] must not be null");
            }
            LatLonGeometry latLonGeometry = latLonGeometries[i];
            if (latLonGeometry instanceof Rectangle && (rectangle = (Rectangle)latLonGeometry).crossesDateline()) {
                LuceneComponent2DUtils.addRectangle(components, rectangle);
                continue;
            }
            components.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{latLonGeometries[i]}));
        }
        return components.toArray(new Component2D[0]);
    }

    private static void addRectangle(List<Component2D> components, Rectangle rectangle) {
        boolean crossesDateline;
        double minLongitude = rectangle.minLon;
        boolean bl = crossesDateline = rectangle.minLon > rectangle.maxLon;
        if (minLongitude == 180.0 && crossesDateline) {
            minLongitude = -180.0;
            crossesDateline = false;
        }
        if (crossesDateline) {
            Rectangle left = new Rectangle(rectangle.minLat, rectangle.maxLat, -180.0, rectangle.maxLon);
            Rectangle right = new Rectangle(rectangle.minLat, rectangle.maxLat, minLongitude, 180.0);
            components.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{left}));
            components.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{right}));
        } else {
            components.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{rectangle}));
        }
    }

    public static Component2D[] createXYComponents(XYGeometry ... xyGeometries) {
        if (xyGeometries == null) {
            throw new IllegalArgumentException("geometries must not be null");
        }
        if (xyGeometries.length == 0) {
            throw new IllegalArgumentException("geometries must not be empty");
        }
        Component2D[] components = new Component2D[xyGeometries.length];
        for (int i = 0; i < xyGeometries.length; ++i) {
            if (xyGeometries[i] == null) {
                throw new IllegalArgumentException("geometries[" + i + "] must not be null");
            }
            components[i] = XYGeometry.create((XYGeometry[])new XYGeometry[]{xyGeometries[i]});
        }
        return components;
    }
}

