/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SqrtUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class Sqrt
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Sqrt", Sqrt::new);

    @FunctionInfo(returnType={"double"}, description="Returns the square root of a number. The input can be any numeric value, the return value is always a double.\nSquare roots of negative numbers and infinities are null.", examples={@Example(file="math", tag="sqrt")})
    public Sqrt(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Sqrt(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Sqrt.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataType.DOUBLE) {
            return new SqrtDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.INTEGER) {
            return new SqrtIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.LONG) {
            return new SqrtLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return new SqrtUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    static double process(double val) {
        if (val < 0.0) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    static double process(long val) {
        if (val < 0L) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    static double processUnsignedLong(long val) {
        return Math.sqrt(EsqlDataTypeConverter.unsignedLongToDouble(val));
    }

    static double process(int val) {
        if (val < 0) {
            throw new ArithmeticException("Square root of negative");
        }
        return Math.sqrt(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Sqrt(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Sqrt::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }
}

