/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.HypotEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Hypot
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Hypot", Hypot::new);
    private final Expression n1;
    private final Expression n2;

    @FunctionInfo(returnType={"double"}, description="Returns the hypotenuse of two numbers. The input can be any numeric values, the return value is always a double.\nHypotenuses of infinities are null.", examples={@Example(file="math", tag="hypot")})
    public Hypot(Source source, @Param(name="number1", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n1, @Param(name="number2", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n2) {
        super(source, List.of(n1, n2));
        this.n1 = n1;
        this.n2 = n2;
    }

    private Hypot(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.n1);
        out.writeNamedWriteable((NamedWriteable)this.n2);
    }

    public String getWriteableName() {
        return Hypot.ENTRY.name;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Hypot(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Hypot::new, (Object)this.n1, (Object)this.n2);
    }

    static double process(double n1, double n2) {
        return Math.hypot(n1, n2);
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.n1, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.n2, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory n1Eval = Cast.cast(this.source(), this.n1.dataType(), DataType.DOUBLE, toEvaluator.apply(this.n1));
        EvalOperator.ExpressionEvaluator.Factory n2Eval = Cast.cast(this.source(), this.n2.dataType(), DataType.DOUBLE, toEvaluator.apply(this.n2));
        return new HypotEvaluator.Factory(this.source(), n1Eval, n2Eval);
    }

    public Expression n1() {
        return this.n1;
    }

    public Expression n2() {
        return this.n2;
    }
}

