/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ExpDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ExpIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ExpLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.ExpUnsignedLongEvaluator;

public class Exp
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Exp", Exp::new);

    @FunctionInfo(returnType={"double"}, description="Returns the value of e raised to the power of the given number.", examples={@Example(file="math", tag="exp")})
    public Exp(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Exp(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Exp.ENTRY.name;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataType.DOUBLE) {
            return new ExpDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.INTEGER) {
            return new ExpIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.LONG) {
            return new ExpLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataType.UNSIGNED_LONG) {
            return new ExpUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Exp(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Exp::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    static double process(double val) {
        return Math.exp(val);
    }

    static double process(int val) {
        return Math.exp(val);
    }

    static double process(long val) {
        return Math.exp(val);
    }

    static double processUnsignedLong(long val) {
        return Math.exp(NumericUtils.unsignedLongToDouble((long)val));
    }
}

