/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;

public final class AbsIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator fieldVal;
    private final DriverContext driverContext;
    private Warnings warnings;

    public AbsIntEvaluator(Source source, EvalOperator.ExpressionEvaluator fieldVal, DriverContext driverContext) {
        this.source = source;
        this.fieldVal = fieldVal;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock fieldValBlock = (IntBlock)this.fieldVal.eval(page);){
            IntVector fieldValVector = fieldValBlock.asVector();
            if (fieldValVector == null) {
                IntBlock intBlock = this.eval(page.getPositionCount(), fieldValBlock);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), fieldValVector).asBlock();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntBlock fieldValBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldValBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldValBlock.getValueCount(p) != 1) {
                    if (fieldValBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Abs.process(fieldValBlock.getInt(fieldValBlock.getFirstValueIndex(p))));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector fieldValVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Abs.process(fieldValVector.getInt(p)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "AbsIntEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.fieldVal);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory fieldVal;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory fieldVal) {
            this.source = source;
            this.fieldVal = fieldVal;
        }

        public AbsIntEvaluator get(DriverContext context) {
            return new AbsIntEvaluator(this.source, this.fieldVal.get(context), context);
        }

        public String toString() {
            return "AbsIntEvaluator[fieldVal=" + String.valueOf(this.fieldVal) + "]";
        }
    }
}

