/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.reindex.UpdateByQueryMetrics;
import org.elasticsearch.script.CtxMap;
import org.elasticsearch.script.Metadata;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.UpdateByQueryMetadata;
import org.elasticsearch.script.UpdateByQueryScript;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkByScrollResponse> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final UpdateByQueryMetrics updateByQueryMetrics;

    @Inject
    public TransportUpdateByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService, @Nullable UpdateByQueryMetrics updateByQueryMetrics) {
        super("indices:data/write/update/byquery", transportService, actionFilters, UpdateByQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.updateByQueryMetrics = updateByQueryMetrics;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        long startTime = System.nanoTime();
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, (ActionType<BulkByScrollResponse>)UpdateByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ClusterState state = this.clusterService.state();
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncIndexBySearchAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, this.scriptService, request, state, (ActionListener<BulkByScrollResponse>)ActionListener.runAfter((ActionListener)listener, () -> {
                long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
                if (this.updateByQueryMetrics != null) {
                    this.updateByQueryMetrics.recordTookTime(elapsedTime);
                }
            })).start();
        });
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<UpdateByQueryRequest, TransportUpdateByQueryAction> {
        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ScriptService scriptService, UpdateByQueryRequest request, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            super(task, request.getSearchRequest().source() != null && Boolean.TRUE.equals(request.getSearchRequest().source().version()), true, logger, client, threadPool, request, listener, scriptService, null);
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this.worker, this.scriptService, script, script.getParams(), () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.id(doc.getId());
            index.source(doc.getSource(), doc.getXContentType());
            index.setIfSeqNo(doc.getSeqNo());
            index.setIfPrimaryTerm(doc.getPrimaryTerm());
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        static class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier<UpdateByQueryMetadata> {
            private UpdateByQueryScript.Factory update = null;

            UpdateByQueryScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params, LongSupplier nowInMillisSupplier) {
                super(taskWorker, scriptService, script, params, nowInMillisSupplier);
            }

            @Override
            protected CtxMap<UpdateByQueryMetadata> execute(ScrollableHitSource.Hit doc, Map<String, Object> source) {
                if (this.update == null) {
                    this.update = (UpdateByQueryScript.Factory)this.scriptService.compile(this.script, UpdateByQueryScript.CONTEXT);
                }
                CtxMap ctxMap = new CtxMap(source, (Metadata)new UpdateByQueryMetadata(doc.getIndex(), doc.getId(), doc.getVersion(), doc.getRouting(), "index", this.nowInMillisSupplier.getAsLong()));
                this.update.newInstance(this.params, ctxMap).execute();
                return ctxMap;
            }

            @Override
            protected void updateRequest(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, UpdateByQueryMetadata metadata) {
            }
        }
    }
}

