/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionRequestTaskSettings;

public class OpenAiChatCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "openai_completion_task_settings";
    private final String user;

    public static OpenAiChatCompletionTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiChatCompletionTaskSettings(user);
    }

    public OpenAiChatCompletionTaskSettings(@Nullable String user) {
        this.user = user;
    }

    public OpenAiChatCompletionTaskSettings(StreamInput in) throws IOException {
        this.user = in.readOptionalString();
    }

    public boolean isEmpty() {
        return this.user == null;
    }

    public static OpenAiChatCompletionTaskSettings of(OpenAiChatCompletionTaskSettings originalSettings, OpenAiChatCompletionRequestTaskSettings requestSettings) {
        String userToUse = requestSettings.user() == null ? originalSettings.user : requestSettings.user();
        return new OpenAiChatCompletionTaskSettings(userToUse);
    }

    public String user() {
        return this.user;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.user != null) {
            builder.field("user", this.user);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OpenAiChatCompletionTaskSettings that = (OpenAiChatCompletionTaskSettings)object;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        OpenAiChatCompletionRequestTaskSettings updatedSettings = OpenAiChatCompletionRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return OpenAiChatCompletionTaskSettings.of(this, updatedSettings);
    }
}

