/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.completion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockConstants;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionRequestTaskSettings;

public class AmazonBedrockChatCompletionTaskSettings
implements TaskSettings {
    public static final String NAME = "amazon_bedrock_chat_completion_task_settings";
    public static final AmazonBedrockChatCompletionRequestTaskSettings EMPTY_SETTINGS = new AmazonBedrockChatCompletionRequestTaskSettings(null, null, null, null);
    private final Double temperature;
    private final Double topP;
    private final Double topK;
    private final Integer maxNewTokens;

    public static AmazonBedrockChatCompletionTaskSettings fromMap(Map<String, Object> settings) {
        ValidationException validationException = new ValidationException();
        Double temperature = ServiceUtils.extractOptionalDoubleInRange(settings, "temperature", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Double topP = ServiceUtils.extractOptionalDoubleInRange(settings, "top_p", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Double topK = ServiceUtils.extractOptionalDoubleInRange(settings, "top_k", AmazonBedrockConstants.MIN_TEMPERATURE_TOP_P_TOP_K_VALUE, AmazonBedrockConstants.MAX_TEMPERATURE_TOP_P_TOP_K_VALUE, "task_settings", validationException);
        Integer maxNewTokens = ServiceUtils.extractOptionalPositiveInteger(settings, "max_new_tokens", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AmazonBedrockChatCompletionTaskSettings(temperature, topP, topK, maxNewTokens);
    }

    public static AmazonBedrockChatCompletionTaskSettings of(AmazonBedrockChatCompletionTaskSettings originalSettings, AmazonBedrockChatCompletionRequestTaskSettings requestSettings) {
        Double temperature = requestSettings.temperature() == null ? originalSettings.temperature() : requestSettings.temperature();
        Double topP = requestSettings.topP() == null ? originalSettings.topP() : requestSettings.topP();
        Double topK = requestSettings.topK() == null ? originalSettings.topK() : requestSettings.topK();
        Integer maxNewTokens = requestSettings.maxNewTokens() == null ? originalSettings.maxNewTokens() : requestSettings.maxNewTokens();
        return new AmazonBedrockChatCompletionTaskSettings(temperature, topP, topK, maxNewTokens);
    }

    public AmazonBedrockChatCompletionTaskSettings(@Nullable Double temperature, @Nullable Double topP, @Nullable Double topK, @Nullable Integer maxNewTokens) {
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxNewTokens = maxNewTokens;
    }

    public AmazonBedrockChatCompletionTaskSettings(StreamInput in) throws IOException {
        this.temperature = in.readOptionalDouble();
        this.topP = in.readOptionalDouble();
        this.topK = in.readOptionalDouble();
        this.maxNewTokens = in.readOptionalVInt();
    }

    public Double temperature() {
        return this.temperature;
    }

    public Double topP() {
        return this.topP;
    }

    public Double topK() {
        return this.topK;
    }

    public Integer maxNewTokens() {
        return this.maxNewTokens;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.temperature);
        out.writeOptionalDouble(this.topP);
        out.writeOptionalDouble(this.topK);
        out.writeOptionalVInt(this.maxNewTokens);
    }

    public boolean isEmpty() {
        return this.temperature == null && this.topP == null && this.topK == null && this.maxNewTokens == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.temperature != null) {
            builder.field("temperature", this.temperature);
        }
        if (this.topP != null) {
            builder.field("top_p", this.topP);
        }
        if (this.topK != null) {
            builder.field("top_k", this.topK);
        }
        if (this.maxNewTokens != null) {
            builder.field("max_new_tokens", this.maxNewTokens);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonBedrockChatCompletionTaskSettings that = (AmazonBedrockChatCompletionTaskSettings)o;
        return Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.topK, that.topK) && Objects.equals(this.maxNewTokens, that.maxNewTokens);
    }

    public int hashCode() {
        return Objects.hash(this.temperature, this.topP, this.topK, this.maxNewTokens);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AmazonBedrockChatCompletionRequestTaskSettings requestSettings = AmazonBedrockChatCompletionRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AmazonBedrockChatCompletionTaskSettings.of(this, requestSettings);
    }
}

