/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class AmazonBedrockRequestManager
implements RequestManager {
    protected final ThreadPool threadPool;
    protected final TimeValue timeout;
    private final AmazonBedrockModel baseModel;

    protected AmazonBedrockRequestManager(AmazonBedrockModel baseModel, ThreadPool threadPool, @Nullable TimeValue timeout) {
        this.baseModel = Objects.requireNonNull(baseModel);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.timeout = timeout;
    }

    @Override
    public String inferenceEntityId() {
        return this.baseModel.getInferenceEntityId();
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.baseModel.rateLimitSettings();
    }

    @Override
    public Object rateLimitGrouping() {
        return RateLimitGrouping.of(this.baseModel);
    }

    record RateLimitGrouping(int keyHash) {
        public static RateLimitGrouping of(AmazonBedrockModel model) {
            Objects.requireNonNull(model);
            AmazonBedrockSecretSettings awsSecretSettings = model.getSecretSettings();
            return new RateLimitGrouping(Objects.hash(awsSecretSettings.accessKey, awsSecretSettings.secretKey));
        }
    }
}

