/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.eql.EqlIllegalArgumentException;

public class ExecutionUtils {
    private static NamedWriteableRegistry registry = new NamedWriteableRegistry(new SearchModule(Settings.EMPTY, List.of()).getNamedWriteables());

    /*
     * Enabled aggressive exception aggregation
     */
    public static SearchSourceBuilder copySource(SearchSourceBuilder source) {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            SearchSourceBuilder searchSourceBuilder;
            source.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), registry);){
                searchSourceBuilder = new SearchSourceBuilder((StreamInput)in);
            }
            return searchSourceBuilder;
        }
        catch (IOException e) {
            throw new EqlIllegalArgumentException("Error copying search source", e);
        }
    }
}

