/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.capacity.nodeinfo;

import org.elasticsearch.common.unit.Processors;

public record AutoscalingNodeInfo(long memory, Processors processors) {
    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private Long memory;
        private Processors processors;

        Builder() {
        }

        Builder setMemory(long memory) {
            this.memory = memory;
            return this;
        }

        Builder setProcessors(double processors) {
            this.processors = Processors.of((Double)processors);
            return this;
        }

        boolean canBuild() {
            return this.memory != null && this.processors != null;
        }

        AutoscalingNodeInfo build() {
            assert (this.memory != null && this.processors != null) : "unexpected null values when building node memory and processors information";
            return new AutoscalingNodeInfo(this.memory, this.processors);
        }
    }
}

