/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.arrow.memory.util.StackTrace;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;

public class HistoricalLog {
    private final @UnknownKeyFor @NonNull @Initialized LinkedList<@UnknownKeyFor @NonNull @Initialized Event> history = new LinkedList();
    private final @UnknownKeyFor @NonNull @Initialized String idString;
    private final @UnknownKeyFor @NonNull @Initialized int limit;
    private @Nullable @UnknownKeyFor @Initialized Event firstEvent;

    public HistoricalLog(@UnknownKeyFor @NonNull @Initialized String idStringFormat, Object ... args) {
        this(Integer.MAX_VALUE, idStringFormat, args);
    }

    public HistoricalLog(@UnknownKeyFor @NonNull @Initialized int limit, @UnknownKeyFor @NonNull @Initialized String idStringFormat, Object ... args) {
        this.limit = limit;
        this.idString = String.format(idStringFormat, args);
        this.firstEvent = null;
    }

    public synchronized void recordEvent(@UnknownKeyFor @NonNull @Initialized String noteFormat, Object ... args) {
        String note = String.format(noteFormat, args);
        Event event = new Event(note);
        if (this.firstEvent == null) {
            this.firstEvent = event;
        }
        if (this.history.size() == this.limit) {
            this.history.removeFirst();
        }
        this.history.add(event);
    }

    public void buildHistory(@UnknownKeyFor @NonNull @Initialized StringBuilder sb, @UnknownKeyFor @NonNull @Initialized boolean includeStackTrace) {
        this.buildHistory(sb, 0, includeStackTrace);
    }

    public synchronized void buildHistory(@UnknownKeyFor @NonNull @Initialized StringBuilder sb, @UnknownKeyFor @NonNull @Initialized int indent, @UnknownKeyFor @NonNull @Initialized boolean includeStackTrace) {
        char[] indentation = new char[indent];
        char[] innerIndentation = new char[indent + 2];
        Arrays.fill(indentation, ' ');
        Arrays.fill(innerIndentation, ' ');
        sb.append(indentation).append("event log for: ").append(this.idString).append('\n');
        if (this.firstEvent != null) {
            long time = this.firstEvent.time;
            String note = this.firstEvent.note;
            StackTrace stackTrace = this.firstEvent.stackTrace;
            sb.append(innerIndentation).append(time).append(' ').append(note).append('\n');
            if (includeStackTrace) {
                stackTrace.writeToBuilder(sb, indent + 2);
            }
            for (Event event : this.history) {
                if (event == this.firstEvent) continue;
                sb.append(innerIndentation).append("  ").append(event.time).append(' ').append(event.note).append('\n');
                if (!includeStackTrace) continue;
                event.stackTrace.writeToBuilder(sb, indent + 2);
                sb.append('\n');
            }
        }
    }

    public void logHistory(@UnknownKeyFor @NonNull @Initialized Logger logger) {
        StringBuilder sb = new StringBuilder();
        this.buildHistory(sb, 0, true);
        logger.debug(sb.toString());
    }

    private static class Event {
        private final @UnknownKeyFor @NonNull @Initialized String note;
        private final @UnknownKeyFor @NonNull @Initialized StackTrace stackTrace;
        private final @UnknownKeyFor @NonNull @Initialized long time;

        public Event(@UnknownKeyFor @NonNull @Initialized String note) {
            this.note = note;
            this.time = System.nanoTime();
            this.stackTrace = new StackTrace();
        }
    }
}

