/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseAllocator.Config", generator="Immutables")
@Immutable
final class ImmutableConfig
extends BaseAllocator.Config {
    private final  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory allocationManagerFactory;
    private final @UnknownKeyFor @NonNull @Initialized AllocationListener listener;
    private final @UnknownKeyFor @NonNull @Initialized long initReservation;
    private final @UnknownKeyFor @NonNull @Initialized long maxAllocation;
    private final @UnknownKeyFor @NonNull @Initialized RoundingPolicy roundingPolicy;
    private static final @UnknownKeyFor @NonNull @Initialized byte STAGE_INITIALIZING = -1;
    private static final @UnknownKeyFor @NonNull @Initialized byte STAGE_UNINITIALIZED = 0;
    private static final @UnknownKeyFor @NonNull @Initialized byte STAGE_INITIALIZED = 1;
    private volatile transient @UnknownKeyFor @NonNull @Initialized ImmutableConfig. @UnknownKeyFor @NonNull @Initialized InitShim initShim = new InitShim();

    private ImmutableConfig(@UnknownKeyFor @NonNull @Initialized Builder builder) {
        if (builder.allocationManagerFactory != null) {
            this.initShim.allocationManagerFactory(builder.allocationManagerFactory);
        }
        if (builder.listener != null) {
            this.initShim.listener(builder.listener);
        }
        if (builder.initReservationIsSet()) {
            this.initShim.initReservation(builder.initReservation);
        }
        if (builder.maxAllocationIsSet()) {
            this.initShim.maxAllocation(builder.maxAllocation);
        }
        if (builder.roundingPolicy != null) {
            this.initShim.roundingPolicy(builder.roundingPolicy);
        }
        this.allocationManagerFactory = this.initShim.getAllocationManagerFactory();
        this.listener = this.initShim.getListener();
        this.initReservation = this.initShim.getInitReservation();
        this.maxAllocation = this.initShim.getMaxAllocation();
        this.roundingPolicy = this.initShim.getRoundingPolicy();
        this.initShim = null;
    }

    private ImmutableConfig( @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory allocationManagerFactory, @UnknownKeyFor @NonNull @Initialized AllocationListener listener, @UnknownKeyFor @NonNull @Initialized long initReservation, @UnknownKeyFor @NonNull @Initialized long maxAllocation, @UnknownKeyFor @NonNull @Initialized RoundingPolicy roundingPolicy) {
        this.allocationManagerFactory = allocationManagerFactory;
        this.listener = listener;
        this.initReservation = initReservation;
        this.maxAllocation = maxAllocation;
        this.roundingPolicy = roundingPolicy;
        this.initShim = null;
    }

    @Override
     @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getAllocationManagerFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAllocationManagerFactory() : this.allocationManagerFactory;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized AllocationListener getListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getListener() : this.listener;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized long getInitReservation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInitReservation() : this.initReservation;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized long getMaxAllocation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxAllocation() : this.maxAllocation;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized RoundingPolicy getRoundingPolicy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoundingPolicy() : this.roundingPolicy;
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableConfig withAllocationManagerFactory( @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory value) {
        if (this.allocationManagerFactory == value) {
            return this;
        }
        AllocationManager.Factory newValue = Objects.requireNonNull(value, "allocationManagerFactory");
        return new ImmutableConfig(newValue, this.listener, this.initReservation, this.maxAllocation, this.roundingPolicy);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableConfig withListener(@UnknownKeyFor @NonNull @Initialized AllocationListener value) {
        if (this.listener == value) {
            return this;
        }
        AllocationListener newValue = Objects.requireNonNull(value, "listener");
        return new ImmutableConfig(this.allocationManagerFactory, newValue, this.initReservation, this.maxAllocation, this.roundingPolicy);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableConfig withInitReservation(@UnknownKeyFor @NonNull @Initialized long value) {
        if (this.initReservation == value) {
            return this;
        }
        return new ImmutableConfig(this.allocationManagerFactory, this.listener, value, this.maxAllocation, this.roundingPolicy);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableConfig withMaxAllocation(@UnknownKeyFor @NonNull @Initialized long value) {
        if (this.maxAllocation == value) {
            return this;
        }
        return new ImmutableConfig(this.allocationManagerFactory, this.listener, this.initReservation, value, this.roundingPolicy);
    }

    public final @UnknownKeyFor @NonNull @Initialized ImmutableConfig withRoundingPolicy(@UnknownKeyFor @NonNull @Initialized RoundingPolicy value) {
        if (this.roundingPolicy == value) {
            return this;
        }
        RoundingPolicy newValue = Objects.requireNonNull(value, "roundingPolicy");
        return new ImmutableConfig(this.allocationManagerFactory, this.listener, this.initReservation, this.maxAllocation, newValue);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfig && this.equalTo(0, (ImmutableConfig)another);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean equalTo(@UnknownKeyFor @NonNull @Initialized int synthetic, @UnknownKeyFor @NonNull @Initialized ImmutableConfig another) {
        return this.allocationManagerFactory.equals(another.allocationManagerFactory) && this.listener.equals(another.listener) && this.initReservation == another.initReservation && this.maxAllocation == another.maxAllocation && this.roundingPolicy.equals(another.roundingPolicy);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int h = 5381;
        h += (h << 5) + this.allocationManagerFactory.hashCode();
        h += (h << 5) + this.listener.hashCode();
        h += (h << 5) + Long.hashCode(this.initReservation);
        h += (h << 5) + Long.hashCode(this.maxAllocation);
        h += (h << 5) + this.roundingPolicy.hashCode();
        return h;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Config{allocationManagerFactory=" + this.allocationManagerFactory + ", listener=" + this.listener + ", initReservation=" + this.initReservation + ", maxAllocation=" + this.maxAllocation + ", roundingPolicy=" + this.roundingPolicy + "}";
    }

    public static @UnknownKeyFor @NonNull @Initialized ImmutableConfig copyOf( @UnknownKeyFor @NonNull @Initialized BaseAllocator.Config instance) {
        if (instance instanceof ImmutableConfig) {
            return (ImmutableConfig)instance;
        }
        return ImmutableConfig.builder().from(instance).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    @Generated(from="BaseAllocator.Config", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final @UnknownKeyFor @NonNull @Initialized long OPT_BIT_INIT_RESERVATION = 1L;
        private static final @UnknownKeyFor @NonNull @Initialized long OPT_BIT_MAX_ALLOCATION = 2L;
        private @UnknownKeyFor @NonNull @Initialized long optBits;
        @Nullable
        private  @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AllocationManager.Factory allocationManagerFactory;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized AllocationListener listener;
        private @UnknownKeyFor @NonNull @Initialized long initReservation;
        private @UnknownKeyFor @NonNull @Initialized long maxAllocation;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RoundingPolicy roundingPolicy;

        private Builder() {
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder from( @UnknownKeyFor @NonNull @Initialized BaseAllocator.Config instance) {
            Objects.requireNonNull(instance, "instance");
            this.allocationManagerFactory(instance.getAllocationManagerFactory());
            this.listener(instance.getListener());
            this.initReservation(instance.getInitReservation());
            this.maxAllocation(instance.getMaxAllocation());
            this.roundingPolicy(instance.getRoundingPolicy());
            return this;
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder allocationManagerFactory( @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory allocationManagerFactory) {
            this.allocationManagerFactory = Objects.requireNonNull(allocationManagerFactory, "allocationManagerFactory");
            return this;
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder listener(@UnknownKeyFor @NonNull @Initialized AllocationListener listener) {
            this.listener = Objects.requireNonNull(listener, "listener");
            return this;
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder initReservation(@UnknownKeyFor @NonNull @Initialized long initReservation) {
            this.initReservation = initReservation;
            this.optBits |= 1L;
            return this;
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder maxAllocation(@UnknownKeyFor @NonNull @Initialized long maxAllocation) {
            this.maxAllocation = maxAllocation;
            this.optBits |= 2L;
            return this;
        }

        public final @UnknownKeyFor @NonNull @Initialized Builder roundingPolicy(@UnknownKeyFor @NonNull @Initialized RoundingPolicy roundingPolicy) {
            this.roundingPolicy = Objects.requireNonNull(roundingPolicy, "roundingPolicy");
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized ImmutableConfig build() {
            return new ImmutableConfig(this);
        }

        private @UnknownKeyFor @NonNull @Initialized boolean initReservationIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean maxAllocationIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="BaseAllocator.Config", generator="Immutables")
    private final class InitShim {
        private @UnknownKeyFor @NonNull @Initialized byte allocationManagerFactoryBuildStage = 0;
        private  @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory allocationManagerFactory;
        private @UnknownKeyFor @NonNull @Initialized byte listenerBuildStage = 0;
        private @UnknownKeyFor @NonNull @Initialized AllocationListener listener;
        private @UnknownKeyFor @NonNull @Initialized byte initReservationBuildStage = 0;
        private @UnknownKeyFor @NonNull @Initialized long initReservation;
        private @UnknownKeyFor @NonNull @Initialized byte maxAllocationBuildStage = 0;
        private @UnknownKeyFor @NonNull @Initialized long maxAllocation;
        private @UnknownKeyFor @NonNull @Initialized byte roundingPolicyBuildStage = 0;
        private @UnknownKeyFor @NonNull @Initialized RoundingPolicy roundingPolicy;

        private InitShim() {
        }

         @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory getAllocationManagerFactory() {
            if (this.allocationManagerFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.allocationManagerFactoryBuildStage == 0) {
                this.allocationManagerFactoryBuildStage = (byte)-1;
                this.allocationManagerFactory = Objects.requireNonNull(ImmutableConfig.super.getAllocationManagerFactory(), "allocationManagerFactory");
                this.allocationManagerFactoryBuildStage = 1;
            }
            return this.allocationManagerFactory;
        }

        void allocationManagerFactory( @UnknownKeyFor @NonNull @Initialized AllocationManager.Factory allocationManagerFactory) {
            this.allocationManagerFactory = allocationManagerFactory;
            this.allocationManagerFactoryBuildStage = 1;
        }

        @UnknownKeyFor @NonNull @Initialized AllocationListener getListener() {
            if (this.listenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.listenerBuildStage == 0) {
                this.listenerBuildStage = (byte)-1;
                this.listener = Objects.requireNonNull(ImmutableConfig.super.getListener(), "listener");
                this.listenerBuildStage = 1;
            }
            return this.listener;
        }

        void listener(@UnknownKeyFor @NonNull @Initialized AllocationListener listener) {
            this.listener = listener;
            this.listenerBuildStage = 1;
        }

        @UnknownKeyFor @NonNull @Initialized long getInitReservation() {
            if (this.initReservationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initReservationBuildStage == 0) {
                this.initReservationBuildStage = (byte)-1;
                this.initReservation = ImmutableConfig.super.getInitReservation();
                this.initReservationBuildStage = 1;
            }
            return this.initReservation;
        }

        void initReservation(@UnknownKeyFor @NonNull @Initialized long initReservation) {
            this.initReservation = initReservation;
            this.initReservationBuildStage = 1;
        }

        @UnknownKeyFor @NonNull @Initialized long getMaxAllocation() {
            if (this.maxAllocationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxAllocationBuildStage == 0) {
                this.maxAllocationBuildStage = (byte)-1;
                this.maxAllocation = ImmutableConfig.super.getMaxAllocation();
                this.maxAllocationBuildStage = 1;
            }
            return this.maxAllocation;
        }

        void maxAllocation(@UnknownKeyFor @NonNull @Initialized long maxAllocation) {
            this.maxAllocation = maxAllocation;
            this.maxAllocationBuildStage = 1;
        }

        @UnknownKeyFor @NonNull @Initialized RoundingPolicy getRoundingPolicy() {
            if (this.roundingPolicyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.roundingPolicyBuildStage == 0) {
                this.roundingPolicyBuildStage = (byte)-1;
                this.roundingPolicy = Objects.requireNonNull(ImmutableConfig.super.getRoundingPolicy(), "roundingPolicy");
                this.roundingPolicyBuildStage = 1;
            }
            return this.roundingPolicy;
        }

        void roundingPolicy(@UnknownKeyFor @NonNull @Initialized RoundingPolicy roundingPolicy) {
            this.roundingPolicy = roundingPolicy;
            this.roundingPolicyBuildStage = 1;
        }

        private @UnknownKeyFor @NonNull @Initialized String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.allocationManagerFactoryBuildStage == -1) {
                attributes.add("allocationManagerFactory");
            }
            if (this.listenerBuildStage == -1) {
                attributes.add("listener");
            }
            if (this.initReservationBuildStage == -1) {
                attributes.add("initReservation");
            }
            if (this.maxAllocationBuildStage == -1) {
                attributes.add("maxAllocation");
            }
            if (this.roundingPolicyBuildStage == -1) {
                attributes.add("roundingPolicy");
            }
            return "Cannot build Config, attribute initializers form cycle " + attributes;
        }
    }
}

