/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.script.expression.FieldDataValueSource;
import org.elasticsearch.search.MultiValueMode;

class DateObjectValueSource
extends FieldDataValueSource {
    final String methodName;
    final ToIntFunction<ZonedDateTime> function;

    DateObjectValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, ToIntFunction<ZonedDateTime> function) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.function = function;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafNumericFieldData leafData = (LeafNumericFieldData)this.fieldData.load(leaf);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues());
        return new DoubleValues(){

            public double doubleValue() throws IOException {
                return DateObjectValueSource.this.function.applyAsInt(ZonedDateTime.ofInstant(Instant.ofEpochMilli((long)docValues.doubleValue()), ZoneOffset.UTC));
            }

            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    @Override
    public String toString() {
        return this.methodName + ": field(" + this.fieldData.getFieldName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateObjectValueSource that = (DateObjectValueSource)((Object)o);
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        return result;
    }
}

