/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NoOpRequestControl
extends Control {
    @NotNull
    public static final String NO_OP_REQUEST_OID = "1.3.6.1.4.1.4203.1.10.2";
    private static final long serialVersionUID = -7435407787971958294L;

    public NoOpRequestControl() {
        super(NO_OP_REQUEST_OID, true, null);
    }

    public NoOpRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_NOOP_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_NOOP_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("NoOpRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

