/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.fleet.action.GetGlobalCheckpointsAction;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetGlobalCheckpointsAction
extends BaseRestHandler {
    public String getName() {
        return "fleet_get_global_checkpoints";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_fleet/global_checkpoints"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        String index = request.param("index");
        boolean waitForAdvance = request.paramAsBoolean("wait_for_advance", false);
        boolean waitForIndex = request.paramAsBoolean("wait_for_index", false);
        String[] stringCheckpoints = request.paramAsStringArray("checkpoints", new String[0]);
        long[] checkpoints = new long[stringCheckpoints.length];
        for (int i = 0; i < stringCheckpoints.length; ++i) {
            checkpoints[i] = Long.parseLong(stringCheckpoints[i]);
        }
        TimeValue pollTimeout = request.paramAsTime("timeout", TimeValue.timeValueSeconds((long)30L));
        GetGlobalCheckpointsAction.Request getCheckpointsRequest = new GetGlobalCheckpointsAction.Request(index, waitForAdvance, waitForIndex, checkpoints, pollTimeout);
        return channel -> client.execute((ActionType)GetGlobalCheckpointsAction.INSTANCE, (ActionRequest)getCheckpointsRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

