/*
 * Copyright (C) 2009 Martin Willi
 *
 * Copyright (C) secunet Security Networks AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the Licenseor (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be usefulbut
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <crypto/crypto_tester.h>

/**
 * RFC 3566 Test Case #1: AES-XCBC-MAC-96 with 0-byte input
 */
signer_test_vector_t aes_xcbc_s1 = {
	.alg = AUTH_AES_XCBC_96, .len = 0,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.data	= "",
	.mac	= "\x75\xf0\x25\x1d\x52\x8a\xc0\x1c\x45\x73\xdf\xd5"
};

prf_test_vector_t aes_xcbc_p1 = {
	.alg = PRF_AES128_XCBC, .key_size = 16, .len = 0,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.seed	= "",
	.out	= "\x75\xf0\x25\x1d\x52\x8a\xc0\x1c\x45\x73\xdf\xd5\x84\xd7\x9f\x29"
};

/**
 * RFC 3566 Test Case #2: AES-XCBC-MAC-96 with 3-byte input
 */
signer_test_vector_t aes_xcbc_s2 = {
	.alg = AUTH_AES_XCBC_96, .len = 3,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.data	= "\x00\x01\x02",
	.mac	= "\x5b\x37\x65\x80\xae\x2f\x19\xaf\xe7\x21\x9c\xee"
};

prf_test_vector_t aes_xcbc_p2 = {
	.alg = PRF_AES128_XCBC, .key_size = 16, .len = 3,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.seed	= "\x00\x01\x02",
	.out	= "\x5b\x37\x65\x80\xae\x2f\x19\xaf\xe7\x21\x9c\xee\xf1\x72\x75\x6f"
};

/**
 * RFC 3566 Test Case #3: AES-XCBC-MAC-96 with 16-byte input
 */
signer_test_vector_t aes_xcbc_s3 = {
	.alg = AUTH_AES_XCBC_96, .len = 16,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.data	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.mac	= "\xd2\xa2\x46\xfa\x34\x9b\x68\xa7\x99\x98\xa4\x39"
};

prf_test_vector_t aes_xcbc_p3 = {
	.alg = PRF_AES128_XCBC, .key_size = 16, .len = 16,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.seed	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.out	= "\xd2\xa2\x46\xfa\x34\x9b\x68\xa7\x99\x98\xa4\x39\x4f\xf7\xa2\x63"
};

/**
 * RFC 3566 Test Case #4: AES-XCBC-MAC-96 with 20-byte input
 */
signer_test_vector_t aes_xcbc_s4 = {
	.alg = AUTH_AES_XCBC_96, .len = 20,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.data	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13",
	.mac	= "\x47\xf5\x1b\x45\x64\x96\x62\x15\xb8\x98\x5c\x63"
};

prf_test_vector_t aes_xcbc_p4 = {
	.alg = PRF_AES128_XCBC, .key_size = 16, .len = 20,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.seed	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13",
	.out	= "\x47\xf5\x1b\x45\x64\x96\x62\x15\xb8\x98\x5c\x63\x05\x5e\xd3\x08"
};

/**
 * RFC 3566 Test Case #5: AES-XCBC-MAC-96 with 32-byte input
 */
signer_test_vector_t aes_xcbc_s5 = {
	.alg = AUTH_AES_XCBC_96, .len = 32,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.data	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
	.mac	= "\xf5\x4f\x0e\xc8\xd2\xb9\xf3\xd3\x68\x07\x73\x4b"
};

prf_test_vector_t aes_xcbc_p5 = {
	.alg = PRF_AES128_XCBC, .key_size = 16, .len = 32,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f",
	.seed	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
	.out	= "\xf5\x4f\x0e\xc8\xd2\xb9\xf3\xd3\x68\x07\x73\x4b\xd5\x28\x3f\xd4"
};

/**
 * RFC4434 Test Case: AES-XCBC-PRF-128 with 20-byte input, 10 byte key
 */
prf_test_vector_t aes_xcbc_p6 = {
	.alg = PRF_AES128_XCBC, .key_size = 10, .len = 20,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09",
	.seed	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13",
	.out	= "\x0f\xa0\x87\xaf\x7d\x86\x6e\x76\x53\x43\x4e\x60\x2f\xdd\xe8\x35"
};

/**
 * RFC4434 Test Case: AES-XCBC-PRF-128 with 20-byte input, 18 byte key
 */
prf_test_vector_t aes_xcbc_p7 = {
	.alg = PRF_AES128_XCBC, .key_size = 18, .len = 20,
	.key	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\xed\xcb",
	.seed	= "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f"
			  "\x10\x11\x12\x13",
	.out	= "\x8c\xd3\xc9\x3a\xe5\x98\xa9\x80\x30\x06\xff\xb6\x7c\x40\xe9\xe4"
};

