// Copyright (c) 2020, NVIDIA CORPORATION. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// WARNING: THIS FILE WAS AUTOMATICALLY GENERATED.
// Code generated by https://git.io/c-for-go. DO NOT EDIT.

package nvml

/*
#cgo linux LDFLAGS: -Wl,--export-dynamic -Wl,--unresolved-symbols=ignore-in-object-files
#cgo darwin LDFLAGS: -Wl,-undefined,dynamic_lookup
#cgo CFLAGS: -DNVML_NO_UNVERSIONED_FUNC_DEFS=1
#include "nvml.h"
#include <stdlib.h>
#include "cgo_helpers.h"
*/
import "C"
import "unsafe"

// nvmlInit_v2 function as declared in nvml/nvml.h
func nvmlInit_v2() Return {
	__ret := C.nvmlInit_v2()
	__v := (Return)(__ret)
	return __v
}

// nvmlInitWithFlags function as declared in nvml/nvml.h
func nvmlInitWithFlags(Flags uint32) Return {
	cFlags, _ := (C.uint)(Flags), cgoAllocsUnknown
	__ret := C.nvmlInitWithFlags(cFlags)
	__v := (Return)(__ret)
	return __v
}

// nvmlShutdown function as declared in nvml/nvml.h
func nvmlShutdown() Return {
	__ret := C.nvmlShutdown()
	__v := (Return)(__ret)
	return __v
}

// nvmlErrorString function as declared in nvml/nvml.h
func nvmlErrorString(Result Return) string {
	cResult, _ := (C.nvmlReturn_t)(Result), cgoAllocsUnknown
	__ret := C.nvmlErrorString(cResult)
	__v := packPCharString(__ret)
	return __v
}

// nvmlSystemGetDriverVersion function as declared in nvml/nvml.h
func nvmlSystemGetDriverVersion(Version *byte, Length uint32) Return {
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlSystemGetDriverVersion(cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetNVMLVersion function as declared in nvml/nvml.h
func nvmlSystemGetNVMLVersion(Version *byte, Length uint32) Return {
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlSystemGetNVMLVersion(cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetCudaDriverVersion function as declared in nvml/nvml.h
func nvmlSystemGetCudaDriverVersion(CudaDriverVersion *int32) Return {
	cCudaDriverVersion, _ := (*C.int)(unsafe.Pointer(CudaDriverVersion)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetCudaDriverVersion(cCudaDriverVersion)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetCudaDriverVersion_v2 function as declared in nvml/nvml.h
func nvmlSystemGetCudaDriverVersion_v2(CudaDriverVersion *int32) Return {
	cCudaDriverVersion, _ := (*C.int)(unsafe.Pointer(CudaDriverVersion)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetCudaDriverVersion_v2(cCudaDriverVersion)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetProcessName function as declared in nvml/nvml.h
func nvmlSystemGetProcessName(Pid uint32, Name *byte, Length uint32) Return {
	cPid, _ := (C.uint)(Pid), cgoAllocsUnknown
	cName, _ := (*C.char)(unsafe.Pointer(Name)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlSystemGetProcessName(cPid, cName, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetHicVersion function as declared in nvml/nvml.h
func nvmlSystemGetHicVersion(HwbcCount *uint32, HwbcEntries *HwbcEntry) Return {
	cHwbcCount, _ := (*C.uint)(unsafe.Pointer(HwbcCount)), cgoAllocsUnknown
	cHwbcEntries, _ := (*C.nvmlHwbcEntry_t)(unsafe.Pointer(HwbcEntries)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetHicVersion(cHwbcCount, cHwbcEntries)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetTopologyGpuSet function as declared in nvml/nvml.h
func nvmlSystemGetTopologyGpuSet(CpuNumber uint32, Count *uint32, DeviceArray *nvmlDevice) Return {
	cCpuNumber, _ := (C.uint)(CpuNumber), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cDeviceArray, _ := (*C.nvmlDevice_t)(unsafe.Pointer(DeviceArray)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetTopologyGpuSet(cCpuNumber, cCount, cDeviceArray)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetDriverBranch function as declared in nvml/nvml.h
func nvmlSystemGetDriverBranch(BranchInfo *SystemDriverBranchInfo, Length uint32) Return {
	cBranchInfo, _ := (*C.nvmlSystemDriverBranchInfo_t)(unsafe.Pointer(BranchInfo)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlSystemGetDriverBranch(cBranchInfo, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetCount function as declared in nvml/nvml.h
func nvmlUnitGetCount(UnitCount *uint32) Return {
	cUnitCount, _ := (*C.uint)(unsafe.Pointer(UnitCount)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetCount(cUnitCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetHandleByIndex function as declared in nvml/nvml.h
func nvmlUnitGetHandleByIndex(Index uint32, nvmlUnit *nvmlUnit) Return {
	cIndex, _ := (C.uint)(Index), cgoAllocsUnknown
	cnvmlUnit, _ := (*C.nvmlUnit_t)(unsafe.Pointer(nvmlUnit)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetHandleByIndex(cIndex, cnvmlUnit)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetUnitInfo function as declared in nvml/nvml.h
func nvmlUnitGetUnitInfo(nvmlUnit nvmlUnit, Info *UnitInfo) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlUnitInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetUnitInfo(cnvmlUnit, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetLedState function as declared in nvml/nvml.h
func nvmlUnitGetLedState(nvmlUnit nvmlUnit, State *LedState) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cState, _ := (*C.nvmlLedState_t)(unsafe.Pointer(State)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetLedState(cnvmlUnit, cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetPsuInfo function as declared in nvml/nvml.h
func nvmlUnitGetPsuInfo(nvmlUnit nvmlUnit, Psu *PSUInfo) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cPsu, _ := (*C.nvmlPSUInfo_t)(unsafe.Pointer(Psu)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetPsuInfo(cnvmlUnit, cPsu)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetTemperature function as declared in nvml/nvml.h
func nvmlUnitGetTemperature(nvmlUnit nvmlUnit, _type uint32, Temp *uint32) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	c_type, _ := (C.uint)(_type), cgoAllocsUnknown
	cTemp, _ := (*C.uint)(unsafe.Pointer(Temp)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetTemperature(cnvmlUnit, c_type, cTemp)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetFanSpeedInfo function as declared in nvml/nvml.h
func nvmlUnitGetFanSpeedInfo(nvmlUnit nvmlUnit, FanSpeeds *UnitFanSpeeds) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cFanSpeeds, _ := (*C.nvmlUnitFanSpeeds_t)(unsafe.Pointer(FanSpeeds)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetFanSpeedInfo(cnvmlUnit, cFanSpeeds)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitGetDevices function as declared in nvml/nvml.h
func nvmlUnitGetDevices(nvmlUnit nvmlUnit, DeviceCount *uint32, Devices *nvmlDevice) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cDeviceCount, _ := (*C.uint)(unsafe.Pointer(DeviceCount)), cgoAllocsUnknown
	cDevices, _ := (*C.nvmlDevice_t)(unsafe.Pointer(Devices)), cgoAllocsUnknown
	__ret := C.nvmlUnitGetDevices(cnvmlUnit, cDeviceCount, cDevices)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCount_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetCount_v2(DeviceCount *uint32) Return {
	cDeviceCount, _ := (*C.uint)(unsafe.Pointer(DeviceCount)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCount_v2(cDeviceCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAttributes_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetAttributes_v2(nvmlDevice nvmlDevice, Attributes *DeviceAttributes) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cAttributes, _ := (*C.nvmlDeviceAttributes_t)(unsafe.Pointer(Attributes)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAttributes_v2(cnvmlDevice, cAttributes)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByIndex_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByIndex_v2(Index uint32, nvmlDevice *nvmlDevice) Return {
	cIndex, _ := (C.uint)(Index), cgoAllocsUnknown
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByIndex_v2(cIndex, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleBySerial function as declared in nvml/nvml.h
func nvmlDeviceGetHandleBySerial(Serial string, nvmlDevice *nvmlDevice) Return {
	cSerial, _ := unpackPCharString(Serial)
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleBySerial(cSerial, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByUUID function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByUUID(Uuid string, nvmlDevice *nvmlDevice) Return {
	cUuid, _ := unpackPCharString(Uuid)
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByUUID(cUuid, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByUUIDV function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByUUIDV(Uuid *UUID, nvmlDevice *nvmlDevice) Return {
	cUuid, _ := (*C.nvmlUUID_t)(unsafe.Pointer(Uuid)), cgoAllocsUnknown
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByUUIDV(cUuid, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByPciBusId_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByPciBusId_v2(PciBusId string, nvmlDevice *nvmlDevice) Return {
	cPciBusId, _ := unpackPCharString(PciBusId)
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByPciBusId_v2(cPciBusId, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetName function as declared in nvml/nvml.h
func nvmlDeviceGetName(nvmlDevice nvmlDevice, Name *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cName, _ := (*C.char)(unsafe.Pointer(Name)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetName(cnvmlDevice, cName, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBrand function as declared in nvml/nvml.h
func nvmlDeviceGetBrand(nvmlDevice nvmlDevice, _type *BrandType) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (*C.nvmlBrandType_t)(unsafe.Pointer(_type)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBrand(cnvmlDevice, c_type)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetIndex function as declared in nvml/nvml.h
func nvmlDeviceGetIndex(nvmlDevice nvmlDevice, Index *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIndex, _ := (*C.uint)(unsafe.Pointer(Index)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetIndex(cnvmlDevice, cIndex)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSerial function as declared in nvml/nvml.h
func nvmlDeviceGetSerial(nvmlDevice nvmlDevice, Serial *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSerial, _ := (*C.char)(unsafe.Pointer(Serial)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSerial(cnvmlDevice, cSerial, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetModuleId function as declared in nvml/nvml.h
func nvmlDeviceGetModuleId(nvmlDevice nvmlDevice, ModuleId *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cModuleId, _ := (*C.uint)(unsafe.Pointer(ModuleId)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetModuleId(cnvmlDevice, cModuleId)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetC2cModeInfoV function as declared in nvml/nvml.h
func nvmlDeviceGetC2cModeInfoV(nvmlDevice nvmlDevice, C2cModeInfo *C2cModeInfo_v1) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cC2cModeInfo, _ := (*C.nvmlC2cModeInfo_v1_t)(unsafe.Pointer(C2cModeInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetC2cModeInfoV(cnvmlDevice, cC2cModeInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemoryAffinity function as declared in nvml/nvml.h
func nvmlDeviceGetMemoryAffinity(nvmlDevice nvmlDevice, NodeSetSize uint32, NodeSet *uint, Scope AffinityScope) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cNodeSetSize, _ := (C.uint)(NodeSetSize), cgoAllocsUnknown
	cNodeSet, _ := (*C.ulong)(unsafe.Pointer(NodeSet)), cgoAllocsUnknown
	cScope, _ := (C.nvmlAffinityScope_t)(Scope), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemoryAffinity(cnvmlDevice, cNodeSetSize, cNodeSet, cScope)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCpuAffinityWithinScope function as declared in nvml/nvml.h
func nvmlDeviceGetCpuAffinityWithinScope(nvmlDevice nvmlDevice, CpuSetSize uint32, CpuSet *uint, Scope AffinityScope) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCpuSetSize, _ := (C.uint)(CpuSetSize), cgoAllocsUnknown
	cCpuSet, _ := (*C.ulong)(unsafe.Pointer(CpuSet)), cgoAllocsUnknown
	cScope, _ := (C.nvmlAffinityScope_t)(Scope), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCpuAffinityWithinScope(cnvmlDevice, cCpuSetSize, cCpuSet, cScope)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCpuAffinity function as declared in nvml/nvml.h
func nvmlDeviceGetCpuAffinity(nvmlDevice nvmlDevice, CpuSetSize uint32, CpuSet *uint) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCpuSetSize, _ := (C.uint)(CpuSetSize), cgoAllocsUnknown
	cCpuSet, _ := (*C.ulong)(unsafe.Pointer(CpuSet)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCpuAffinity(cnvmlDevice, cCpuSetSize, cCpuSet)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetCpuAffinity function as declared in nvml/nvml.h
func nvmlDeviceSetCpuAffinity(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetCpuAffinity(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceClearCpuAffinity function as declared in nvml/nvml.h
func nvmlDeviceClearCpuAffinity(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceClearCpuAffinity(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNumaNodeId function as declared in nvml/nvml.h
func nvmlDeviceGetNumaNodeId(nvmlDevice nvmlDevice, Node *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cNode, _ := (*C.uint)(unsafe.Pointer(Node)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNumaNodeId(cnvmlDevice, cNode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTopologyCommonAncestor function as declared in nvml/nvml.h
func nvmlDeviceGetTopologyCommonAncestor(Device1 nvmlDevice, Device2 nvmlDevice, PathInfo *GpuTopologyLevel) Return {
	cDevice1, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device1)), cgoAllocsUnknown
	cDevice2, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device2)), cgoAllocsUnknown
	cPathInfo, _ := (*C.nvmlGpuTopologyLevel_t)(unsafe.Pointer(PathInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTopologyCommonAncestor(cDevice1, cDevice2, cPathInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTopologyNearestGpus function as declared in nvml/nvml.h
func nvmlDeviceGetTopologyNearestGpus(nvmlDevice nvmlDevice, Level GpuTopologyLevel, Count *uint32, DeviceArray *nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLevel, _ := (C.nvmlGpuTopologyLevel_t)(Level), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cDeviceArray, _ := (*C.nvmlDevice_t)(unsafe.Pointer(DeviceArray)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTopologyNearestGpus(cnvmlDevice, cLevel, cCount, cDeviceArray)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetP2PStatus function as declared in nvml/nvml.h
func nvmlDeviceGetP2PStatus(Device1 nvmlDevice, Device2 nvmlDevice, P2pIndex GpuP2PCapsIndex, P2pStatus *GpuP2PStatus) Return {
	cDevice1, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device1)), cgoAllocsUnknown
	cDevice2, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device2)), cgoAllocsUnknown
	cP2pIndex, _ := (C.nvmlGpuP2PCapsIndex_t)(P2pIndex), cgoAllocsUnknown
	cP2pStatus, _ := (*C.nvmlGpuP2PStatus_t)(unsafe.Pointer(P2pStatus)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetP2PStatus(cDevice1, cDevice2, cP2pIndex, cP2pStatus)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetUUID function as declared in nvml/nvml.h
func nvmlDeviceGetUUID(nvmlDevice nvmlDevice, Uuid *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUuid, _ := (*C.char)(unsafe.Pointer(Uuid)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetUUID(cnvmlDevice, cUuid, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMinorNumber function as declared in nvml/nvml.h
func nvmlDeviceGetMinorNumber(nvmlDevice nvmlDevice, MinorNumber *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinorNumber, _ := (*C.uint)(unsafe.Pointer(MinorNumber)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMinorNumber(cnvmlDevice, cMinorNumber)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBoardPartNumber function as declared in nvml/nvml.h
func nvmlDeviceGetBoardPartNumber(nvmlDevice nvmlDevice, PartNumber *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPartNumber, _ := (*C.char)(unsafe.Pointer(PartNumber)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBoardPartNumber(cnvmlDevice, cPartNumber, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetInforomVersion function as declared in nvml/nvml.h
func nvmlDeviceGetInforomVersion(nvmlDevice nvmlDevice, Object InforomObject, Version *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cObject, _ := (C.nvmlInforomObject_t)(Object), cgoAllocsUnknown
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetInforomVersion(cnvmlDevice, cObject, cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetInforomImageVersion function as declared in nvml/nvml.h
func nvmlDeviceGetInforomImageVersion(nvmlDevice nvmlDevice, Version *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetInforomImageVersion(cnvmlDevice, cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetInforomConfigurationChecksum function as declared in nvml/nvml.h
func nvmlDeviceGetInforomConfigurationChecksum(nvmlDevice nvmlDevice, Checksum *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cChecksum, _ := (*C.uint)(unsafe.Pointer(Checksum)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetInforomConfigurationChecksum(cnvmlDevice, cChecksum)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceValidateInforom function as declared in nvml/nvml.h
func nvmlDeviceValidateInforom(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceValidateInforom(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetLastBBXFlushTime function as declared in nvml/nvml.h
func nvmlDeviceGetLastBBXFlushTime(nvmlDevice nvmlDevice, Timestamp *uint64, DurationUs *uint) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cTimestamp, _ := (*C.ulonglong)(unsafe.Pointer(Timestamp)), cgoAllocsUnknown
	cDurationUs, _ := (*C.ulong)(unsafe.Pointer(DurationUs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetLastBBXFlushTime(cnvmlDevice, cTimestamp, cDurationUs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDisplayMode function as declared in nvml/nvml.h
func nvmlDeviceGetDisplayMode(nvmlDevice nvmlDevice, Display *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cDisplay, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Display)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDisplayMode(cnvmlDevice, cDisplay)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDisplayActive function as declared in nvml/nvml.h
func nvmlDeviceGetDisplayActive(nvmlDevice nvmlDevice, IsActive *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIsActive, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(IsActive)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDisplayActive(cnvmlDevice, cIsActive)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPersistenceMode function as declared in nvml/nvml.h
func nvmlDeviceGetPersistenceMode(nvmlDevice nvmlDevice, Mode *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Mode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPersistenceMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPciInfoExt function as declared in nvml/nvml.h
func nvmlDeviceGetPciInfoExt(nvmlDevice nvmlDevice, Pci *PciInfoExt) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfoExt_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPciInfoExt(cnvmlDevice, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPciInfo_v3 function as declared in nvml/nvml.h
func nvmlDeviceGetPciInfo_v3(nvmlDevice nvmlDevice, Pci *PciInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPciInfo_v3(cnvmlDevice, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMaxPcieLinkGeneration function as declared in nvml/nvml.h
func nvmlDeviceGetMaxPcieLinkGeneration(nvmlDevice nvmlDevice, MaxLinkGen *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMaxLinkGen, _ := (*C.uint)(unsafe.Pointer(MaxLinkGen)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMaxPcieLinkGeneration(cnvmlDevice, cMaxLinkGen)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuMaxPcieLinkGeneration function as declared in nvml/nvml.h
func nvmlDeviceGetGpuMaxPcieLinkGeneration(nvmlDevice nvmlDevice, MaxLinkGenDevice *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMaxLinkGenDevice, _ := (*C.uint)(unsafe.Pointer(MaxLinkGenDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuMaxPcieLinkGeneration(cnvmlDevice, cMaxLinkGenDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMaxPcieLinkWidth function as declared in nvml/nvml.h
func nvmlDeviceGetMaxPcieLinkWidth(nvmlDevice nvmlDevice, MaxLinkWidth *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMaxLinkWidth, _ := (*C.uint)(unsafe.Pointer(MaxLinkWidth)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMaxPcieLinkWidth(cnvmlDevice, cMaxLinkWidth)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCurrPcieLinkGeneration function as declared in nvml/nvml.h
func nvmlDeviceGetCurrPcieLinkGeneration(nvmlDevice nvmlDevice, CurrLinkGen *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrLinkGen, _ := (*C.uint)(unsafe.Pointer(CurrLinkGen)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCurrPcieLinkGeneration(cnvmlDevice, cCurrLinkGen)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCurrPcieLinkWidth function as declared in nvml/nvml.h
func nvmlDeviceGetCurrPcieLinkWidth(nvmlDevice nvmlDevice, CurrLinkWidth *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrLinkWidth, _ := (*C.uint)(unsafe.Pointer(CurrLinkWidth)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCurrPcieLinkWidth(cnvmlDevice, cCurrLinkWidth)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPcieThroughput function as declared in nvml/nvml.h
func nvmlDeviceGetPcieThroughput(nvmlDevice nvmlDevice, Counter PcieUtilCounter, Value *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCounter, _ := (C.nvmlPcieUtilCounter_t)(Counter), cgoAllocsUnknown
	cValue, _ := (*C.uint)(unsafe.Pointer(Value)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPcieThroughput(cnvmlDevice, cCounter, cValue)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPcieReplayCounter function as declared in nvml/nvml.h
func nvmlDeviceGetPcieReplayCounter(nvmlDevice nvmlDevice, Value *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cValue, _ := (*C.uint)(unsafe.Pointer(Value)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPcieReplayCounter(cnvmlDevice, cValue)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetClockInfo function as declared in nvml/nvml.h
func nvmlDeviceGetClockInfo(nvmlDevice nvmlDevice, _type ClockType, Clock *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (C.nvmlClockType_t)(_type), cgoAllocsUnknown
	cClock, _ := (*C.uint)(unsafe.Pointer(Clock)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetClockInfo(cnvmlDevice, c_type, cClock)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMaxClockInfo function as declared in nvml/nvml.h
func nvmlDeviceGetMaxClockInfo(nvmlDevice nvmlDevice, _type ClockType, Clock *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (C.nvmlClockType_t)(_type), cgoAllocsUnknown
	cClock, _ := (*C.uint)(unsafe.Pointer(Clock)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMaxClockInfo(cnvmlDevice, c_type, cClock)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpcClkVfOffset function as declared in nvml/nvml.h
func nvmlDeviceGetGpcClkVfOffset(nvmlDevice nvmlDevice, Offset *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cOffset, _ := (*C.int)(unsafe.Pointer(Offset)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpcClkVfOffset(cnvmlDevice, cOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetApplicationsClock function as declared in nvml/nvml.h
func nvmlDeviceGetApplicationsClock(nvmlDevice nvmlDevice, ClockType ClockType, ClockMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClockType, _ := (C.nvmlClockType_t)(ClockType), cgoAllocsUnknown
	cClockMHz, _ := (*C.uint)(unsafe.Pointer(ClockMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetApplicationsClock(cnvmlDevice, cClockType, cClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDefaultApplicationsClock function as declared in nvml/nvml.h
func nvmlDeviceGetDefaultApplicationsClock(nvmlDevice nvmlDevice, ClockType ClockType, ClockMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClockType, _ := (C.nvmlClockType_t)(ClockType), cgoAllocsUnknown
	cClockMHz, _ := (*C.uint)(unsafe.Pointer(ClockMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDefaultApplicationsClock(cnvmlDevice, cClockType, cClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetClock function as declared in nvml/nvml.h
func nvmlDeviceGetClock(nvmlDevice nvmlDevice, ClockType ClockType, ClockId ClockId, ClockMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClockType, _ := (C.nvmlClockType_t)(ClockType), cgoAllocsUnknown
	cClockId, _ := (C.nvmlClockId_t)(ClockId), cgoAllocsUnknown
	cClockMHz, _ := (*C.uint)(unsafe.Pointer(ClockMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetClock(cnvmlDevice, cClockType, cClockId, cClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMaxCustomerBoostClock function as declared in nvml/nvml.h
func nvmlDeviceGetMaxCustomerBoostClock(nvmlDevice nvmlDevice, ClockType ClockType, ClockMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClockType, _ := (C.nvmlClockType_t)(ClockType), cgoAllocsUnknown
	cClockMHz, _ := (*C.uint)(unsafe.Pointer(ClockMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMaxCustomerBoostClock(cnvmlDevice, cClockType, cClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedMemoryClocks function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedMemoryClocks(nvmlDevice nvmlDevice, Count *uint32, ClocksMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cClocksMHz, _ := (*C.uint)(unsafe.Pointer(ClocksMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedMemoryClocks(cnvmlDevice, cCount, cClocksMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedGraphicsClocks function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedGraphicsClocks(nvmlDevice nvmlDevice, MemoryClockMHz uint32, Count *uint32, ClocksMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemoryClockMHz, _ := (C.uint)(MemoryClockMHz), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cClocksMHz, _ := (*C.uint)(unsafe.Pointer(ClocksMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedGraphicsClocks(cnvmlDevice, cMemoryClockMHz, cCount, cClocksMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAutoBoostedClocksEnabled function as declared in nvml/nvml.h
func nvmlDeviceGetAutoBoostedClocksEnabled(nvmlDevice nvmlDevice, IsEnabled *EnableState, DefaultIsEnabled *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIsEnabled, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(IsEnabled)), cgoAllocsUnknown
	cDefaultIsEnabled, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(DefaultIsEnabled)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAutoBoostedClocksEnabled(cnvmlDevice, cIsEnabled, cDefaultIsEnabled)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFanSpeed function as declared in nvml/nvml.h
func nvmlDeviceGetFanSpeed(nvmlDevice nvmlDevice, Speed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSpeed, _ := (*C.uint)(unsafe.Pointer(Speed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFanSpeed(cnvmlDevice, cSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFanSpeed_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetFanSpeed_v2(nvmlDevice nvmlDevice, Fan uint32, Speed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	cSpeed, _ := (*C.uint)(unsafe.Pointer(Speed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFanSpeed_v2(cnvmlDevice, cFan, cSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFanSpeedRPM function as declared in nvml/nvml.h
func nvmlDeviceGetFanSpeedRPM(nvmlDevice nvmlDevice, FanSpeed *FanSpeedInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFanSpeed, _ := (*C.nvmlFanSpeedInfo_t)(unsafe.Pointer(FanSpeed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFanSpeedRPM(cnvmlDevice, cFanSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTargetFanSpeed function as declared in nvml/nvml.h
func nvmlDeviceGetTargetFanSpeed(nvmlDevice nvmlDevice, Fan uint32, TargetSpeed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	cTargetSpeed, _ := (*C.uint)(unsafe.Pointer(TargetSpeed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTargetFanSpeed(cnvmlDevice, cFan, cTargetSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMinMaxFanSpeed function as declared in nvml/nvml.h
func nvmlDeviceGetMinMaxFanSpeed(nvmlDevice nvmlDevice, MinSpeed *uint32, MaxSpeed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinSpeed, _ := (*C.uint)(unsafe.Pointer(MinSpeed)), cgoAllocsUnknown
	cMaxSpeed, _ := (*C.uint)(unsafe.Pointer(MaxSpeed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMinMaxFanSpeed(cnvmlDevice, cMinSpeed, cMaxSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFanControlPolicy_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetFanControlPolicy_v2(nvmlDevice nvmlDevice, Fan uint32, Policy *FanControlPolicy) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	cPolicy, _ := (*C.nvmlFanControlPolicy_t)(unsafe.Pointer(Policy)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFanControlPolicy_v2(cnvmlDevice, cFan, cPolicy)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNumFans function as declared in nvml/nvml.h
func nvmlDeviceGetNumFans(nvmlDevice nvmlDevice, NumFans *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cNumFans, _ := (*C.uint)(unsafe.Pointer(NumFans)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNumFans(cnvmlDevice, cNumFans)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTemperature function as declared in nvml/nvml.h
func nvmlDeviceGetTemperature(nvmlDevice nvmlDevice, SensorType TemperatureSensors, Temp *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSensorType, _ := (C.nvmlTemperatureSensors_t)(SensorType), cgoAllocsUnknown
	cTemp, _ := (*C.uint)(unsafe.Pointer(Temp)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTemperature(cnvmlDevice, cSensorType, cTemp)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCoolerInfo function as declared in nvml/nvml.h
func nvmlDeviceGetCoolerInfo(nvmlDevice nvmlDevice, CoolerInfo *CoolerInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCoolerInfo, _ := (*C.nvmlCoolerInfo_t)(unsafe.Pointer(CoolerInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCoolerInfo(cnvmlDevice, cCoolerInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTemperatureV function as declared in nvml/nvml.h
func nvmlDeviceGetTemperatureV(nvmlDevice nvmlDevice, Temperature *Temperature) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cTemperature, _ := (*C.nvmlTemperature_t)(unsafe.Pointer(Temperature)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTemperatureV(cnvmlDevice, cTemperature)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTemperatureThreshold function as declared in nvml/nvml.h
func nvmlDeviceGetTemperatureThreshold(nvmlDevice nvmlDevice, ThresholdType TemperatureThresholds, Temp *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cThresholdType, _ := (C.nvmlTemperatureThresholds_t)(ThresholdType), cgoAllocsUnknown
	cTemp, _ := (*C.uint)(unsafe.Pointer(Temp)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTemperatureThreshold(cnvmlDevice, cThresholdType, cTemp)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMarginTemperature function as declared in nvml/nvml.h
func nvmlDeviceGetMarginTemperature(nvmlDevice nvmlDevice, MarginTempInfo *MarginTemperature) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMarginTempInfo, _ := (*C.nvmlMarginTemperature_t)(unsafe.Pointer(MarginTempInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMarginTemperature(cnvmlDevice, cMarginTempInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetThermalSettings function as declared in nvml/nvml.h
func nvmlDeviceGetThermalSettings(nvmlDevice nvmlDevice, SensorIndex uint32, PThermalSettings *GpuThermalSettings) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSensorIndex, _ := (C.uint)(SensorIndex), cgoAllocsUnknown
	cPThermalSettings, _ := (*C.nvmlGpuThermalSettings_t)(unsafe.Pointer(PThermalSettings)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetThermalSettings(cnvmlDevice, cSensorIndex, cPThermalSettings)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPerformanceState function as declared in nvml/nvml.h
func nvmlDeviceGetPerformanceState(nvmlDevice nvmlDevice, PState *Pstates) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPState, _ := (*C.nvmlPstates_t)(unsafe.Pointer(PState)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPerformanceState(cnvmlDevice, cPState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCurrentClocksEventReasons function as declared in nvml/nvml.h
func nvmlDeviceGetCurrentClocksEventReasons(nvmlDevice nvmlDevice, ClocksEventReasons *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClocksEventReasons, _ := (*C.ulonglong)(unsafe.Pointer(ClocksEventReasons)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCurrentClocksEventReasons(cnvmlDevice, cClocksEventReasons)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCurrentClocksThrottleReasons function as declared in nvml/nvml.h
func nvmlDeviceGetCurrentClocksThrottleReasons(nvmlDevice nvmlDevice, ClocksThrottleReasons *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cClocksThrottleReasons, _ := (*C.ulonglong)(unsafe.Pointer(ClocksThrottleReasons)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCurrentClocksThrottleReasons(cnvmlDevice, cClocksThrottleReasons)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedClocksEventReasons function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedClocksEventReasons(nvmlDevice nvmlDevice, SupportedClocksEventReasons *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSupportedClocksEventReasons, _ := (*C.ulonglong)(unsafe.Pointer(SupportedClocksEventReasons)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedClocksEventReasons(cnvmlDevice, cSupportedClocksEventReasons)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedClocksThrottleReasons function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedClocksThrottleReasons(nvmlDevice nvmlDevice, SupportedClocksThrottleReasons *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSupportedClocksThrottleReasons, _ := (*C.ulonglong)(unsafe.Pointer(SupportedClocksThrottleReasons)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedClocksThrottleReasons(cnvmlDevice, cSupportedClocksThrottleReasons)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerState function as declared in nvml/nvml.h
func nvmlDeviceGetPowerState(nvmlDevice nvmlDevice, PState *Pstates) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPState, _ := (*C.nvmlPstates_t)(unsafe.Pointer(PState)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerState(cnvmlDevice, cPState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDynamicPstatesInfo function as declared in nvml/nvml.h
func nvmlDeviceGetDynamicPstatesInfo(nvmlDevice nvmlDevice, PDynamicPstatesInfo *GpuDynamicPstatesInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPDynamicPstatesInfo, _ := (*C.nvmlGpuDynamicPstatesInfo_t)(unsafe.Pointer(PDynamicPstatesInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDynamicPstatesInfo(cnvmlDevice, cPDynamicPstatesInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemClkVfOffset function as declared in nvml/nvml.h
func nvmlDeviceGetMemClkVfOffset(nvmlDevice nvmlDevice, Offset *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cOffset, _ := (*C.int)(unsafe.Pointer(Offset)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemClkVfOffset(cnvmlDevice, cOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMinMaxClockOfPState function as declared in nvml/nvml.h
func nvmlDeviceGetMinMaxClockOfPState(nvmlDevice nvmlDevice, _type ClockType, Pstate Pstates, MinClockMHz *uint32, MaxClockMHz *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (C.nvmlClockType_t)(_type), cgoAllocsUnknown
	cPstate, _ := (C.nvmlPstates_t)(Pstate), cgoAllocsUnknown
	cMinClockMHz, _ := (*C.uint)(unsafe.Pointer(MinClockMHz)), cgoAllocsUnknown
	cMaxClockMHz, _ := (*C.uint)(unsafe.Pointer(MaxClockMHz)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMinMaxClockOfPState(cnvmlDevice, c_type, cPstate, cMinClockMHz, cMaxClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedPerformanceStates function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedPerformanceStates(nvmlDevice nvmlDevice, Pstates *Pstates, Size uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPstates, _ := (*C.nvmlPstates_t)(unsafe.Pointer(Pstates)), cgoAllocsUnknown
	cSize, _ := (C.uint)(Size), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedPerformanceStates(cnvmlDevice, cPstates, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpcClkMinMaxVfOffset function as declared in nvml/nvml.h
func nvmlDeviceGetGpcClkMinMaxVfOffset(nvmlDevice nvmlDevice, MinOffset *int32, MaxOffset *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinOffset, _ := (*C.int)(unsafe.Pointer(MinOffset)), cgoAllocsUnknown
	cMaxOffset, _ := (*C.int)(unsafe.Pointer(MaxOffset)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpcClkMinMaxVfOffset(cnvmlDevice, cMinOffset, cMaxOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemClkMinMaxVfOffset function as declared in nvml/nvml.h
func nvmlDeviceGetMemClkMinMaxVfOffset(nvmlDevice nvmlDevice, MinOffset *int32, MaxOffset *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinOffset, _ := (*C.int)(unsafe.Pointer(MinOffset)), cgoAllocsUnknown
	cMaxOffset, _ := (*C.int)(unsafe.Pointer(MaxOffset)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemClkMinMaxVfOffset(cnvmlDevice, cMinOffset, cMaxOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetClockOffsets function as declared in nvml/nvml.h
func nvmlDeviceGetClockOffsets(nvmlDevice nvmlDevice, Info *ClockOffset) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlClockOffset_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetClockOffsets(cnvmlDevice, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetClockOffsets function as declared in nvml/nvml.h
func nvmlDeviceSetClockOffsets(nvmlDevice nvmlDevice, Info *ClockOffset) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlClockOffset_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetClockOffsets(cnvmlDevice, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPerformanceModes function as declared in nvml/nvml.h
func nvmlDeviceGetPerformanceModes(nvmlDevice nvmlDevice, PerfModes *DevicePerfModes) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPerfModes, _ := (*C.nvmlDevicePerfModes_t)(unsafe.Pointer(PerfModes)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPerformanceModes(cnvmlDevice, cPerfModes)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCurrentClockFreqs function as declared in nvml/nvml.h
func nvmlDeviceGetCurrentClockFreqs(nvmlDevice nvmlDevice, CurrentClockFreqs *DeviceCurrentClockFreqs) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrentClockFreqs, _ := (*C.nvmlDeviceCurrentClockFreqs_t)(unsafe.Pointer(CurrentClockFreqs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCurrentClockFreqs(cnvmlDevice, cCurrentClockFreqs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerManagementMode function as declared in nvml/nvml.h
func nvmlDeviceGetPowerManagementMode(nvmlDevice nvmlDevice, Mode *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Mode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerManagementMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerManagementLimit function as declared in nvml/nvml.h
func nvmlDeviceGetPowerManagementLimit(nvmlDevice nvmlDevice, Limit *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLimit, _ := (*C.uint)(unsafe.Pointer(Limit)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerManagementLimit(cnvmlDevice, cLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerManagementLimitConstraints function as declared in nvml/nvml.h
func nvmlDeviceGetPowerManagementLimitConstraints(nvmlDevice nvmlDevice, MinLimit *uint32, MaxLimit *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinLimit, _ := (*C.uint)(unsafe.Pointer(MinLimit)), cgoAllocsUnknown
	cMaxLimit, _ := (*C.uint)(unsafe.Pointer(MaxLimit)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerManagementLimitConstraints(cnvmlDevice, cMinLimit, cMaxLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerManagementDefaultLimit function as declared in nvml/nvml.h
func nvmlDeviceGetPowerManagementDefaultLimit(nvmlDevice nvmlDevice, DefaultLimit *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cDefaultLimit, _ := (*C.uint)(unsafe.Pointer(DefaultLimit)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerManagementDefaultLimit(cnvmlDevice, cDefaultLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerUsage function as declared in nvml/nvml.h
func nvmlDeviceGetPowerUsage(nvmlDevice nvmlDevice, Power *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPower, _ := (*C.uint)(unsafe.Pointer(Power)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerUsage(cnvmlDevice, cPower)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTotalEnergyConsumption function as declared in nvml/nvml.h
func nvmlDeviceGetTotalEnergyConsumption(nvmlDevice nvmlDevice, Energy *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEnergy, _ := (*C.ulonglong)(unsafe.Pointer(Energy)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTotalEnergyConsumption(cnvmlDevice, cEnergy)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEnforcedPowerLimit function as declared in nvml/nvml.h
func nvmlDeviceGetEnforcedPowerLimit(nvmlDevice nvmlDevice, Limit *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLimit, _ := (*C.uint)(unsafe.Pointer(Limit)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEnforcedPowerLimit(cnvmlDevice, cLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuOperationMode function as declared in nvml/nvml.h
func nvmlDeviceGetGpuOperationMode(nvmlDevice nvmlDevice, Current *GpuOperationMode, Pending *GpuOperationMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlGpuOperationMode_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	cPending, _ := (*C.nvmlGpuOperationMode_t)(unsafe.Pointer(Pending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuOperationMode(cnvmlDevice, cCurrent, cPending)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemoryInfo function as declared in nvml/nvml.h
func nvmlDeviceGetMemoryInfo(nvmlDevice nvmlDevice, Memory *Memory) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemory, _ := (*C.nvmlMemory_t)(unsafe.Pointer(Memory)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemoryInfo(cnvmlDevice, cMemory)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemoryInfo_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetMemoryInfo_v2(nvmlDevice nvmlDevice, Memory *Memory_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemory, _ := (*C.nvmlMemory_v2_t)(unsafe.Pointer(Memory)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemoryInfo_v2(cnvmlDevice, cMemory)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetComputeMode function as declared in nvml/nvml.h
func nvmlDeviceGetComputeMode(nvmlDevice nvmlDevice, Mode *ComputeMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (*C.nvmlComputeMode_t)(unsafe.Pointer(Mode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetComputeMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCudaComputeCapability function as declared in nvml/nvml.h
func nvmlDeviceGetCudaComputeCapability(nvmlDevice nvmlDevice, Major *int32, Minor *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMajor, _ := (*C.int)(unsafe.Pointer(Major)), cgoAllocsUnknown
	cMinor, _ := (*C.int)(unsafe.Pointer(Minor)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCudaComputeCapability(cnvmlDevice, cMajor, cMinor)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDramEncryptionMode function as declared in nvml/nvml.h
func nvmlDeviceGetDramEncryptionMode(nvmlDevice nvmlDevice, Current *DramEncryptionInfo, Pending *DramEncryptionInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlDramEncryptionInfo_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	cPending, _ := (*C.nvmlDramEncryptionInfo_t)(unsafe.Pointer(Pending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDramEncryptionMode(cnvmlDevice, cCurrent, cPending)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetDramEncryptionMode function as declared in nvml/nvml.h
func nvmlDeviceSetDramEncryptionMode(nvmlDevice nvmlDevice, DramEncryption *DramEncryptionInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cDramEncryption, _ := (*C.nvmlDramEncryptionInfo_t)(unsafe.Pointer(DramEncryption)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetDramEncryptionMode(cnvmlDevice, cDramEncryption)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEccMode function as declared in nvml/nvml.h
func nvmlDeviceGetEccMode(nvmlDevice nvmlDevice, Current *EnableState, Pending *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	cPending, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Pending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEccMode(cnvmlDevice, cCurrent, cPending)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDefaultEccMode function as declared in nvml/nvml.h
func nvmlDeviceGetDefaultEccMode(nvmlDevice nvmlDevice, DefaultMode *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cDefaultMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(DefaultMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDefaultEccMode(cnvmlDevice, cDefaultMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBoardId function as declared in nvml/nvml.h
func nvmlDeviceGetBoardId(nvmlDevice nvmlDevice, BoardId *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cBoardId, _ := (*C.uint)(unsafe.Pointer(BoardId)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBoardId(cnvmlDevice, cBoardId)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMultiGpuBoard function as declared in nvml/nvml.h
func nvmlDeviceGetMultiGpuBoard(nvmlDevice nvmlDevice, MultiGpuBool *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMultiGpuBool, _ := (*C.uint)(unsafe.Pointer(MultiGpuBool)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMultiGpuBoard(cnvmlDevice, cMultiGpuBool)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetTotalEccErrors function as declared in nvml/nvml.h
func nvmlDeviceGetTotalEccErrors(nvmlDevice nvmlDevice, ErrorType MemoryErrorType, CounterType EccCounterType, EccCounts *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cErrorType, _ := (C.nvmlMemoryErrorType_t)(ErrorType), cgoAllocsUnknown
	cCounterType, _ := (C.nvmlEccCounterType_t)(CounterType), cgoAllocsUnknown
	cEccCounts, _ := (*C.ulonglong)(unsafe.Pointer(EccCounts)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetTotalEccErrors(cnvmlDevice, cErrorType, cCounterType, cEccCounts)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDetailedEccErrors function as declared in nvml/nvml.h
func nvmlDeviceGetDetailedEccErrors(nvmlDevice nvmlDevice, ErrorType MemoryErrorType, CounterType EccCounterType, EccCounts *EccErrorCounts) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cErrorType, _ := (C.nvmlMemoryErrorType_t)(ErrorType), cgoAllocsUnknown
	cCounterType, _ := (C.nvmlEccCounterType_t)(CounterType), cgoAllocsUnknown
	cEccCounts, _ := (*C.nvmlEccErrorCounts_t)(unsafe.Pointer(EccCounts)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDetailedEccErrors(cnvmlDevice, cErrorType, cCounterType, cEccCounts)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemoryErrorCounter function as declared in nvml/nvml.h
func nvmlDeviceGetMemoryErrorCounter(nvmlDevice nvmlDevice, ErrorType MemoryErrorType, CounterType EccCounterType, LocationType MemoryLocation, Count *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cErrorType, _ := (C.nvmlMemoryErrorType_t)(ErrorType), cgoAllocsUnknown
	cCounterType, _ := (C.nvmlEccCounterType_t)(CounterType), cgoAllocsUnknown
	cLocationType, _ := (C.nvmlMemoryLocation_t)(LocationType), cgoAllocsUnknown
	cCount, _ := (*C.ulonglong)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemoryErrorCounter(cnvmlDevice, cErrorType, cCounterType, cLocationType, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetUtilizationRates function as declared in nvml/nvml.h
func nvmlDeviceGetUtilizationRates(nvmlDevice nvmlDevice, Utilization *Utilization) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.nvmlUtilization_t)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetUtilizationRates(cnvmlDevice, cUtilization)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEncoderUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetEncoderUtilization(nvmlDevice nvmlDevice, Utilization *uint32, SamplingPeriodUs *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.uint)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	cSamplingPeriodUs, _ := (*C.uint)(unsafe.Pointer(SamplingPeriodUs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEncoderUtilization(cnvmlDevice, cUtilization, cSamplingPeriodUs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEncoderCapacity function as declared in nvml/nvml.h
func nvmlDeviceGetEncoderCapacity(nvmlDevice nvmlDevice, EncoderQueryType EncoderType, EncoderCapacity *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEncoderQueryType, _ := (C.nvmlEncoderType_t)(EncoderQueryType), cgoAllocsUnknown
	cEncoderCapacity, _ := (*C.uint)(unsafe.Pointer(EncoderCapacity)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEncoderCapacity(cnvmlDevice, cEncoderQueryType, cEncoderCapacity)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEncoderStats function as declared in nvml/nvml.h
func nvmlDeviceGetEncoderStats(nvmlDevice nvmlDevice, SessionCount *uint32, AverageFps *uint32, AverageLatency *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cAverageFps, _ := (*C.uint)(unsafe.Pointer(AverageFps)), cgoAllocsUnknown
	cAverageLatency, _ := (*C.uint)(unsafe.Pointer(AverageLatency)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEncoderStats(cnvmlDevice, cSessionCount, cAverageFps, cAverageLatency)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetEncoderSessions function as declared in nvml/nvml.h
func nvmlDeviceGetEncoderSessions(nvmlDevice nvmlDevice, SessionCount *uint32, SessionInfos *EncoderSessionInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cSessionInfos, _ := (*C.nvmlEncoderSessionInfo_t)(unsafe.Pointer(SessionInfos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetEncoderSessions(cnvmlDevice, cSessionCount, cSessionInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDecoderUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetDecoderUtilization(nvmlDevice nvmlDevice, Utilization *uint32, SamplingPeriodUs *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.uint)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	cSamplingPeriodUs, _ := (*C.uint)(unsafe.Pointer(SamplingPeriodUs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDecoderUtilization(cnvmlDevice, cUtilization, cSamplingPeriodUs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetJpgUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetJpgUtilization(nvmlDevice nvmlDevice, Utilization *uint32, SamplingPeriodUs *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.uint)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	cSamplingPeriodUs, _ := (*C.uint)(unsafe.Pointer(SamplingPeriodUs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetJpgUtilization(cnvmlDevice, cUtilization, cSamplingPeriodUs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetOfaUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetOfaUtilization(nvmlDevice nvmlDevice, Utilization *uint32, SamplingPeriodUs *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.uint)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	cSamplingPeriodUs, _ := (*C.uint)(unsafe.Pointer(SamplingPeriodUs)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetOfaUtilization(cnvmlDevice, cUtilization, cSamplingPeriodUs)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFBCStats function as declared in nvml/nvml.h
func nvmlDeviceGetFBCStats(nvmlDevice nvmlDevice, FbcStats *FBCStats) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFbcStats, _ := (*C.nvmlFBCStats_t)(unsafe.Pointer(FbcStats)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFBCStats(cnvmlDevice, cFbcStats)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFBCSessions function as declared in nvml/nvml.h
func nvmlDeviceGetFBCSessions(nvmlDevice nvmlDevice, SessionCount *uint32, SessionInfo *FBCSessionInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cSessionInfo, _ := (*C.nvmlFBCSessionInfo_t)(unsafe.Pointer(SessionInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFBCSessions(cnvmlDevice, cSessionCount, cSessionInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDriverModel_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetDriverModel_v2(nvmlDevice nvmlDevice, Current *DriverModel, Pending *DriverModel) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlDriverModel_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	cPending, _ := (*C.nvmlDriverModel_t)(unsafe.Pointer(Pending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDriverModel_v2(cnvmlDevice, cCurrent, cPending)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVbiosVersion function as declared in nvml/nvml.h
func nvmlDeviceGetVbiosVersion(nvmlDevice nvmlDevice, Version *byte, Length uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVbiosVersion(cnvmlDevice, cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBridgeChipInfo function as declared in nvml/nvml.h
func nvmlDeviceGetBridgeChipInfo(nvmlDevice nvmlDevice, BridgeHierarchy *BridgeChipHierarchy) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cBridgeHierarchy, _ := (*C.nvmlBridgeChipHierarchy_t)(unsafe.Pointer(BridgeHierarchy)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBridgeChipInfo(cnvmlDevice, cBridgeHierarchy)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetComputeRunningProcesses_v3 function as declared in nvml/nvml.h
func nvmlDeviceGetComputeRunningProcesses_v3(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetComputeRunningProcesses_v3(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGraphicsRunningProcesses_v3 function as declared in nvml/nvml.h
func nvmlDeviceGetGraphicsRunningProcesses_v3(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGraphicsRunningProcesses_v3(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMPSComputeRunningProcesses_v3 function as declared in nvml/nvml.h
func nvmlDeviceGetMPSComputeRunningProcesses_v3(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMPSComputeRunningProcesses_v3(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRunningProcessDetailList function as declared in nvml/nvml.h
func nvmlDeviceGetRunningProcessDetailList(nvmlDevice nvmlDevice, Plist *ProcessDetailList) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPlist, _ := (*C.nvmlProcessDetailList_t)(unsafe.Pointer(Plist)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRunningProcessDetailList(cnvmlDevice, cPlist)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceOnSameBoard function as declared in nvml/nvml.h
func nvmlDeviceOnSameBoard(Device1 nvmlDevice, Device2 nvmlDevice, OnSameBoard *int32) Return {
	cDevice1, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device1)), cgoAllocsUnknown
	cDevice2, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&Device2)), cgoAllocsUnknown
	cOnSameBoard, _ := (*C.int)(unsafe.Pointer(OnSameBoard)), cgoAllocsUnknown
	__ret := C.nvmlDeviceOnSameBoard(cDevice1, cDevice2, cOnSameBoard)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAPIRestriction function as declared in nvml/nvml.h
func nvmlDeviceGetAPIRestriction(nvmlDevice nvmlDevice, ApiType RestrictedAPI, IsRestricted *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cApiType, _ := (C.nvmlRestrictedAPI_t)(ApiType), cgoAllocsUnknown
	cIsRestricted, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(IsRestricted)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAPIRestriction(cnvmlDevice, cApiType, cIsRestricted)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSamples function as declared in nvml/nvml.h
func nvmlDeviceGetSamples(nvmlDevice nvmlDevice, _type SamplingType, LastSeenTimeStamp uint64, SampleValType *ValueType, SampleCount *uint32, Samples *Sample) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (C.nvmlSamplingType_t)(_type), cgoAllocsUnknown
	cLastSeenTimeStamp, _ := (C.ulonglong)(LastSeenTimeStamp), cgoAllocsUnknown
	cSampleValType, _ := (*C.nvmlValueType_t)(unsafe.Pointer(SampleValType)), cgoAllocsUnknown
	cSampleCount, _ := (*C.uint)(unsafe.Pointer(SampleCount)), cgoAllocsUnknown
	cSamples, _ := (*C.nvmlSample_t)(unsafe.Pointer(Samples)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSamples(cnvmlDevice, c_type, cLastSeenTimeStamp, cSampleValType, cSampleCount, cSamples)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBAR1MemoryInfo function as declared in nvml/nvml.h
func nvmlDeviceGetBAR1MemoryInfo(nvmlDevice nvmlDevice, Bar1Memory *BAR1Memory) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cBar1Memory, _ := (*C.nvmlBAR1Memory_t)(unsafe.Pointer(Bar1Memory)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBAR1MemoryInfo(cnvmlDevice, cBar1Memory)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetViolationStatus function as declared in nvml/nvml.h
func nvmlDeviceGetViolationStatus(nvmlDevice nvmlDevice, PerfPolicyType PerfPolicyType, ViolTime *ViolationTime) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPerfPolicyType, _ := (C.nvmlPerfPolicyType_t)(PerfPolicyType), cgoAllocsUnknown
	cViolTime, _ := (*C.nvmlViolationTime_t)(unsafe.Pointer(ViolTime)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetViolationStatus(cnvmlDevice, cPerfPolicyType, cViolTime)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetIrqNum function as declared in nvml/nvml.h
func nvmlDeviceGetIrqNum(nvmlDevice nvmlDevice, IrqNum *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIrqNum, _ := (*C.uint)(unsafe.Pointer(IrqNum)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetIrqNum(cnvmlDevice, cIrqNum)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNumGpuCores function as declared in nvml/nvml.h
func nvmlDeviceGetNumGpuCores(nvmlDevice nvmlDevice, NumCores *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cNumCores, _ := (*C.uint)(unsafe.Pointer(NumCores)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNumGpuCores(cnvmlDevice, cNumCores)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPowerSource function as declared in nvml/nvml.h
func nvmlDeviceGetPowerSource(nvmlDevice nvmlDevice, PowerSource *PowerSource) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPowerSource, _ := (*C.nvmlPowerSource_t)(unsafe.Pointer(PowerSource)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPowerSource(cnvmlDevice, cPowerSource)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMemoryBusWidth function as declared in nvml/nvml.h
func nvmlDeviceGetMemoryBusWidth(nvmlDevice nvmlDevice, BusWidth *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cBusWidth, _ := (*C.uint)(unsafe.Pointer(BusWidth)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMemoryBusWidth(cnvmlDevice, cBusWidth)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPcieLinkMaxSpeed function as declared in nvml/nvml.h
func nvmlDeviceGetPcieLinkMaxSpeed(nvmlDevice nvmlDevice, MaxSpeed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMaxSpeed, _ := (*C.uint)(unsafe.Pointer(MaxSpeed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPcieLinkMaxSpeed(cnvmlDevice, cMaxSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPcieSpeed function as declared in nvml/nvml.h
func nvmlDeviceGetPcieSpeed(nvmlDevice nvmlDevice, PcieSpeed *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPcieSpeed, _ := (*C.uint)(unsafe.Pointer(PcieSpeed)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPcieSpeed(cnvmlDevice, cPcieSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAdaptiveClockInfoStatus function as declared in nvml/nvml.h
func nvmlDeviceGetAdaptiveClockInfoStatus(nvmlDevice nvmlDevice, AdaptiveClockStatus *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cAdaptiveClockStatus, _ := (*C.uint)(unsafe.Pointer(AdaptiveClockStatus)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAdaptiveClockInfoStatus(cnvmlDevice, cAdaptiveClockStatus)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetBusType function as declared in nvml/nvml.h
func nvmlDeviceGetBusType(nvmlDevice nvmlDevice, _type *BusType) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	c_type, _ := (*C.nvmlBusType_t)(unsafe.Pointer(_type)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetBusType(cnvmlDevice, c_type)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuFabricInfo function as declared in nvml/nvml.h
func nvmlDeviceGetGpuFabricInfo(nvmlDevice nvmlDevice, GpuFabricInfo *GpuFabricInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpuFabricInfo, _ := (*C.nvmlGpuFabricInfo_t)(unsafe.Pointer(GpuFabricInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuFabricInfo(cnvmlDevice, cGpuFabricInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuFabricInfoV function as declared in nvml/nvml.h
func nvmlDeviceGetGpuFabricInfoV(nvmlDevice nvmlDevice, GpuFabricInfo *GpuFabricInfoV) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpuFabricInfo, _ := (*C.nvmlGpuFabricInfoV_t)(unsafe.Pointer(GpuFabricInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuFabricInfoV(cnvmlDevice, cGpuFabricInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetConfComputeCapabilities function as declared in nvml/nvml.h
func nvmlSystemGetConfComputeCapabilities(Capabilities *ConfComputeSystemCaps) Return {
	cCapabilities, _ := (*C.nvmlConfComputeSystemCaps_t)(unsafe.Pointer(Capabilities)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetConfComputeCapabilities(cCapabilities)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetConfComputeState function as declared in nvml/nvml.h
func nvmlSystemGetConfComputeState(State *ConfComputeSystemState) Return {
	cState, _ := (*C.nvmlConfComputeSystemState_t)(unsafe.Pointer(State)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetConfComputeState(cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetConfComputeMemSizeInfo function as declared in nvml/nvml.h
func nvmlDeviceGetConfComputeMemSizeInfo(nvmlDevice nvmlDevice, MemInfo *ConfComputeMemSizeInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemInfo, _ := (*C.nvmlConfComputeMemSizeInfo_t)(unsafe.Pointer(MemInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetConfComputeMemSizeInfo(cnvmlDevice, cMemInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetConfComputeGpusReadyState function as declared in nvml/nvml.h
func nvmlSystemGetConfComputeGpusReadyState(IsAcceptingWork *uint32) Return {
	cIsAcceptingWork, _ := (*C.uint)(unsafe.Pointer(IsAcceptingWork)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetConfComputeGpusReadyState(cIsAcceptingWork)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetConfComputeProtectedMemoryUsage function as declared in nvml/nvml.h
func nvmlDeviceGetConfComputeProtectedMemoryUsage(nvmlDevice nvmlDevice, Memory *Memory) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemory, _ := (*C.nvmlMemory_t)(unsafe.Pointer(Memory)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetConfComputeProtectedMemoryUsage(cnvmlDevice, cMemory)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetConfComputeGpuCertificate function as declared in nvml/nvml.h
func nvmlDeviceGetConfComputeGpuCertificate(nvmlDevice nvmlDevice, GpuCert *ConfComputeGpuCertificate) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpuCert, _ := (*C.nvmlConfComputeGpuCertificate_t)(unsafe.Pointer(GpuCert)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetConfComputeGpuCertificate(cnvmlDevice, cGpuCert)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetConfComputeGpuAttestationReport function as declared in nvml/nvml.h
func nvmlDeviceGetConfComputeGpuAttestationReport(nvmlDevice nvmlDevice, GpuAtstReport *ConfComputeGpuAttestationReport) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpuAtstReport, _ := (*C.nvmlConfComputeGpuAttestationReport_t)(unsafe.Pointer(GpuAtstReport)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetConfComputeGpuAttestationReport(cnvmlDevice, cGpuAtstReport)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetConfComputeKeyRotationThresholdInfo function as declared in nvml/nvml.h
func nvmlSystemGetConfComputeKeyRotationThresholdInfo(PKeyRotationThrInfo *ConfComputeGetKeyRotationThresholdInfo) Return {
	cPKeyRotationThrInfo, _ := (*C.nvmlConfComputeGetKeyRotationThresholdInfo_t)(unsafe.Pointer(PKeyRotationThrInfo)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetConfComputeKeyRotationThresholdInfo(cPKeyRotationThrInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetConfComputeUnprotectedMemSize function as declared in nvml/nvml.h
func nvmlDeviceSetConfComputeUnprotectedMemSize(nvmlDevice nvmlDevice, SizeKiB uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSizeKiB, _ := (C.ulonglong)(SizeKiB), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetConfComputeUnprotectedMemSize(cnvmlDevice, cSizeKiB)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemSetConfComputeGpusReadyState function as declared in nvml/nvml.h
func nvmlSystemSetConfComputeGpusReadyState(IsAcceptingWork uint32) Return {
	cIsAcceptingWork, _ := (C.uint)(IsAcceptingWork), cgoAllocsUnknown
	__ret := C.nvmlSystemSetConfComputeGpusReadyState(cIsAcceptingWork)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemSetConfComputeKeyRotationThresholdInfo function as declared in nvml/nvml.h
func nvmlSystemSetConfComputeKeyRotationThresholdInfo(PKeyRotationThrInfo *ConfComputeSetKeyRotationThresholdInfo) Return {
	cPKeyRotationThrInfo, _ := (*C.nvmlConfComputeSetKeyRotationThresholdInfo_t)(unsafe.Pointer(PKeyRotationThrInfo)), cgoAllocsUnknown
	__ret := C.nvmlSystemSetConfComputeKeyRotationThresholdInfo(cPKeyRotationThrInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetConfComputeSettings function as declared in nvml/nvml.h
func nvmlSystemGetConfComputeSettings(Settings *SystemConfComputeSettings) Return {
	cSettings, _ := (*C.nvmlSystemConfComputeSettings_t)(unsafe.Pointer(Settings)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetConfComputeSettings(cSettings)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGspFirmwareVersion function as declared in nvml/nvml.h
func nvmlDeviceGetGspFirmwareVersion(nvmlDevice nvmlDevice, Version *byte) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGspFirmwareVersion(cnvmlDevice, cVersion)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGspFirmwareMode function as declared in nvml/nvml.h
func nvmlDeviceGetGspFirmwareMode(nvmlDevice nvmlDevice, IsEnabled *uint32, DefaultMode *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIsEnabled, _ := (*C.uint)(unsafe.Pointer(IsEnabled)), cgoAllocsUnknown
	cDefaultMode, _ := (*C.uint)(unsafe.Pointer(DefaultMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGspFirmwareMode(cnvmlDevice, cIsEnabled, cDefaultMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSramEccErrorStatus function as declared in nvml/nvml.h
func nvmlDeviceGetSramEccErrorStatus(nvmlDevice nvmlDevice, Status *EccSramErrorStatus) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cStatus, _ := (*C.nvmlEccSramErrorStatus_t)(unsafe.Pointer(Status)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSramEccErrorStatus(cnvmlDevice, cStatus)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAccountingMode function as declared in nvml/nvml.h
func nvmlDeviceGetAccountingMode(nvmlDevice nvmlDevice, Mode *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Mode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAccountingMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAccountingStats function as declared in nvml/nvml.h
func nvmlDeviceGetAccountingStats(nvmlDevice nvmlDevice, Pid uint32, Stats *AccountingStats) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPid, _ := (C.uint)(Pid), cgoAllocsUnknown
	cStats, _ := (*C.nvmlAccountingStats_t)(unsafe.Pointer(Stats)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAccountingStats(cnvmlDevice, cPid, cStats)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAccountingPids function as declared in nvml/nvml.h
func nvmlDeviceGetAccountingPids(nvmlDevice nvmlDevice, Count *uint32, Pids *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cPids, _ := (*C.uint)(unsafe.Pointer(Pids)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAccountingPids(cnvmlDevice, cCount, cPids)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAccountingBufferSize function as declared in nvml/nvml.h
func nvmlDeviceGetAccountingBufferSize(nvmlDevice nvmlDevice, BufferSize *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cBufferSize, _ := (*C.uint)(unsafe.Pointer(BufferSize)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAccountingBufferSize(cnvmlDevice, cBufferSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRetiredPages function as declared in nvml/nvml.h
func nvmlDeviceGetRetiredPages(nvmlDevice nvmlDevice, Cause PageRetirementCause, PageCount *uint32, Addresses *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCause, _ := (C.nvmlPageRetirementCause_t)(Cause), cgoAllocsUnknown
	cPageCount, _ := (*C.uint)(unsafe.Pointer(PageCount)), cgoAllocsUnknown
	cAddresses, _ := (*C.ulonglong)(unsafe.Pointer(Addresses)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRetiredPages(cnvmlDevice, cCause, cPageCount, cAddresses)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRetiredPages_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetRetiredPages_v2(nvmlDevice nvmlDevice, Cause PageRetirementCause, PageCount *uint32, Addresses *uint64, Timestamps *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCause, _ := (C.nvmlPageRetirementCause_t)(Cause), cgoAllocsUnknown
	cPageCount, _ := (*C.uint)(unsafe.Pointer(PageCount)), cgoAllocsUnknown
	cAddresses, _ := (*C.ulonglong)(unsafe.Pointer(Addresses)), cgoAllocsUnknown
	cTimestamps, _ := (*C.ulonglong)(unsafe.Pointer(Timestamps)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRetiredPages_v2(cnvmlDevice, cCause, cPageCount, cAddresses, cTimestamps)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRetiredPagesPendingStatus function as declared in nvml/nvml.h
func nvmlDeviceGetRetiredPagesPendingStatus(nvmlDevice nvmlDevice, IsPending *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIsPending, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(IsPending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRetiredPagesPendingStatus(cnvmlDevice, cIsPending)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRemappedRows function as declared in nvml/nvml.h
func nvmlDeviceGetRemappedRows(nvmlDevice nvmlDevice, CorrRows *uint32, UncRows *uint32, IsPending *uint32, FailureOccurred *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCorrRows, _ := (*C.uint)(unsafe.Pointer(CorrRows)), cgoAllocsUnknown
	cUncRows, _ := (*C.uint)(unsafe.Pointer(UncRows)), cgoAllocsUnknown
	cIsPending, _ := (*C.uint)(unsafe.Pointer(IsPending)), cgoAllocsUnknown
	cFailureOccurred, _ := (*C.uint)(unsafe.Pointer(FailureOccurred)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRemappedRows(cnvmlDevice, cCorrRows, cUncRows, cIsPending, cFailureOccurred)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetRowRemapperHistogram function as declared in nvml/nvml.h
func nvmlDeviceGetRowRemapperHistogram(nvmlDevice nvmlDevice, Values *RowRemapperHistogramValues) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cValues, _ := (*C.nvmlRowRemapperHistogramValues_t)(unsafe.Pointer(Values)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetRowRemapperHistogram(cnvmlDevice, cValues)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetArchitecture function as declared in nvml/nvml.h
func nvmlDeviceGetArchitecture(nvmlDevice nvmlDevice, Arch *DeviceArchitecture) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cArch, _ := (*C.nvmlDeviceArchitecture_t)(unsafe.Pointer(Arch)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetArchitecture(cnvmlDevice, cArch)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetClkMonStatus function as declared in nvml/nvml.h
func nvmlDeviceGetClkMonStatus(nvmlDevice nvmlDevice, Status *ClkMonStatus) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cStatus, _ := (*C.nvmlClkMonStatus_t)(unsafe.Pointer(Status)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetClkMonStatus(cnvmlDevice, cStatus)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetProcessUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetProcessUtilization(nvmlDevice nvmlDevice, Utilization *ProcessUtilizationSample, ProcessSamplesCount *uint32, LastSeenTimeStamp uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cUtilization, _ := (*C.nvmlProcessUtilizationSample_t)(unsafe.Pointer(Utilization)), cgoAllocsUnknown
	cProcessSamplesCount, _ := (*C.uint)(unsafe.Pointer(ProcessSamplesCount)), cgoAllocsUnknown
	cLastSeenTimeStamp, _ := (C.ulonglong)(LastSeenTimeStamp), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetProcessUtilization(cnvmlDevice, cUtilization, cProcessSamplesCount, cLastSeenTimeStamp)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetProcessesUtilizationInfo function as declared in nvml/nvml.h
func nvmlDeviceGetProcessesUtilizationInfo(nvmlDevice nvmlDevice, ProcesesUtilInfo *ProcessesUtilizationInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProcesesUtilInfo, _ := (*C.nvmlProcessesUtilizationInfo_t)(unsafe.Pointer(ProcesesUtilInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetProcessesUtilizationInfo(cnvmlDevice, cProcesesUtilInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPlatformInfo function as declared in nvml/nvml.h
func nvmlDeviceGetPlatformInfo(nvmlDevice nvmlDevice, PlatformInfo *PlatformInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPlatformInfo, _ := (*C.nvmlPlatformInfo_t)(unsafe.Pointer(PlatformInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPlatformInfo(cnvmlDevice, cPlatformInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlUnitSetLedState function as declared in nvml/nvml.h
func nvmlUnitSetLedState(nvmlUnit nvmlUnit, Color LedColor) Return {
	cnvmlUnit, _ := *(*C.nvmlUnit_t)(unsafe.Pointer(&nvmlUnit)), cgoAllocsUnknown
	cColor, _ := (C.nvmlLedColor_t)(Color), cgoAllocsUnknown
	__ret := C.nvmlUnitSetLedState(cnvmlUnit, cColor)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetPersistenceMode function as declared in nvml/nvml.h
func nvmlDeviceSetPersistenceMode(nvmlDevice nvmlDevice, Mode EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (C.nvmlEnableState_t)(Mode), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetPersistenceMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetComputeMode function as declared in nvml/nvml.h
func nvmlDeviceSetComputeMode(nvmlDevice nvmlDevice, Mode ComputeMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (C.nvmlComputeMode_t)(Mode), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetComputeMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetEccMode function as declared in nvml/nvml.h
func nvmlDeviceSetEccMode(nvmlDevice nvmlDevice, Ecc EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEcc, _ := (C.nvmlEnableState_t)(Ecc), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetEccMode(cnvmlDevice, cEcc)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceClearEccErrorCounts function as declared in nvml/nvml.h
func nvmlDeviceClearEccErrorCounts(nvmlDevice nvmlDevice, CounterType EccCounterType) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCounterType, _ := (C.nvmlEccCounterType_t)(CounterType), cgoAllocsUnknown
	__ret := C.nvmlDeviceClearEccErrorCounts(cnvmlDevice, cCounterType)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetDriverModel function as declared in nvml/nvml.h
func nvmlDeviceSetDriverModel(nvmlDevice nvmlDevice, DriverModel DriverModel, Flags uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cDriverModel, _ := (C.nvmlDriverModel_t)(DriverModel), cgoAllocsUnknown
	cFlags, _ := (C.uint)(Flags), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetDriverModel(cnvmlDevice, cDriverModel, cFlags)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetGpuLockedClocks function as declared in nvml/nvml.h
func nvmlDeviceSetGpuLockedClocks(nvmlDevice nvmlDevice, MinGpuClockMHz uint32, MaxGpuClockMHz uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinGpuClockMHz, _ := (C.uint)(MinGpuClockMHz), cgoAllocsUnknown
	cMaxGpuClockMHz, _ := (C.uint)(MaxGpuClockMHz), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetGpuLockedClocks(cnvmlDevice, cMinGpuClockMHz, cMaxGpuClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceResetGpuLockedClocks function as declared in nvml/nvml.h
func nvmlDeviceResetGpuLockedClocks(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceResetGpuLockedClocks(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetMemoryLockedClocks function as declared in nvml/nvml.h
func nvmlDeviceSetMemoryLockedClocks(nvmlDevice nvmlDevice, MinMemClockMHz uint32, MaxMemClockMHz uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMinMemClockMHz, _ := (C.uint)(MinMemClockMHz), cgoAllocsUnknown
	cMaxMemClockMHz, _ := (C.uint)(MaxMemClockMHz), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetMemoryLockedClocks(cnvmlDevice, cMinMemClockMHz, cMaxMemClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceResetMemoryLockedClocks function as declared in nvml/nvml.h
func nvmlDeviceResetMemoryLockedClocks(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceResetMemoryLockedClocks(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetApplicationsClocks function as declared in nvml/nvml.h
func nvmlDeviceSetApplicationsClocks(nvmlDevice nvmlDevice, MemClockMHz uint32, GraphicsClockMHz uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMemClockMHz, _ := (C.uint)(MemClockMHz), cgoAllocsUnknown
	cGraphicsClockMHz, _ := (C.uint)(GraphicsClockMHz), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetApplicationsClocks(cnvmlDevice, cMemClockMHz, cGraphicsClockMHz)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceResetApplicationsClocks function as declared in nvml/nvml.h
func nvmlDeviceResetApplicationsClocks(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceResetApplicationsClocks(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetAutoBoostedClocksEnabled function as declared in nvml/nvml.h
func nvmlDeviceSetAutoBoostedClocksEnabled(nvmlDevice nvmlDevice, Enabled EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEnabled, _ := (C.nvmlEnableState_t)(Enabled), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetAutoBoostedClocksEnabled(cnvmlDevice, cEnabled)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetDefaultAutoBoostedClocksEnabled function as declared in nvml/nvml.h
func nvmlDeviceSetDefaultAutoBoostedClocksEnabled(nvmlDevice nvmlDevice, Enabled EnableState, Flags uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEnabled, _ := (C.nvmlEnableState_t)(Enabled), cgoAllocsUnknown
	cFlags, _ := (C.uint)(Flags), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetDefaultAutoBoostedClocksEnabled(cnvmlDevice, cEnabled, cFlags)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetDefaultFanSpeed_v2 function as declared in nvml/nvml.h
func nvmlDeviceSetDefaultFanSpeed_v2(nvmlDevice nvmlDevice, Fan uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetDefaultFanSpeed_v2(cnvmlDevice, cFan)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetFanControlPolicy function as declared in nvml/nvml.h
func nvmlDeviceSetFanControlPolicy(nvmlDevice nvmlDevice, Fan uint32, Policy FanControlPolicy) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	cPolicy, _ := (C.nvmlFanControlPolicy_t)(Policy), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetFanControlPolicy(cnvmlDevice, cFan, cPolicy)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetTemperatureThreshold function as declared in nvml/nvml.h
func nvmlDeviceSetTemperatureThreshold(nvmlDevice nvmlDevice, ThresholdType TemperatureThresholds, Temp *int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cThresholdType, _ := (C.nvmlTemperatureThresholds_t)(ThresholdType), cgoAllocsUnknown
	cTemp, _ := (*C.int)(unsafe.Pointer(Temp)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetTemperatureThreshold(cnvmlDevice, cThresholdType, cTemp)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetPowerManagementLimit function as declared in nvml/nvml.h
func nvmlDeviceSetPowerManagementLimit(nvmlDevice nvmlDevice, Limit uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLimit, _ := (C.uint)(Limit), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetPowerManagementLimit(cnvmlDevice, cLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetGpuOperationMode function as declared in nvml/nvml.h
func nvmlDeviceSetGpuOperationMode(nvmlDevice nvmlDevice, Mode GpuOperationMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (C.nvmlGpuOperationMode_t)(Mode), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetGpuOperationMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetAPIRestriction function as declared in nvml/nvml.h
func nvmlDeviceSetAPIRestriction(nvmlDevice nvmlDevice, ApiType RestrictedAPI, IsRestricted EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cApiType, _ := (C.nvmlRestrictedAPI_t)(ApiType), cgoAllocsUnknown
	cIsRestricted, _ := (C.nvmlEnableState_t)(IsRestricted), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetAPIRestriction(cnvmlDevice, cApiType, cIsRestricted)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetFanSpeed_v2 function as declared in nvml/nvml.h
func nvmlDeviceSetFanSpeed_v2(nvmlDevice nvmlDevice, Fan uint32, Speed uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cFan, _ := (C.uint)(Fan), cgoAllocsUnknown
	cSpeed, _ := (C.uint)(Speed), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetFanSpeed_v2(cnvmlDevice, cFan, cSpeed)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetGpcClkVfOffset function as declared in nvml/nvml.h
func nvmlDeviceSetGpcClkVfOffset(nvmlDevice nvmlDevice, Offset int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cOffset, _ := (C.int)(Offset), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetGpcClkVfOffset(cnvmlDevice, cOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetMemClkVfOffset function as declared in nvml/nvml.h
func nvmlDeviceSetMemClkVfOffset(nvmlDevice nvmlDevice, Offset int32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cOffset, _ := (C.int)(Offset), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetMemClkVfOffset(cnvmlDevice, cOffset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetAccountingMode function as declared in nvml/nvml.h
func nvmlDeviceSetAccountingMode(nvmlDevice nvmlDevice, Mode EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (C.nvmlEnableState_t)(Mode), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetAccountingMode(cnvmlDevice, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceClearAccountingPids function as declared in nvml/nvml.h
func nvmlDeviceClearAccountingPids(nvmlDevice nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceClearAccountingPids(cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetPowerManagementLimit_v2 function as declared in nvml/nvml.h
func nvmlDeviceSetPowerManagementLimit_v2(nvmlDevice nvmlDevice, PowerValue *PowerValue_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPowerValue, _ := (*C.nvmlPowerValue_v2_t)(unsafe.Pointer(PowerValue)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetPowerManagementLimit_v2(cnvmlDevice, cPowerValue)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkState function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkState(nvmlDevice nvmlDevice, Link uint32, IsActive *EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cIsActive, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(IsActive)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkState(cnvmlDevice, cLink, cIsActive)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkVersion function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkVersion(nvmlDevice nvmlDevice, Link uint32, Version *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cVersion, _ := (*C.uint)(unsafe.Pointer(Version)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkVersion(cnvmlDevice, cLink, cVersion)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkCapability function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkCapability(nvmlDevice nvmlDevice, Link uint32, Capability NvLinkCapability, CapResult *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCapability, _ := (C.nvmlNvLinkCapability_t)(Capability), cgoAllocsUnknown
	cCapResult, _ := (*C.uint)(unsafe.Pointer(CapResult)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkCapability(cnvmlDevice, cLink, cCapability, cCapResult)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkRemotePciInfo_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkRemotePciInfo_v2(nvmlDevice nvmlDevice, Link uint32, Pci *PciInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkRemotePciInfo_v2(cnvmlDevice, cLink, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkErrorCounter function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkErrorCounter(nvmlDevice nvmlDevice, Link uint32, Counter NvLinkErrorCounter, CounterValue *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.nvmlNvLinkErrorCounter_t)(Counter), cgoAllocsUnknown
	cCounterValue, _ := (*C.ulonglong)(unsafe.Pointer(CounterValue)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkErrorCounter(cnvmlDevice, cLink, cCounter, cCounterValue)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceResetNvLinkErrorCounters function as declared in nvml/nvml.h
func nvmlDeviceResetNvLinkErrorCounters(nvmlDevice nvmlDevice, Link uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	__ret := C.nvmlDeviceResetNvLinkErrorCounters(cnvmlDevice, cLink)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetNvLinkUtilizationControl function as declared in nvml/nvml.h
func nvmlDeviceSetNvLinkUtilizationControl(nvmlDevice nvmlDevice, Link uint32, Counter uint32, Control *NvLinkUtilizationControl, Reset uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.uint)(Counter), cgoAllocsUnknown
	cControl, _ := (*C.nvmlNvLinkUtilizationControl_t)(unsafe.Pointer(Control)), cgoAllocsUnknown
	cReset, _ := (C.uint)(Reset), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetNvLinkUtilizationControl(cnvmlDevice, cLink, cCounter, cControl, cReset)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkUtilizationControl function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkUtilizationControl(nvmlDevice nvmlDevice, Link uint32, Counter uint32, Control *NvLinkUtilizationControl) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.uint)(Counter), cgoAllocsUnknown
	cControl, _ := (*C.nvmlNvLinkUtilizationControl_t)(unsafe.Pointer(Control)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkUtilizationControl(cnvmlDevice, cLink, cCounter, cControl)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkUtilizationCounter function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkUtilizationCounter(nvmlDevice nvmlDevice, Link uint32, Counter uint32, Rxcounter *uint64, Txcounter *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.uint)(Counter), cgoAllocsUnknown
	cRxcounter, _ := (*C.ulonglong)(unsafe.Pointer(Rxcounter)), cgoAllocsUnknown
	cTxcounter, _ := (*C.ulonglong)(unsafe.Pointer(Txcounter)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkUtilizationCounter(cnvmlDevice, cLink, cCounter, cRxcounter, cTxcounter)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceFreezeNvLinkUtilizationCounter function as declared in nvml/nvml.h
func nvmlDeviceFreezeNvLinkUtilizationCounter(nvmlDevice nvmlDevice, Link uint32, Counter uint32, Freeze EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.uint)(Counter), cgoAllocsUnknown
	cFreeze, _ := (C.nvmlEnableState_t)(Freeze), cgoAllocsUnknown
	__ret := C.nvmlDeviceFreezeNvLinkUtilizationCounter(cnvmlDevice, cLink, cCounter, cFreeze)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceResetNvLinkUtilizationCounter function as declared in nvml/nvml.h
func nvmlDeviceResetNvLinkUtilizationCounter(nvmlDevice nvmlDevice, Link uint32, Counter uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cCounter, _ := (C.uint)(Counter), cgoAllocsUnknown
	__ret := C.nvmlDeviceResetNvLinkUtilizationCounter(cnvmlDevice, cLink, cCounter)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkRemoteDeviceType function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkRemoteDeviceType(nvmlDevice nvmlDevice, Link uint32, PNvLinkDeviceType *IntNvLinkDeviceType) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cPNvLinkDeviceType, _ := (*C.nvmlIntNvLinkDeviceType_t)(unsafe.Pointer(PNvLinkDeviceType)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkRemoteDeviceType(cnvmlDevice, cLink, cPNvLinkDeviceType)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetNvLinkDeviceLowPowerThreshold function as declared in nvml/nvml.h
func nvmlDeviceSetNvLinkDeviceLowPowerThreshold(nvmlDevice nvmlDevice, Info *NvLinkPowerThres) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlNvLinkPowerThres_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetNvLinkDeviceLowPowerThreshold(cnvmlDevice, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemSetNvlinkBwMode function as declared in nvml/nvml.h
func nvmlSystemSetNvlinkBwMode(NvlinkBwMode uint32) Return {
	cNvlinkBwMode, _ := (C.uint)(NvlinkBwMode), cgoAllocsUnknown
	__ret := C.nvmlSystemSetNvlinkBwMode(cNvlinkBwMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemGetNvlinkBwMode function as declared in nvml/nvml.h
func nvmlSystemGetNvlinkBwMode(NvlinkBwMode *uint32) Return {
	cNvlinkBwMode, _ := (*C.uint)(unsafe.Pointer(NvlinkBwMode)), cgoAllocsUnknown
	__ret := C.nvmlSystemGetNvlinkBwMode(cNvlinkBwMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvlinkSupportedBwModes function as declared in nvml/nvml.h
func nvmlDeviceGetNvlinkSupportedBwModes(nvmlDevice nvmlDevice, SupportedBwMode *NvlinkSupportedBwModes) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSupportedBwMode, _ := (*C.nvmlNvlinkSupportedBwModes_t)(unsafe.Pointer(SupportedBwMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvlinkSupportedBwModes(cnvmlDevice, cSupportedBwMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvlinkBwMode function as declared in nvml/nvml.h
func nvmlDeviceGetNvlinkBwMode(nvmlDevice nvmlDevice, GetBwMode *NvlinkGetBwMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGetBwMode, _ := (*C.nvmlNvlinkGetBwMode_t)(unsafe.Pointer(GetBwMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvlinkBwMode(cnvmlDevice, cGetBwMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetNvlinkBwMode function as declared in nvml/nvml.h
func nvmlDeviceSetNvlinkBwMode(nvmlDevice nvmlDevice, SetBwMode *NvlinkSetBwMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cSetBwMode, _ := (*C.nvmlNvlinkSetBwMode_t)(unsafe.Pointer(SetBwMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetNvlinkBwMode(cnvmlDevice, cSetBwMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlEventSetCreate function as declared in nvml/nvml.h
func nvmlEventSetCreate(Set *nvmlEventSet) Return {
	cSet, _ := (*C.nvmlEventSet_t)(unsafe.Pointer(Set)), cgoAllocsUnknown
	__ret := C.nvmlEventSetCreate(cSet)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceRegisterEvents function as declared in nvml/nvml.h
func nvmlDeviceRegisterEvents(nvmlDevice nvmlDevice, EventTypes uint64, Set nvmlEventSet) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEventTypes, _ := (C.ulonglong)(EventTypes), cgoAllocsUnknown
	cSet, _ := *(*C.nvmlEventSet_t)(unsafe.Pointer(&Set)), cgoAllocsUnknown
	__ret := C.nvmlDeviceRegisterEvents(cnvmlDevice, cEventTypes, cSet)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedEventTypes function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedEventTypes(nvmlDevice nvmlDevice, EventTypes *uint64) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cEventTypes, _ := (*C.ulonglong)(unsafe.Pointer(EventTypes)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedEventTypes(cnvmlDevice, cEventTypes)
	__v := (Return)(__ret)
	return __v
}

// nvmlEventSetWait_v2 function as declared in nvml/nvml.h
func nvmlEventSetWait_v2(Set nvmlEventSet, Data *nvmlEventData, Timeoutms uint32) Return {
	cSet, _ := *(*C.nvmlEventSet_t)(unsafe.Pointer(&Set)), cgoAllocsUnknown
	cData, _ := (*C.nvmlEventData_t)(unsafe.Pointer(Data)), cgoAllocsUnknown
	cTimeoutms, _ := (C.uint)(Timeoutms), cgoAllocsUnknown
	__ret := C.nvmlEventSetWait_v2(cSet, cData, cTimeoutms)
	__v := (Return)(__ret)
	return __v
}

// nvmlEventSetFree function as declared in nvml/nvml.h
func nvmlEventSetFree(Set nvmlEventSet) Return {
	cSet, _ := *(*C.nvmlEventSet_t)(unsafe.Pointer(&Set)), cgoAllocsUnknown
	__ret := C.nvmlEventSetFree(cSet)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemEventSetCreate function as declared in nvml/nvml.h
func nvmlSystemEventSetCreate(Request *SystemEventSetCreateRequest) Return {
	cRequest, _ := (*C.nvmlSystemEventSetCreateRequest_t)(unsafe.Pointer(Request)), cgoAllocsUnknown
	__ret := C.nvmlSystemEventSetCreate(cRequest)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemEventSetFree function as declared in nvml/nvml.h
func nvmlSystemEventSetFree(Request *SystemEventSetFreeRequest) Return {
	cRequest, _ := (*C.nvmlSystemEventSetFreeRequest_t)(unsafe.Pointer(Request)), cgoAllocsUnknown
	__ret := C.nvmlSystemEventSetFree(cRequest)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemRegisterEvents function as declared in nvml/nvml.h
func nvmlSystemRegisterEvents(Request *SystemRegisterEventRequest) Return {
	cRequest, _ := (*C.nvmlSystemRegisterEventRequest_t)(unsafe.Pointer(Request)), cgoAllocsUnknown
	__ret := C.nvmlSystemRegisterEvents(cRequest)
	__v := (Return)(__ret)
	return __v
}

// nvmlSystemEventSetWait function as declared in nvml/nvml.h
func nvmlSystemEventSetWait(Request *SystemEventSetWaitRequest) Return {
	cRequest, _ := (*C.nvmlSystemEventSetWaitRequest_t)(unsafe.Pointer(Request)), cgoAllocsUnknown
	__ret := C.nvmlSystemEventSetWait(cRequest)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceModifyDrainState function as declared in nvml/nvml.h
func nvmlDeviceModifyDrainState(PciInfo *PciInfo, NewState EnableState) Return {
	cPciInfo, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(PciInfo)), cgoAllocsUnknown
	cNewState, _ := (C.nvmlEnableState_t)(NewState), cgoAllocsUnknown
	__ret := C.nvmlDeviceModifyDrainState(cPciInfo, cNewState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceQueryDrainState function as declared in nvml/nvml.h
func nvmlDeviceQueryDrainState(PciInfo *PciInfo, CurrentState *EnableState) Return {
	cPciInfo, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(PciInfo)), cgoAllocsUnknown
	cCurrentState, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(CurrentState)), cgoAllocsUnknown
	__ret := C.nvmlDeviceQueryDrainState(cPciInfo, cCurrentState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceRemoveGpu_v2 function as declared in nvml/nvml.h
func nvmlDeviceRemoveGpu_v2(PciInfo *PciInfo, GpuState DetachGpuState, LinkState PcieLinkState) Return {
	cPciInfo, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(PciInfo)), cgoAllocsUnknown
	cGpuState, _ := (C.nvmlDetachGpuState_t)(GpuState), cgoAllocsUnknown
	cLinkState, _ := (C.nvmlPcieLinkState_t)(LinkState), cgoAllocsUnknown
	__ret := C.nvmlDeviceRemoveGpu_v2(cPciInfo, cGpuState, cLinkState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceDiscoverGpus function as declared in nvml/nvml.h
func nvmlDeviceDiscoverGpus(PciInfo *PciInfo) Return {
	cPciInfo, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(PciInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceDiscoverGpus(cPciInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetFieldValues function as declared in nvml/nvml.h
func nvmlDeviceGetFieldValues(nvmlDevice nvmlDevice, ValuesCount int32, Values *FieldValue) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cValuesCount, _ := (C.int)(ValuesCount), cgoAllocsUnknown
	cValues, _ := (*C.nvmlFieldValue_t)(unsafe.Pointer(Values)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetFieldValues(cnvmlDevice, cValuesCount, cValues)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceClearFieldValues function as declared in nvml/nvml.h
func nvmlDeviceClearFieldValues(nvmlDevice nvmlDevice, ValuesCount int32, Values *FieldValue) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cValuesCount, _ := (C.int)(ValuesCount), cgoAllocsUnknown
	cValues, _ := (*C.nvmlFieldValue_t)(unsafe.Pointer(Values)), cgoAllocsUnknown
	__ret := C.nvmlDeviceClearFieldValues(cnvmlDevice, cValuesCount, cValues)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVirtualizationMode function as declared in nvml/nvml.h
func nvmlDeviceGetVirtualizationMode(nvmlDevice nvmlDevice, PVirtualMode *GpuVirtualizationMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPVirtualMode, _ := (*C.nvmlGpuVirtualizationMode_t)(unsafe.Pointer(PVirtualMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVirtualizationMode(cnvmlDevice, cPVirtualMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHostVgpuMode function as declared in nvml/nvml.h
func nvmlDeviceGetHostVgpuMode(nvmlDevice nvmlDevice, PHostVgpuMode *HostVgpuMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPHostVgpuMode, _ := (*C.nvmlHostVgpuMode_t)(unsafe.Pointer(PHostVgpuMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHostVgpuMode(cnvmlDevice, cPHostVgpuMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetVirtualizationMode function as declared in nvml/nvml.h
func nvmlDeviceSetVirtualizationMode(nvmlDevice nvmlDevice, VirtualMode GpuVirtualizationMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVirtualMode, _ := (C.nvmlGpuVirtualizationMode_t)(VirtualMode), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetVirtualizationMode(cnvmlDevice, cVirtualMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuHeterogeneousMode function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuHeterogeneousMode(nvmlDevice nvmlDevice, PHeterogeneousMode *VgpuHeterogeneousMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPHeterogeneousMode, _ := (*C.nvmlVgpuHeterogeneousMode_t)(unsafe.Pointer(PHeterogeneousMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuHeterogeneousMode(cnvmlDevice, cPHeterogeneousMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetVgpuHeterogeneousMode function as declared in nvml/nvml.h
func nvmlDeviceSetVgpuHeterogeneousMode(nvmlDevice nvmlDevice, PHeterogeneousMode *VgpuHeterogeneousMode) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPHeterogeneousMode, _ := (*C.nvmlVgpuHeterogeneousMode_t)(unsafe.Pointer(PHeterogeneousMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetVgpuHeterogeneousMode(cnvmlDevice, cPHeterogeneousMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetPlacementId function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetPlacementId(nvmlVgpuInstance nvmlVgpuInstance, PPlacement *VgpuPlacementId) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cPPlacement, _ := (*C.nvmlVgpuPlacementId_t)(unsafe.Pointer(PPlacement)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetPlacementId(cnvmlVgpuInstance, cPPlacement)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuTypeSupportedPlacements function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuTypeSupportedPlacements(nvmlDevice nvmlDevice, nvmlVgpuTypeId nvmlVgpuTypeId, PPlacementList *VgpuPlacementList) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cPPlacementList, _ := (*C.nvmlVgpuPlacementList_t)(unsafe.Pointer(PPlacementList)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuTypeSupportedPlacements(cnvmlDevice, cnvmlVgpuTypeId, cPPlacementList)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuTypeCreatablePlacements function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuTypeCreatablePlacements(nvmlDevice nvmlDevice, nvmlVgpuTypeId nvmlVgpuTypeId, PPlacementList *VgpuPlacementList) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cPPlacementList, _ := (*C.nvmlVgpuPlacementList_t)(unsafe.Pointer(PPlacementList)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuTypeCreatablePlacements(cnvmlDevice, cnvmlVgpuTypeId, cPPlacementList)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetGspHeapSize function as declared in nvml/nvml.h
func nvmlVgpuTypeGetGspHeapSize(nvmlVgpuTypeId nvmlVgpuTypeId, GspHeapSize *uint64) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cGspHeapSize, _ := (*C.ulonglong)(unsafe.Pointer(GspHeapSize)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetGspHeapSize(cnvmlVgpuTypeId, cGspHeapSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetFbReservation function as declared in nvml/nvml.h
func nvmlVgpuTypeGetFbReservation(nvmlVgpuTypeId nvmlVgpuTypeId, FbReservation *uint64) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cFbReservation, _ := (*C.ulonglong)(unsafe.Pointer(FbReservation)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetFbReservation(cnvmlVgpuTypeId, cFbReservation)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetRuntimeStateSize function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetRuntimeStateSize(nvmlVgpuInstance nvmlVgpuInstance, PState *VgpuRuntimeState) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cPState, _ := (*C.nvmlVgpuRuntimeState_t)(unsafe.Pointer(PState)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetRuntimeStateSize(cnvmlVgpuInstance, cPState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetVgpuCapabilities function as declared in nvml/nvml.h
func nvmlDeviceSetVgpuCapabilities(nvmlDevice nvmlDevice, Capability DeviceVgpuCapability, State EnableState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCapability, _ := (C.nvmlDeviceVgpuCapability_t)(Capability), cgoAllocsUnknown
	cState, _ := (C.nvmlEnableState_t)(State), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetVgpuCapabilities(cnvmlDevice, cCapability, cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGridLicensableFeatures_v4 function as declared in nvml/nvml.h
func nvmlDeviceGetGridLicensableFeatures_v4(nvmlDevice nvmlDevice, PGridLicensableFeatures *GridLicensableFeatures) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPGridLicensableFeatures, _ := (*C.nvmlGridLicensableFeatures_t)(unsafe.Pointer(PGridLicensableFeatures)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGridLicensableFeatures_v4(cnvmlDevice, cPGridLicensableFeatures)
	__v := (Return)(__ret)
	return __v
}

// nvmlGetVgpuDriverCapabilities function as declared in nvml/nvml.h
func nvmlGetVgpuDriverCapabilities(Capability VgpuDriverCapability, CapResult *uint32) Return {
	cCapability, _ := (C.nvmlVgpuDriverCapability_t)(Capability), cgoAllocsUnknown
	cCapResult, _ := (*C.uint)(unsafe.Pointer(CapResult)), cgoAllocsUnknown
	__ret := C.nvmlGetVgpuDriverCapabilities(cCapability, cCapResult)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuCapabilities function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuCapabilities(nvmlDevice nvmlDevice, Capability DeviceVgpuCapability, CapResult *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCapability, _ := (C.nvmlDeviceVgpuCapability_t)(Capability), cgoAllocsUnknown
	cCapResult, _ := (*C.uint)(unsafe.Pointer(CapResult)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuCapabilities(cnvmlDevice, cCapability, cCapResult)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetSupportedVgpus function as declared in nvml/nvml.h
func nvmlDeviceGetSupportedVgpus(nvmlDevice nvmlDevice, VgpuCount *uint32, VgpuTypeIds *nvmlVgpuTypeId) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVgpuCount, _ := (*C.uint)(unsafe.Pointer(VgpuCount)), cgoAllocsUnknown
	cVgpuTypeIds, _ := (*C.nvmlVgpuTypeId_t)(unsafe.Pointer(VgpuTypeIds)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetSupportedVgpus(cnvmlDevice, cVgpuCount, cVgpuTypeIds)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCreatableVgpus function as declared in nvml/nvml.h
func nvmlDeviceGetCreatableVgpus(nvmlDevice nvmlDevice, VgpuCount *uint32, VgpuTypeIds *nvmlVgpuTypeId) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVgpuCount, _ := (*C.uint)(unsafe.Pointer(VgpuCount)), cgoAllocsUnknown
	cVgpuTypeIds, _ := (*C.nvmlVgpuTypeId_t)(unsafe.Pointer(VgpuTypeIds)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCreatableVgpus(cnvmlDevice, cVgpuCount, cVgpuTypeIds)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetClass function as declared in nvml/nvml.h
func nvmlVgpuTypeGetClass(nvmlVgpuTypeId nvmlVgpuTypeId, VgpuTypeClass *byte, Size *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cVgpuTypeClass, _ := (*C.char)(unsafe.Pointer(VgpuTypeClass)), cgoAllocsUnknown
	cSize, _ := (*C.uint)(unsafe.Pointer(Size)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetClass(cnvmlVgpuTypeId, cVgpuTypeClass, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetName function as declared in nvml/nvml.h
func nvmlVgpuTypeGetName(nvmlVgpuTypeId nvmlVgpuTypeId, VgpuTypeName *byte, Size *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cVgpuTypeName, _ := (*C.char)(unsafe.Pointer(VgpuTypeName)), cgoAllocsUnknown
	cSize, _ := (*C.uint)(unsafe.Pointer(Size)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetName(cnvmlVgpuTypeId, cVgpuTypeName, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetGpuInstanceProfileId function as declared in nvml/nvml.h
func nvmlVgpuTypeGetGpuInstanceProfileId(nvmlVgpuTypeId nvmlVgpuTypeId, GpuInstanceProfileId *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cGpuInstanceProfileId, _ := (*C.uint)(unsafe.Pointer(GpuInstanceProfileId)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetGpuInstanceProfileId(cnvmlVgpuTypeId, cGpuInstanceProfileId)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetDeviceID function as declared in nvml/nvml.h
func nvmlVgpuTypeGetDeviceID(nvmlVgpuTypeId nvmlVgpuTypeId, DeviceID *uint64, SubsystemID *uint64) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cDeviceID, _ := (*C.ulonglong)(unsafe.Pointer(DeviceID)), cgoAllocsUnknown
	cSubsystemID, _ := (*C.ulonglong)(unsafe.Pointer(SubsystemID)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetDeviceID(cnvmlVgpuTypeId, cDeviceID, cSubsystemID)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetFramebufferSize function as declared in nvml/nvml.h
func nvmlVgpuTypeGetFramebufferSize(nvmlVgpuTypeId nvmlVgpuTypeId, FbSize *uint64) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cFbSize, _ := (*C.ulonglong)(unsafe.Pointer(FbSize)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetFramebufferSize(cnvmlVgpuTypeId, cFbSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetNumDisplayHeads function as declared in nvml/nvml.h
func nvmlVgpuTypeGetNumDisplayHeads(nvmlVgpuTypeId nvmlVgpuTypeId, NumDisplayHeads *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cNumDisplayHeads, _ := (*C.uint)(unsafe.Pointer(NumDisplayHeads)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetNumDisplayHeads(cnvmlVgpuTypeId, cNumDisplayHeads)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetResolution function as declared in nvml/nvml.h
func nvmlVgpuTypeGetResolution(nvmlVgpuTypeId nvmlVgpuTypeId, DisplayIndex uint32, Xdim *uint32, Ydim *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cDisplayIndex, _ := (C.uint)(DisplayIndex), cgoAllocsUnknown
	cXdim, _ := (*C.uint)(unsafe.Pointer(Xdim)), cgoAllocsUnknown
	cYdim, _ := (*C.uint)(unsafe.Pointer(Ydim)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetResolution(cnvmlVgpuTypeId, cDisplayIndex, cXdim, cYdim)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetLicense function as declared in nvml/nvml.h
func nvmlVgpuTypeGetLicense(nvmlVgpuTypeId nvmlVgpuTypeId, VgpuTypeLicenseString *byte, Size uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cVgpuTypeLicenseString, _ := (*C.char)(unsafe.Pointer(VgpuTypeLicenseString)), cgoAllocsUnknown
	cSize, _ := (C.uint)(Size), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetLicense(cnvmlVgpuTypeId, cVgpuTypeLicenseString, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetFrameRateLimit function as declared in nvml/nvml.h
func nvmlVgpuTypeGetFrameRateLimit(nvmlVgpuTypeId nvmlVgpuTypeId, FrameRateLimit *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cFrameRateLimit, _ := (*C.uint)(unsafe.Pointer(FrameRateLimit)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetFrameRateLimit(cnvmlVgpuTypeId, cFrameRateLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetMaxInstances function as declared in nvml/nvml.h
func nvmlVgpuTypeGetMaxInstances(nvmlDevice nvmlDevice, nvmlVgpuTypeId nvmlVgpuTypeId, VgpuInstanceCount *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cVgpuInstanceCount, _ := (*C.uint)(unsafe.Pointer(VgpuInstanceCount)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetMaxInstances(cnvmlDevice, cnvmlVgpuTypeId, cVgpuInstanceCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetMaxInstancesPerVm function as declared in nvml/nvml.h
func nvmlVgpuTypeGetMaxInstancesPerVm(nvmlVgpuTypeId nvmlVgpuTypeId, VgpuInstanceCountPerVm *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cVgpuInstanceCountPerVm, _ := (*C.uint)(unsafe.Pointer(VgpuInstanceCountPerVm)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetMaxInstancesPerVm(cnvmlVgpuTypeId, cVgpuInstanceCountPerVm)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetBAR1Info function as declared in nvml/nvml.h
func nvmlVgpuTypeGetBAR1Info(nvmlVgpuTypeId nvmlVgpuTypeId, Bar1Info *VgpuTypeBar1Info) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cBar1Info, _ := (*C.nvmlVgpuTypeBar1Info_t)(unsafe.Pointer(Bar1Info)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetBAR1Info(cnvmlVgpuTypeId, cBar1Info)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetActiveVgpus function as declared in nvml/nvml.h
func nvmlDeviceGetActiveVgpus(nvmlDevice nvmlDevice, VgpuCount *uint32, VgpuInstances *nvmlVgpuInstance) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVgpuCount, _ := (*C.uint)(unsafe.Pointer(VgpuCount)), cgoAllocsUnknown
	cVgpuInstances, _ := (*C.nvmlVgpuInstance_t)(unsafe.Pointer(VgpuInstances)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetActiveVgpus(cnvmlDevice, cVgpuCount, cVgpuInstances)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetVmID function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetVmID(nvmlVgpuInstance nvmlVgpuInstance, VmId *byte, Size uint32, VmIdType *VgpuVmIdType) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cVmId, _ := (*C.char)(unsafe.Pointer(VmId)), cgoAllocsUnknown
	cSize, _ := (C.uint)(Size), cgoAllocsUnknown
	cVmIdType, _ := (*C.nvmlVgpuVmIdType_t)(unsafe.Pointer(VmIdType)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetVmID(cnvmlVgpuInstance, cVmId, cSize, cVmIdType)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetUUID function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetUUID(nvmlVgpuInstance nvmlVgpuInstance, Uuid *byte, Size uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cUuid, _ := (*C.char)(unsafe.Pointer(Uuid)), cgoAllocsUnknown
	cSize, _ := (C.uint)(Size), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetUUID(cnvmlVgpuInstance, cUuid, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetVmDriverVersion function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetVmDriverVersion(nvmlVgpuInstance nvmlVgpuInstance, Version *byte, Length uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cVersion, _ := (*C.char)(unsafe.Pointer(Version)), cgoAllocsUnknown
	cLength, _ := (C.uint)(Length), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetVmDriverVersion(cnvmlVgpuInstance, cVersion, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetFbUsage function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetFbUsage(nvmlVgpuInstance nvmlVgpuInstance, FbUsage *uint64) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cFbUsage, _ := (*C.ulonglong)(unsafe.Pointer(FbUsage)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetFbUsage(cnvmlVgpuInstance, cFbUsage)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetLicenseStatus function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetLicenseStatus(nvmlVgpuInstance nvmlVgpuInstance, Licensed *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cLicensed, _ := (*C.uint)(unsafe.Pointer(Licensed)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetLicenseStatus(cnvmlVgpuInstance, cLicensed)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetType function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetType(nvmlVgpuInstance nvmlVgpuInstance, nvmlVgpuTypeId *nvmlVgpuTypeId) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cnvmlVgpuTypeId, _ := (*C.nvmlVgpuTypeId_t)(unsafe.Pointer(nvmlVgpuTypeId)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetType(cnvmlVgpuInstance, cnvmlVgpuTypeId)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetFrameRateLimit function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetFrameRateLimit(nvmlVgpuInstance nvmlVgpuInstance, FrameRateLimit *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cFrameRateLimit, _ := (*C.uint)(unsafe.Pointer(FrameRateLimit)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetFrameRateLimit(cnvmlVgpuInstance, cFrameRateLimit)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetEccMode function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetEccMode(nvmlVgpuInstance nvmlVgpuInstance, EccMode *EnableState) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cEccMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(EccMode)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetEccMode(cnvmlVgpuInstance, cEccMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetEncoderCapacity function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetEncoderCapacity(nvmlVgpuInstance nvmlVgpuInstance, EncoderCapacity *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cEncoderCapacity, _ := (*C.uint)(unsafe.Pointer(EncoderCapacity)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetEncoderCapacity(cnvmlVgpuInstance, cEncoderCapacity)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceSetEncoderCapacity function as declared in nvml/nvml.h
func nvmlVgpuInstanceSetEncoderCapacity(nvmlVgpuInstance nvmlVgpuInstance, EncoderCapacity uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cEncoderCapacity, _ := (C.uint)(EncoderCapacity), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceSetEncoderCapacity(cnvmlVgpuInstance, cEncoderCapacity)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetEncoderStats function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetEncoderStats(nvmlVgpuInstance nvmlVgpuInstance, SessionCount *uint32, AverageFps *uint32, AverageLatency *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cAverageFps, _ := (*C.uint)(unsafe.Pointer(AverageFps)), cgoAllocsUnknown
	cAverageLatency, _ := (*C.uint)(unsafe.Pointer(AverageLatency)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetEncoderStats(cnvmlVgpuInstance, cSessionCount, cAverageFps, cAverageLatency)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetEncoderSessions function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetEncoderSessions(nvmlVgpuInstance nvmlVgpuInstance, SessionCount *uint32, SessionInfo *EncoderSessionInfo) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cSessionInfo, _ := (*C.nvmlEncoderSessionInfo_t)(unsafe.Pointer(SessionInfo)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetEncoderSessions(cnvmlVgpuInstance, cSessionCount, cSessionInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetFBCStats function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetFBCStats(nvmlVgpuInstance nvmlVgpuInstance, FbcStats *FBCStats) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cFbcStats, _ := (*C.nvmlFBCStats_t)(unsafe.Pointer(FbcStats)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetFBCStats(cnvmlVgpuInstance, cFbcStats)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetFBCSessions function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetFBCSessions(nvmlVgpuInstance nvmlVgpuInstance, SessionCount *uint32, SessionInfo *FBCSessionInfo) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cSessionCount, _ := (*C.uint)(unsafe.Pointer(SessionCount)), cgoAllocsUnknown
	cSessionInfo, _ := (*C.nvmlFBCSessionInfo_t)(unsafe.Pointer(SessionInfo)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetFBCSessions(cnvmlVgpuInstance, cSessionCount, cSessionInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetGpuInstanceId function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetGpuInstanceId(nvmlVgpuInstance nvmlVgpuInstance, GpuInstanceId *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cGpuInstanceId, _ := (*C.uint)(unsafe.Pointer(GpuInstanceId)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetGpuInstanceId(cnvmlVgpuInstance, cGpuInstanceId)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetGpuPciId function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetGpuPciId(nvmlVgpuInstance nvmlVgpuInstance, VgpuPciId *byte, Length *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cVgpuPciId, _ := (*C.char)(unsafe.Pointer(VgpuPciId)), cgoAllocsUnknown
	cLength, _ := (*C.uint)(unsafe.Pointer(Length)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetGpuPciId(cnvmlVgpuInstance, cVgpuPciId, cLength)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetCapabilities function as declared in nvml/nvml.h
func nvmlVgpuTypeGetCapabilities(nvmlVgpuTypeId nvmlVgpuTypeId, Capability VgpuCapability, CapResult *uint32) Return {
	cnvmlVgpuTypeId, _ := (C.nvmlVgpuTypeId_t)(nvmlVgpuTypeId), cgoAllocsUnknown
	cCapability, _ := (C.nvmlVgpuCapability_t)(Capability), cgoAllocsUnknown
	cCapResult, _ := (*C.uint)(unsafe.Pointer(CapResult)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetCapabilities(cnvmlVgpuTypeId, cCapability, cCapResult)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetMdevUUID function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetMdevUUID(nvmlVgpuInstance nvmlVgpuInstance, MdevUuid *byte, Size uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cMdevUuid, _ := (*C.char)(unsafe.Pointer(MdevUuid)), cgoAllocsUnknown
	cSize, _ := (C.uint)(Size), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetMdevUUID(cnvmlVgpuInstance, cMdevUuid, cSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetCreatableVgpus function as declared in nvml/nvml.h
func nvmlGpuInstanceGetCreatableVgpus(nvmlGpuInstance nvmlGpuInstance, PVgpus *VgpuTypeIdInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPVgpus, _ := (*C.nvmlVgpuTypeIdInfo_t)(unsafe.Pointer(PVgpus)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetCreatableVgpus(cnvmlGpuInstance, cPVgpus)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuTypeGetMaxInstancesPerGpuInstance function as declared in nvml/nvml.h
func nvmlVgpuTypeGetMaxInstancesPerGpuInstance(PMaxInstance *VgpuTypeMaxInstance) Return {
	cPMaxInstance, _ := (*C.nvmlVgpuTypeMaxInstance_t)(unsafe.Pointer(PMaxInstance)), cgoAllocsUnknown
	__ret := C.nvmlVgpuTypeGetMaxInstancesPerGpuInstance(cPMaxInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetActiveVgpus function as declared in nvml/nvml.h
func nvmlGpuInstanceGetActiveVgpus(nvmlGpuInstance nvmlGpuInstance, PVgpuInstanceInfo *ActiveVgpuInstanceInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPVgpuInstanceInfo, _ := (*C.nvmlActiveVgpuInstanceInfo_t)(unsafe.Pointer(PVgpuInstanceInfo)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetActiveVgpus(cnvmlGpuInstance, cPVgpuInstanceInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceSetVgpuSchedulerState function as declared in nvml/nvml.h
func nvmlGpuInstanceSetVgpuSchedulerState(nvmlGpuInstance nvmlGpuInstance, PScheduler *VgpuSchedulerState) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPScheduler, _ := (*C.nvmlVgpuSchedulerState_t)(unsafe.Pointer(PScheduler)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceSetVgpuSchedulerState(cnvmlGpuInstance, cPScheduler)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetVgpuSchedulerState function as declared in nvml/nvml.h
func nvmlGpuInstanceGetVgpuSchedulerState(nvmlGpuInstance nvmlGpuInstance, PSchedulerStateInfo *VgpuSchedulerStateInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPSchedulerStateInfo, _ := (*C.nvmlVgpuSchedulerStateInfo_t)(unsafe.Pointer(PSchedulerStateInfo)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetVgpuSchedulerState(cnvmlGpuInstance, cPSchedulerStateInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetVgpuSchedulerLog function as declared in nvml/nvml.h
func nvmlGpuInstanceGetVgpuSchedulerLog(nvmlGpuInstance nvmlGpuInstance, PSchedulerLogInfo *VgpuSchedulerLogInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPSchedulerLogInfo, _ := (*C.nvmlVgpuSchedulerLogInfo_t)(unsafe.Pointer(PSchedulerLogInfo)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetVgpuSchedulerLog(cnvmlGpuInstance, cPSchedulerLogInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetVgpuTypeCreatablePlacements function as declared in nvml/nvml.h
func nvmlGpuInstanceGetVgpuTypeCreatablePlacements(nvmlGpuInstance nvmlGpuInstance, PCreatablePlacementInfo *VgpuCreatablePlacementInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPCreatablePlacementInfo, _ := (*C.nvmlVgpuCreatablePlacementInfo_t)(unsafe.Pointer(PCreatablePlacementInfo)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetVgpuTypeCreatablePlacements(cnvmlGpuInstance, cPCreatablePlacementInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetVgpuHeterogeneousMode function as declared in nvml/nvml.h
func nvmlGpuInstanceGetVgpuHeterogeneousMode(nvmlGpuInstance nvmlGpuInstance, PHeterogeneousMode *VgpuHeterogeneousMode) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPHeterogeneousMode, _ := (*C.nvmlVgpuHeterogeneousMode_t)(unsafe.Pointer(PHeterogeneousMode)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetVgpuHeterogeneousMode(cnvmlGpuInstance, cPHeterogeneousMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceSetVgpuHeterogeneousMode function as declared in nvml/nvml.h
func nvmlGpuInstanceSetVgpuHeterogeneousMode(nvmlGpuInstance nvmlGpuInstance, PHeterogeneousMode *VgpuHeterogeneousMode) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cPHeterogeneousMode, _ := (*C.nvmlVgpuHeterogeneousMode_t)(unsafe.Pointer(PHeterogeneousMode)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceSetVgpuHeterogeneousMode(cnvmlGpuInstance, cPHeterogeneousMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetMetadata function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetMetadata(nvmlVgpuInstance nvmlVgpuInstance, nvmlVgpuMetadata *nvmlVgpuMetadata, BufferSize *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cnvmlVgpuMetadata, _ := (*C.nvmlVgpuMetadata_t)(unsafe.Pointer(nvmlVgpuMetadata)), cgoAllocsUnknown
	cBufferSize, _ := (*C.uint)(unsafe.Pointer(BufferSize)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetMetadata(cnvmlVgpuInstance, cnvmlVgpuMetadata, cBufferSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuMetadata function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuMetadata(nvmlDevice nvmlDevice, PgpuMetadata *nvmlVgpuPgpuMetadata, BufferSize *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPgpuMetadata, _ := (*C.nvmlVgpuPgpuMetadata_t)(unsafe.Pointer(PgpuMetadata)), cgoAllocsUnknown
	cBufferSize, _ := (*C.uint)(unsafe.Pointer(BufferSize)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuMetadata(cnvmlDevice, cPgpuMetadata, cBufferSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlGetVgpuCompatibility function as declared in nvml/nvml.h
func nvmlGetVgpuCompatibility(nvmlVgpuMetadata *nvmlVgpuMetadata, PgpuMetadata *nvmlVgpuPgpuMetadata, CompatibilityInfo *VgpuPgpuCompatibility) Return {
	cnvmlVgpuMetadata, _ := (*C.nvmlVgpuMetadata_t)(unsafe.Pointer(nvmlVgpuMetadata)), cgoAllocsUnknown
	cPgpuMetadata, _ := (*C.nvmlVgpuPgpuMetadata_t)(unsafe.Pointer(PgpuMetadata)), cgoAllocsUnknown
	cCompatibilityInfo, _ := (*C.nvmlVgpuPgpuCompatibility_t)(unsafe.Pointer(CompatibilityInfo)), cgoAllocsUnknown
	__ret := C.nvmlGetVgpuCompatibility(cnvmlVgpuMetadata, cPgpuMetadata, cCompatibilityInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPgpuMetadataString function as declared in nvml/nvml.h
func nvmlDeviceGetPgpuMetadataString(nvmlDevice nvmlDevice, PgpuMetadata *byte, BufferSize *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPgpuMetadata, _ := (*C.char)(unsafe.Pointer(PgpuMetadata)), cgoAllocsUnknown
	cBufferSize, _ := (*C.uint)(unsafe.Pointer(BufferSize)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPgpuMetadataString(cnvmlDevice, cPgpuMetadata, cBufferSize)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuSchedulerLog function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuSchedulerLog(nvmlDevice nvmlDevice, PSchedulerLog *VgpuSchedulerLog) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPSchedulerLog, _ := (*C.nvmlVgpuSchedulerLog_t)(unsafe.Pointer(PSchedulerLog)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuSchedulerLog(cnvmlDevice, cPSchedulerLog)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuSchedulerState function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuSchedulerState(nvmlDevice nvmlDevice, PSchedulerState *VgpuSchedulerGetState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPSchedulerState, _ := (*C.nvmlVgpuSchedulerGetState_t)(unsafe.Pointer(PSchedulerState)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuSchedulerState(cnvmlDevice, cPSchedulerState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuSchedulerCapabilities function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuSchedulerCapabilities(nvmlDevice nvmlDevice, PCapabilities *VgpuSchedulerCapabilities) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPCapabilities, _ := (*C.nvmlVgpuSchedulerCapabilities_t)(unsafe.Pointer(PCapabilities)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuSchedulerCapabilities(cnvmlDevice, cPCapabilities)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetVgpuSchedulerState function as declared in nvml/nvml.h
func nvmlDeviceSetVgpuSchedulerState(nvmlDevice nvmlDevice, PSchedulerState *VgpuSchedulerSetState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPSchedulerState, _ := (*C.nvmlVgpuSchedulerSetState_t)(unsafe.Pointer(PSchedulerState)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetVgpuSchedulerState(cnvmlDevice, cPSchedulerState)
	__v := (Return)(__ret)
	return __v
}

// nvmlGetVgpuVersion function as declared in nvml/nvml.h
func nvmlGetVgpuVersion(Supported *VgpuVersion, Current *VgpuVersion) Return {
	cSupported, _ := (*C.nvmlVgpuVersion_t)(unsafe.Pointer(Supported)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlVgpuVersion_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	__ret := C.nvmlGetVgpuVersion(cSupported, cCurrent)
	__v := (Return)(__ret)
	return __v
}

// nvmlSetVgpuVersion function as declared in nvml/nvml.h
func nvmlSetVgpuVersion(VgpuVersion *VgpuVersion) Return {
	cVgpuVersion, _ := (*C.nvmlVgpuVersion_t)(unsafe.Pointer(VgpuVersion)), cgoAllocsUnknown
	__ret := C.nvmlSetVgpuVersion(cVgpuVersion)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuUtilization(nvmlDevice nvmlDevice, LastSeenTimeStamp uint64, SampleValType *ValueType, VgpuInstanceSamplesCount *uint32, UtilizationSamples *VgpuInstanceUtilizationSample) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLastSeenTimeStamp, _ := (C.ulonglong)(LastSeenTimeStamp), cgoAllocsUnknown
	cSampleValType, _ := (*C.nvmlValueType_t)(unsafe.Pointer(SampleValType)), cgoAllocsUnknown
	cVgpuInstanceSamplesCount, _ := (*C.uint)(unsafe.Pointer(VgpuInstanceSamplesCount)), cgoAllocsUnknown
	cUtilizationSamples, _ := (*C.nvmlVgpuInstanceUtilizationSample_t)(unsafe.Pointer(UtilizationSamples)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuUtilization(cnvmlDevice, cLastSeenTimeStamp, cSampleValType, cVgpuInstanceSamplesCount, cUtilizationSamples)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuInstancesUtilizationInfo function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuInstancesUtilizationInfo(nvmlDevice nvmlDevice, VgpuUtilInfo *VgpuInstancesUtilizationInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVgpuUtilInfo, _ := (*C.nvmlVgpuInstancesUtilizationInfo_t)(unsafe.Pointer(VgpuUtilInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuInstancesUtilizationInfo(cnvmlDevice, cVgpuUtilInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuProcessUtilization function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuProcessUtilization(nvmlDevice nvmlDevice, LastSeenTimeStamp uint64, VgpuProcessSamplesCount *uint32, UtilizationSamples *VgpuProcessUtilizationSample) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLastSeenTimeStamp, _ := (C.ulonglong)(LastSeenTimeStamp), cgoAllocsUnknown
	cVgpuProcessSamplesCount, _ := (*C.uint)(unsafe.Pointer(VgpuProcessSamplesCount)), cgoAllocsUnknown
	cUtilizationSamples, _ := (*C.nvmlVgpuProcessUtilizationSample_t)(unsafe.Pointer(UtilizationSamples)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuProcessUtilization(cnvmlDevice, cLastSeenTimeStamp, cVgpuProcessSamplesCount, cUtilizationSamples)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetVgpuProcessesUtilizationInfo function as declared in nvml/nvml.h
func nvmlDeviceGetVgpuProcessesUtilizationInfo(nvmlDevice nvmlDevice, VgpuProcUtilInfo *VgpuProcessesUtilizationInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cVgpuProcUtilInfo, _ := (*C.nvmlVgpuProcessesUtilizationInfo_t)(unsafe.Pointer(VgpuProcUtilInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetVgpuProcessesUtilizationInfo(cnvmlDevice, cVgpuProcUtilInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetAccountingMode function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetAccountingMode(nvmlVgpuInstance nvmlVgpuInstance, Mode *EnableState) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cMode, _ := (*C.nvmlEnableState_t)(unsafe.Pointer(Mode)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetAccountingMode(cnvmlVgpuInstance, cMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetAccountingPids function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetAccountingPids(nvmlVgpuInstance nvmlVgpuInstance, Count *uint32, Pids *uint32) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	cPids, _ := (*C.uint)(unsafe.Pointer(Pids)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetAccountingPids(cnvmlVgpuInstance, cCount, cPids)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetAccountingStats function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetAccountingStats(nvmlVgpuInstance nvmlVgpuInstance, Pid uint32, Stats *AccountingStats) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cPid, _ := (C.uint)(Pid), cgoAllocsUnknown
	cStats, _ := (*C.nvmlAccountingStats_t)(unsafe.Pointer(Stats)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetAccountingStats(cnvmlVgpuInstance, cPid, cStats)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceClearAccountingPids function as declared in nvml/nvml.h
func nvmlVgpuInstanceClearAccountingPids(nvmlVgpuInstance nvmlVgpuInstance) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceClearAccountingPids(cnvmlVgpuInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetLicenseInfo_v2 function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetLicenseInfo_v2(nvmlVgpuInstance nvmlVgpuInstance, LicenseInfo *VgpuLicenseInfo) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cLicenseInfo, _ := (*C.nvmlVgpuLicenseInfo_t)(unsafe.Pointer(LicenseInfo)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetLicenseInfo_v2(cnvmlVgpuInstance, cLicenseInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGetExcludedDeviceCount function as declared in nvml/nvml.h
func nvmlGetExcludedDeviceCount(DeviceCount *uint32) Return {
	cDeviceCount, _ := (*C.uint)(unsafe.Pointer(DeviceCount)), cgoAllocsUnknown
	__ret := C.nvmlGetExcludedDeviceCount(cDeviceCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlGetExcludedDeviceInfoByIndex function as declared in nvml/nvml.h
func nvmlGetExcludedDeviceInfoByIndex(Index uint32, Info *ExcludedDeviceInfo) Return {
	cIndex, _ := (C.uint)(Index), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlExcludedDeviceInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlGetExcludedDeviceInfoByIndex(cIndex, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceSetMigMode function as declared in nvml/nvml.h
func nvmlDeviceSetMigMode(nvmlDevice nvmlDevice, Mode uint32, ActivationStatus *Return) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cMode, _ := (C.uint)(Mode), cgoAllocsUnknown
	cActivationStatus, _ := (*C.nvmlReturn_t)(unsafe.Pointer(ActivationStatus)), cgoAllocsUnknown
	__ret := C.nvmlDeviceSetMigMode(cnvmlDevice, cMode, cActivationStatus)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMigMode function as declared in nvml/nvml.h
func nvmlDeviceGetMigMode(nvmlDevice nvmlDevice, CurrentMode *uint32, PendingMode *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrentMode, _ := (*C.uint)(unsafe.Pointer(CurrentMode)), cgoAllocsUnknown
	cPendingMode, _ := (*C.uint)(unsafe.Pointer(PendingMode)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMigMode(cnvmlDevice, cCurrentMode, cPendingMode)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstanceProfileInfo function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstanceProfileInfo(nvmlDevice nvmlDevice, Profile uint32, Info *GpuInstanceProfileInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfile, _ := (C.uint)(Profile), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlGpuInstanceProfileInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstanceProfileInfo(cnvmlDevice, cProfile, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstanceProfileInfoV function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstanceProfileInfoV(nvmlDevice nvmlDevice, Profile uint32, Info *GpuInstanceProfileInfo_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfile, _ := (C.uint)(Profile), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlGpuInstanceProfileInfo_v2_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstanceProfileInfoV(cnvmlDevice, cProfile, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstancePossiblePlacements_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstancePossiblePlacements_v2(nvmlDevice nvmlDevice, ProfileId uint32, Placements *GpuInstancePlacement, Count *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cPlacements, _ := (*C.nvmlGpuInstancePlacement_t)(unsafe.Pointer(Placements)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstancePossiblePlacements_v2(cnvmlDevice, cProfileId, cPlacements, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstanceRemainingCapacity function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstanceRemainingCapacity(nvmlDevice nvmlDevice, ProfileId uint32, Count *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstanceRemainingCapacity(cnvmlDevice, cProfileId, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceCreateGpuInstance function as declared in nvml/nvml.h
func nvmlDeviceCreateGpuInstance(nvmlDevice nvmlDevice, ProfileId uint32, nvmlGpuInstance *nvmlGpuInstance) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cnvmlGpuInstance, _ := (*C.nvmlGpuInstance_t)(unsafe.Pointer(nvmlGpuInstance)), cgoAllocsUnknown
	__ret := C.nvmlDeviceCreateGpuInstance(cnvmlDevice, cProfileId, cnvmlGpuInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceCreateGpuInstanceWithPlacement function as declared in nvml/nvml.h
func nvmlDeviceCreateGpuInstanceWithPlacement(nvmlDevice nvmlDevice, ProfileId uint32, Placement *GpuInstancePlacement, nvmlGpuInstance *nvmlGpuInstance) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cPlacement, _ := (*C.nvmlGpuInstancePlacement_t)(unsafe.Pointer(Placement)), cgoAllocsUnknown
	cnvmlGpuInstance, _ := (*C.nvmlGpuInstance_t)(unsafe.Pointer(nvmlGpuInstance)), cgoAllocsUnknown
	__ret := C.nvmlDeviceCreateGpuInstanceWithPlacement(cnvmlDevice, cProfileId, cPlacement, cnvmlGpuInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceDestroy function as declared in nvml/nvml.h
func nvmlGpuInstanceDestroy(nvmlGpuInstance nvmlGpuInstance) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceDestroy(cnvmlGpuInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstances function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstances(nvmlDevice nvmlDevice, ProfileId uint32, GpuInstances *nvmlGpuInstance, Count *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cGpuInstances, _ := (*C.nvmlGpuInstance_t)(unsafe.Pointer(GpuInstances)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstances(cnvmlDevice, cProfileId, cGpuInstances, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstanceById function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstanceById(nvmlDevice nvmlDevice, Id uint32, nvmlGpuInstance *nvmlGpuInstance) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cId, _ := (C.uint)(Id), cgoAllocsUnknown
	cnvmlGpuInstance, _ := (*C.nvmlGpuInstance_t)(unsafe.Pointer(nvmlGpuInstance)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstanceById(cnvmlDevice, cId, cnvmlGpuInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetInfo function as declared in nvml/nvml.h
func nvmlGpuInstanceGetInfo(nvmlGpuInstance nvmlGpuInstance, Info *nvmlGpuInstanceInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlGpuInstanceInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetInfo(cnvmlGpuInstance, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstanceProfileInfo function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstanceProfileInfo(nvmlGpuInstance nvmlGpuInstance, Profile uint32, EngProfile uint32, Info *ComputeInstanceProfileInfo) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfile, _ := (C.uint)(Profile), cgoAllocsUnknown
	cEngProfile, _ := (C.uint)(EngProfile), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlComputeInstanceProfileInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstanceProfileInfo(cnvmlGpuInstance, cProfile, cEngProfile, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstanceProfileInfoV function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstanceProfileInfoV(nvmlGpuInstance nvmlGpuInstance, Profile uint32, EngProfile uint32, Info *ComputeInstanceProfileInfo_v2) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfile, _ := (C.uint)(Profile), cgoAllocsUnknown
	cEngProfile, _ := (C.uint)(EngProfile), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlComputeInstanceProfileInfo_v2_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstanceProfileInfoV(cnvmlGpuInstance, cProfile, cEngProfile, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstanceRemainingCapacity function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstanceRemainingCapacity(nvmlGpuInstance nvmlGpuInstance, ProfileId uint32, Count *uint32) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstanceRemainingCapacity(cnvmlGpuInstance, cProfileId, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstancePossiblePlacements function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstancePossiblePlacements(nvmlGpuInstance nvmlGpuInstance, ProfileId uint32, Placements *ComputeInstancePlacement, Count *uint32) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cPlacements, _ := (*C.nvmlComputeInstancePlacement_t)(unsafe.Pointer(Placements)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstancePossiblePlacements(cnvmlGpuInstance, cProfileId, cPlacements, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceCreateComputeInstance function as declared in nvml/nvml.h
func nvmlGpuInstanceCreateComputeInstance(nvmlGpuInstance nvmlGpuInstance, ProfileId uint32, nvmlComputeInstance *nvmlComputeInstance) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cnvmlComputeInstance, _ := (*C.nvmlComputeInstance_t)(unsafe.Pointer(nvmlComputeInstance)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceCreateComputeInstance(cnvmlGpuInstance, cProfileId, cnvmlComputeInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceCreateComputeInstanceWithPlacement function as declared in nvml/nvml.h
func nvmlGpuInstanceCreateComputeInstanceWithPlacement(nvmlGpuInstance nvmlGpuInstance, ProfileId uint32, Placement *ComputeInstancePlacement, nvmlComputeInstance *nvmlComputeInstance) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cPlacement, _ := (*C.nvmlComputeInstancePlacement_t)(unsafe.Pointer(Placement)), cgoAllocsUnknown
	cnvmlComputeInstance, _ := (*C.nvmlComputeInstance_t)(unsafe.Pointer(nvmlComputeInstance)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceCreateComputeInstanceWithPlacement(cnvmlGpuInstance, cProfileId, cPlacement, cnvmlComputeInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlComputeInstanceDestroy function as declared in nvml/nvml.h
func nvmlComputeInstanceDestroy(nvmlComputeInstance nvmlComputeInstance) Return {
	cnvmlComputeInstance, _ := *(*C.nvmlComputeInstance_t)(unsafe.Pointer(&nvmlComputeInstance)), cgoAllocsUnknown
	__ret := C.nvmlComputeInstanceDestroy(cnvmlComputeInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstances function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstances(nvmlGpuInstance nvmlGpuInstance, ProfileId uint32, ComputeInstances *nvmlComputeInstance, Count *uint32) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cComputeInstances, _ := (*C.nvmlComputeInstance_t)(unsafe.Pointer(ComputeInstances)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstances(cnvmlGpuInstance, cProfileId, cComputeInstances, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpuInstanceGetComputeInstanceById function as declared in nvml/nvml.h
func nvmlGpuInstanceGetComputeInstanceById(nvmlGpuInstance nvmlGpuInstance, Id uint32, nvmlComputeInstance *nvmlComputeInstance) Return {
	cnvmlGpuInstance, _ := *(*C.nvmlGpuInstance_t)(unsafe.Pointer(&nvmlGpuInstance)), cgoAllocsUnknown
	cId, _ := (C.uint)(Id), cgoAllocsUnknown
	cnvmlComputeInstance, _ := (*C.nvmlComputeInstance_t)(unsafe.Pointer(nvmlComputeInstance)), cgoAllocsUnknown
	__ret := C.nvmlGpuInstanceGetComputeInstanceById(cnvmlGpuInstance, cId, cnvmlComputeInstance)
	__v := (Return)(__ret)
	return __v
}

// nvmlComputeInstanceGetInfo_v2 function as declared in nvml/nvml.h
func nvmlComputeInstanceGetInfo_v2(nvmlComputeInstance nvmlComputeInstance, Info *nvmlComputeInstanceInfo) Return {
	cnvmlComputeInstance, _ := *(*C.nvmlComputeInstance_t)(unsafe.Pointer(&nvmlComputeInstance)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlComputeInstanceInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlComputeInstanceGetInfo_v2(cnvmlComputeInstance, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceIsMigDeviceHandle function as declared in nvml/nvml.h
func nvmlDeviceIsMigDeviceHandle(nvmlDevice nvmlDevice, IsMigDevice *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIsMigDevice, _ := (*C.uint)(unsafe.Pointer(IsMigDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceIsMigDeviceHandle(cnvmlDevice, cIsMigDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstanceId function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstanceId(nvmlDevice nvmlDevice, Id *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cId, _ := (*C.uint)(unsafe.Pointer(Id)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstanceId(cnvmlDevice, cId)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetComputeInstanceId function as declared in nvml/nvml.h
func nvmlDeviceGetComputeInstanceId(nvmlDevice nvmlDevice, Id *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cId, _ := (*C.uint)(unsafe.Pointer(Id)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetComputeInstanceId(cnvmlDevice, cId)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMaxMigDeviceCount function as declared in nvml/nvml.h
func nvmlDeviceGetMaxMigDeviceCount(nvmlDevice nvmlDevice, Count *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMaxMigDeviceCount(cnvmlDevice, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMigDeviceHandleByIndex function as declared in nvml/nvml.h
func nvmlDeviceGetMigDeviceHandleByIndex(nvmlDevice nvmlDevice, Index uint32, MigDevice *nvmlDevice) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cIndex, _ := (C.uint)(Index), cgoAllocsUnknown
	cMigDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(MigDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMigDeviceHandleByIndex(cnvmlDevice, cIndex, cMigDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDeviceHandleFromMigDeviceHandle function as declared in nvml/nvml.h
func nvmlDeviceGetDeviceHandleFromMigDeviceHandle(MigDevice nvmlDevice, nvmlDevice *nvmlDevice) Return {
	cMigDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&MigDevice)), cgoAllocsUnknown
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDeviceHandleFromMigDeviceHandle(cMigDevice, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmMetricsGet function as declared in nvml/nvml.h
func nvmlGpmMetricsGet(MetricsGet *nvmlGpmMetricsGetType) Return {
	cMetricsGet, _ := (*C.nvmlGpmMetricsGet_t)(unsafe.Pointer(MetricsGet)), cgoAllocsUnknown
	__ret := C.nvmlGpmMetricsGet(cMetricsGet)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmSampleFree function as declared in nvml/nvml.h
func nvmlGpmSampleFree(nvmlGpmSample nvmlGpmSample) Return {
	cnvmlGpmSample, _ := *(*C.nvmlGpmSample_t)(unsafe.Pointer(&nvmlGpmSample)), cgoAllocsUnknown
	__ret := C.nvmlGpmSampleFree(cnvmlGpmSample)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmSampleAlloc function as declared in nvml/nvml.h
func nvmlGpmSampleAlloc(nvmlGpmSample *nvmlGpmSample) Return {
	cnvmlGpmSample, _ := (*C.nvmlGpmSample_t)(unsafe.Pointer(nvmlGpmSample)), cgoAllocsUnknown
	__ret := C.nvmlGpmSampleAlloc(cnvmlGpmSample)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmSampleGet function as declared in nvml/nvml.h
func nvmlGpmSampleGet(nvmlDevice nvmlDevice, nvmlGpmSample nvmlGpmSample) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cnvmlGpmSample, _ := *(*C.nvmlGpmSample_t)(unsafe.Pointer(&nvmlGpmSample)), cgoAllocsUnknown
	__ret := C.nvmlGpmSampleGet(cnvmlDevice, cnvmlGpmSample)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmMigSampleGet function as declared in nvml/nvml.h
func nvmlGpmMigSampleGet(nvmlDevice nvmlDevice, GpuInstanceId uint32, nvmlGpmSample nvmlGpmSample) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpuInstanceId, _ := (C.uint)(GpuInstanceId), cgoAllocsUnknown
	cnvmlGpmSample, _ := *(*C.nvmlGpmSample_t)(unsafe.Pointer(&nvmlGpmSample)), cgoAllocsUnknown
	__ret := C.nvmlGpmMigSampleGet(cnvmlDevice, cGpuInstanceId, cnvmlGpmSample)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmQueryDeviceSupport function as declared in nvml/nvml.h
func nvmlGpmQueryDeviceSupport(nvmlDevice nvmlDevice, GpmSupport *GpmSupport) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cGpmSupport, _ := (*C.nvmlGpmSupport_t)(unsafe.Pointer(GpmSupport)), cgoAllocsUnknown
	__ret := C.nvmlGpmQueryDeviceSupport(cnvmlDevice, cGpmSupport)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmQueryIfStreamingEnabled function as declared in nvml/nvml.h
func nvmlGpmQueryIfStreamingEnabled(nvmlDevice nvmlDevice, State *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cState, _ := (*C.uint)(unsafe.Pointer(State)), cgoAllocsUnknown
	__ret := C.nvmlGpmQueryIfStreamingEnabled(cnvmlDevice, cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlGpmSetStreamingEnabled function as declared in nvml/nvml.h
func nvmlGpmSetStreamingEnabled(nvmlDevice nvmlDevice, State uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cState, _ := (C.uint)(State), cgoAllocsUnknown
	__ret := C.nvmlGpmSetStreamingEnabled(cnvmlDevice, cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCapabilities function as declared in nvml/nvml.h
func nvmlDeviceGetCapabilities(nvmlDevice nvmlDevice, Caps *DeviceCapabilities) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCaps, _ := (*C.nvmlDeviceCapabilities_t)(unsafe.Pointer(Caps)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCapabilities(cnvmlDevice, cCaps)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceWorkloadPowerProfileGetProfilesInfo function as declared in nvml/nvml.h
func nvmlDeviceWorkloadPowerProfileGetProfilesInfo(nvmlDevice nvmlDevice, ProfilesInfo *WorkloadPowerProfileProfilesInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfilesInfo, _ := (*C.nvmlWorkloadPowerProfileProfilesInfo_t)(unsafe.Pointer(ProfilesInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceWorkloadPowerProfileGetProfilesInfo(cnvmlDevice, cProfilesInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceWorkloadPowerProfileGetCurrentProfiles function as declared in nvml/nvml.h
func nvmlDeviceWorkloadPowerProfileGetCurrentProfiles(nvmlDevice nvmlDevice, CurrentProfiles *WorkloadPowerProfileCurrentProfiles) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrentProfiles, _ := (*C.nvmlWorkloadPowerProfileCurrentProfiles_t)(unsafe.Pointer(CurrentProfiles)), cgoAllocsUnknown
	__ret := C.nvmlDeviceWorkloadPowerProfileGetCurrentProfiles(cnvmlDevice, cCurrentProfiles)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceWorkloadPowerProfileSetRequestedProfiles function as declared in nvml/nvml.h
func nvmlDeviceWorkloadPowerProfileSetRequestedProfiles(nvmlDevice nvmlDevice, RequestedProfiles *WorkloadPowerProfileRequestedProfiles) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cRequestedProfiles, _ := (*C.nvmlWorkloadPowerProfileRequestedProfiles_t)(unsafe.Pointer(RequestedProfiles)), cgoAllocsUnknown
	__ret := C.nvmlDeviceWorkloadPowerProfileSetRequestedProfiles(cnvmlDevice, cRequestedProfiles)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceWorkloadPowerProfileClearRequestedProfiles function as declared in nvml/nvml.h
func nvmlDeviceWorkloadPowerProfileClearRequestedProfiles(nvmlDevice nvmlDevice, RequestedProfiles *WorkloadPowerProfileRequestedProfiles) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cRequestedProfiles, _ := (*C.nvmlWorkloadPowerProfileRequestedProfiles_t)(unsafe.Pointer(RequestedProfiles)), cgoAllocsUnknown
	__ret := C.nvmlDeviceWorkloadPowerProfileClearRequestedProfiles(cnvmlDevice, cRequestedProfiles)
	__v := (Return)(__ret)
	return __v
}

// nvmlDevicePowerSmoothingActivatePresetProfile function as declared in nvml/nvml.h
func nvmlDevicePowerSmoothingActivatePresetProfile(nvmlDevice nvmlDevice, Profile *PowerSmoothingProfile) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfile, _ := (*C.nvmlPowerSmoothingProfile_t)(unsafe.Pointer(Profile)), cgoAllocsUnknown
	__ret := C.nvmlDevicePowerSmoothingActivatePresetProfile(cnvmlDevice, cProfile)
	__v := (Return)(__ret)
	return __v
}

// nvmlDevicePowerSmoothingUpdatePresetProfileParam function as declared in nvml/nvml.h
func nvmlDevicePowerSmoothingUpdatePresetProfileParam(nvmlDevice nvmlDevice, Profile *PowerSmoothingProfile) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfile, _ := (*C.nvmlPowerSmoothingProfile_t)(unsafe.Pointer(Profile)), cgoAllocsUnknown
	__ret := C.nvmlDevicePowerSmoothingUpdatePresetProfileParam(cnvmlDevice, cProfile)
	__v := (Return)(__ret)
	return __v
}

// nvmlDevicePowerSmoothingSetState function as declared in nvml/nvml.h
func nvmlDevicePowerSmoothingSetState(nvmlDevice nvmlDevice, State *PowerSmoothingState) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cState, _ := (*C.nvmlPowerSmoothingState_t)(unsafe.Pointer(State)), cgoAllocsUnknown
	__ret := C.nvmlDevicePowerSmoothingSetState(cnvmlDevice, cState)
	__v := (Return)(__ret)
	return __v
}

// nvmlInit_v1 function as declared in nvml/nvml.h
func nvmlInit_v1() Return {
	__ret := C.nvmlInit()
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetCount_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetCount_v1(DeviceCount *uint32) Return {
	cDeviceCount, _ := (*C.uint)(unsafe.Pointer(DeviceCount)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetCount(cDeviceCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByIndex_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByIndex_v1(Index uint32, nvmlDevice *nvmlDevice) Return {
	cIndex, _ := (C.uint)(Index), cgoAllocsUnknown
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByIndex(cIndex, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetHandleByPciBusId_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetHandleByPciBusId_v1(PciBusId string, nvmlDevice *nvmlDevice) Return {
	cPciBusId, _ := unpackPCharString(PciBusId)
	cnvmlDevice, _ := (*C.nvmlDevice_t)(unsafe.Pointer(nvmlDevice)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetHandleByPciBusId(cPciBusId, cnvmlDevice)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPciInfo_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetPciInfo_v1(nvmlDevice nvmlDevice, Pci *PciInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPciInfo(cnvmlDevice, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetPciInfo_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetPciInfo_v2(nvmlDevice nvmlDevice, Pci *PciInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetPciInfo_v2(cnvmlDevice, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetNvLinkRemotePciInfo_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetNvLinkRemotePciInfo_v1(nvmlDevice nvmlDevice, Link uint32, Pci *PciInfo) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cLink, _ := (C.uint)(Link), cgoAllocsUnknown
	cPci, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(Pci)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetNvLinkRemotePciInfo(cnvmlDevice, cLink, cPci)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGridLicensableFeatures_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetGridLicensableFeatures_v1(nvmlDevice nvmlDevice, PGridLicensableFeatures *GridLicensableFeatures) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPGridLicensableFeatures, _ := (*C.nvmlGridLicensableFeatures_t)(unsafe.Pointer(PGridLicensableFeatures)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGridLicensableFeatures(cnvmlDevice, cPGridLicensableFeatures)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGridLicensableFeatures_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetGridLicensableFeatures_v2(nvmlDevice nvmlDevice, PGridLicensableFeatures *GridLicensableFeatures) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPGridLicensableFeatures, _ := (*C.nvmlGridLicensableFeatures_t)(unsafe.Pointer(PGridLicensableFeatures)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGridLicensableFeatures_v2(cnvmlDevice, cPGridLicensableFeatures)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGridLicensableFeatures_v3 function as declared in nvml/nvml.h
func nvmlDeviceGetGridLicensableFeatures_v3(nvmlDevice nvmlDevice, PGridLicensableFeatures *GridLicensableFeatures) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cPGridLicensableFeatures, _ := (*C.nvmlGridLicensableFeatures_t)(unsafe.Pointer(PGridLicensableFeatures)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGridLicensableFeatures_v3(cnvmlDevice, cPGridLicensableFeatures)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceRemoveGpu_v1 function as declared in nvml/nvml.h
func nvmlDeviceRemoveGpu_v1(PciInfo *PciInfo) Return {
	cPciInfo, _ := (*C.nvmlPciInfo_t)(unsafe.Pointer(PciInfo)), cgoAllocsUnknown
	__ret := C.nvmlDeviceRemoveGpu(cPciInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlEventSetWait_v1 function as declared in nvml/nvml.h
func nvmlEventSetWait_v1(Set nvmlEventSet, Data *nvmlEventData, Timeoutms uint32) Return {
	cSet, _ := *(*C.nvmlEventSet_t)(unsafe.Pointer(&Set)), cgoAllocsUnknown
	cData, _ := (*C.nvmlEventData_t)(unsafe.Pointer(Data)), cgoAllocsUnknown
	cTimeoutms, _ := (C.uint)(Timeoutms), cgoAllocsUnknown
	__ret := C.nvmlEventSetWait(cSet, cData, cTimeoutms)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetAttributes_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetAttributes_v1(nvmlDevice nvmlDevice, Attributes *DeviceAttributes) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cAttributes, _ := (*C.nvmlDeviceAttributes_t)(unsafe.Pointer(Attributes)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetAttributes(cnvmlDevice, cAttributes)
	__v := (Return)(__ret)
	return __v
}

// nvmlComputeInstanceGetInfo_v1 function as declared in nvml/nvml.h
func nvmlComputeInstanceGetInfo_v1(nvmlComputeInstance nvmlComputeInstance, Info *nvmlComputeInstanceInfo) Return {
	cnvmlComputeInstance, _ := *(*C.nvmlComputeInstance_t)(unsafe.Pointer(&nvmlComputeInstance)), cgoAllocsUnknown
	cInfo, _ := (*C.nvmlComputeInstanceInfo_t)(unsafe.Pointer(Info)), cgoAllocsUnknown
	__ret := C.nvmlComputeInstanceGetInfo(cnvmlComputeInstance, cInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetComputeRunningProcesses_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetComputeRunningProcesses_v1(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v1) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v1_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetComputeRunningProcesses(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetComputeRunningProcesses_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetComputeRunningProcesses_v2(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v2_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetComputeRunningProcesses_v2(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGraphicsRunningProcesses_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetGraphicsRunningProcesses_v1(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v1) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v1_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGraphicsRunningProcesses(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGraphicsRunningProcesses_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetGraphicsRunningProcesses_v2(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v2_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGraphicsRunningProcesses_v2(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMPSComputeRunningProcesses_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetMPSComputeRunningProcesses_v1(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v1) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v1_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMPSComputeRunningProcesses(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetMPSComputeRunningProcesses_v2 function as declared in nvml/nvml.h
func nvmlDeviceGetMPSComputeRunningProcesses_v2(nvmlDevice nvmlDevice, InfoCount *uint32, Infos *ProcessInfo_v2) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cInfoCount, _ := (*C.uint)(unsafe.Pointer(InfoCount)), cgoAllocsUnknown
	cInfos, _ := (*C.nvmlProcessInfo_v2_t)(unsafe.Pointer(Infos)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetMPSComputeRunningProcesses_v2(cnvmlDevice, cInfoCount, cInfos)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetGpuInstancePossiblePlacements_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetGpuInstancePossiblePlacements_v1(nvmlDevice nvmlDevice, ProfileId uint32, Placements *GpuInstancePlacement, Count *uint32) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cProfileId, _ := (C.uint)(ProfileId), cgoAllocsUnknown
	cPlacements, _ := (*C.nvmlGpuInstancePlacement_t)(unsafe.Pointer(Placements)), cgoAllocsUnknown
	cCount, _ := (*C.uint)(unsafe.Pointer(Count)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetGpuInstancePossiblePlacements(cnvmlDevice, cProfileId, cPlacements, cCount)
	__v := (Return)(__ret)
	return __v
}

// nvmlVgpuInstanceGetLicenseInfo_v1 function as declared in nvml/nvml.h
func nvmlVgpuInstanceGetLicenseInfo_v1(nvmlVgpuInstance nvmlVgpuInstance, LicenseInfo *VgpuLicenseInfo) Return {
	cnvmlVgpuInstance, _ := (C.nvmlVgpuInstance_t)(nvmlVgpuInstance), cgoAllocsUnknown
	cLicenseInfo, _ := (*C.nvmlVgpuLicenseInfo_t)(unsafe.Pointer(LicenseInfo)), cgoAllocsUnknown
	__ret := C.nvmlVgpuInstanceGetLicenseInfo(cnvmlVgpuInstance, cLicenseInfo)
	__v := (Return)(__ret)
	return __v
}

// nvmlDeviceGetDriverModel_v1 function as declared in nvml/nvml.h
func nvmlDeviceGetDriverModel_v1(nvmlDevice nvmlDevice, Current *DriverModel, Pending *DriverModel) Return {
	cnvmlDevice, _ := *(*C.nvmlDevice_t)(unsafe.Pointer(&nvmlDevice)), cgoAllocsUnknown
	cCurrent, _ := (*C.nvmlDriverModel_t)(unsafe.Pointer(Current)), cgoAllocsUnknown
	cPending, _ := (*C.nvmlDriverModel_t)(unsafe.Pointer(Pending)), cgoAllocsUnknown
	__ret := C.nvmlDeviceGetDriverModel(cnvmlDevice, cCurrent, cPending)
	__v := (Return)(__ret)
	return __v
}
