//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-io-surface")]
#[cfg(not(target_os = "watchos"))]
use objc2_io_surface::*;

use crate::*;

/// An opaque reference to a CGDisplayStream object
///
/// A CGDisplayStream provides a streaming API for capturing display updates in a realtime manner.  It can also provide
/// scaling and color space conversion services, as well as allow capturing sub regions of the display.   Callbacks can be targetted
/// at either a traditional CFRunLoop, or at a dispatch queue.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaystream?language=objc)
#[doc(alias = "CGDisplayStreamRef")]
#[repr(C)]
pub struct CGDisplayStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGDisplayStream {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGDisplayStream"> for CGDisplayStream {}
);

/// An opaque reference to a single frame's extra metadata that describes useful frame delta information
///
/// A CGDisplayStreamUpdate encapsulates information about what portions of a frame have changed relative to
/// a previously delivered frame.   This includes regions that were changed in any way, which ones were actually redrawn, and which
/// regions were merely copied from one place to another.   A routine is provided to merge two update refs together in cases
/// where apps need to coalesce the values because they decided to skip processing for one or more frames.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaystreamupdate?language=objc)
#[doc(alias = "CGDisplayStreamUpdateRef")]
#[repr(C)]
pub struct CGDisplayStreamUpdate {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGDisplayStreamUpdate {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGDisplayStreamUpdate"> for CGDisplayStreamUpdate {}
);

/// Used to select which array of rectangles to be returned by CGDisplayUpdateGetRects
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaystreamupdaterecttype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGDisplayStreamUpdateRectType(pub i32);
impl CGDisplayStreamUpdateRectType {
    #[doc(alias = "kCGDisplayStreamUpdateRefreshedRects")]
    pub const RefreshedRects: Self = Self(0);
    #[doc(alias = "kCGDisplayStreamUpdateMovedRects")]
    pub const MovedRects: Self = Self(1);
    #[doc(alias = "kCGDisplayStreamUpdateDirtyRects")]
    pub const DirtyRects: Self = Self(2);
    #[doc(alias = "kCGDisplayStreamUpdateReducedDirtyRects")]
    pub const ReducedDirtyRects: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGDisplayStreamUpdateRectType {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGDisplayStreamUpdateRectType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Provides information about incoming frame updates
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaystreamframestatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGDisplayStreamFrameStatus(pub i32);
impl CGDisplayStreamFrameStatus {
    #[doc(alias = "kCGDisplayStreamFrameStatusFrameComplete")]
    pub const FrameComplete: Self = Self(0);
    #[doc(alias = "kCGDisplayStreamFrameStatusFrameIdle")]
    pub const FrameIdle: Self = Self(1);
    #[doc(alias = "kCGDisplayStreamFrameStatusFrameBlank")]
    pub const FrameBlank: Self = Self(2);
    #[doc(alias = "kCGDisplayStreamFrameStatusStopped")]
    pub const Stopped: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGDisplayStreamFrameStatus {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGDisplayStreamFrameStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaystreamframeavailablehandler?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-io-surface"))]
#[cfg(not(target_os = "watchos"))]
pub type CGDisplayStreamFrameAvailableHandler = *mut block2::DynBlock<
    dyn Fn(CGDisplayStreamFrameStatus, u64, *mut IOSurfaceRef, *const CGDisplayStreamUpdate),
>;

unsafe impl ConcreteType for CGDisplayStreamUpdate {
    /// Returns the CF "class" ID for CGDisplayStreamUpdate
    ///
    /// Returns: The CFTypeID of the CGDisplayStreamUpdate class.
    #[doc(alias = "CGDisplayStreamUpdateGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGDisplayStreamUpdateGetTypeID() -> CFTypeID;
        }
        unsafe { CGDisplayStreamUpdateGetTypeID() }
    }
}

impl CGDisplayStreamUpdate {
    /// Returns a pointer to an array of CGRect structs that describe what parts of the frame have changed relative
    /// to the previously delivered frame.   This rectangle list encapsulates both the update rectangles and movement rectangles.
    ///
    /// Parameter `updateRef`: The CGDisplayStreamUpdateRef
    ///
    /// Parameter `rectCount`: A pointer to where the count of the number of rectangles in the array is to be returned. Must not be NULL.
    ///
    /// Returns: A pointer to the array of CGRectangles.  This array should not be freed by the caller.
    ///
    /// # Safety
    ///
    /// `rect_count` must be a valid pointer.
    #[doc(alias = "CGDisplayStreamUpdateGetRects")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub unsafe fn rects(
        update_ref: Option<&CGDisplayStreamUpdate>,
        rect_type: CGDisplayStreamUpdateRectType,
        rect_count: NonNull<usize>,
    ) -> *const CGRect {
        extern "C-unwind" {
            fn CGDisplayStreamUpdateGetRects(
                update_ref: Option<&CGDisplayStreamUpdate>,
                rect_type: CGDisplayStreamUpdateRectType,
                rect_count: NonNull<usize>,
            ) -> *const CGRect;
        }
        unsafe { CGDisplayStreamUpdateGetRects(update_ref, rect_type, rect_count) }
    }

    /// Merge two CGDisplayUpdateRefs into a new one.
    ///
    /// In cases where the client wishes to drop certain frame updates, this function may be used to merge two
    /// CGDisplayUpdateRefs together.  The core bit of functionality here is generating a new set of refresh/move/dirty
    /// rectangle arrays that properly represent the union of the deltas between the two frames.  Note that the ordering of
    /// the two refs is important.
    ///
    ///
    /// Parameter `firstUpdate`: The first update (in a temporal sense)
    ///
    /// Parameter `secondUpdate`: The second update (in a temporal sense)
    ///
    /// Returns: The new CGDisplayStreamUpdateRef
    #[doc(alias = "CGDisplayStreamUpdateCreateMergedUpdate")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub fn new_merged_update(
        first_update: Option<&CGDisplayStreamUpdate>,
        second_update: Option<&CGDisplayStreamUpdate>,
    ) -> Option<CFRetained<CGDisplayStreamUpdate>> {
        extern "C-unwind" {
            fn CGDisplayStreamUpdateCreateMergedUpdate(
                first_update: Option<&CGDisplayStreamUpdate>,
                second_update: Option<&CGDisplayStreamUpdate>,
            ) -> Option<NonNull<CGDisplayStreamUpdate>>;
        }
        let ret = unsafe { CGDisplayStreamUpdateCreateMergedUpdate(first_update, second_update) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Return the movement dx and dy values for a single update
    ///
    /// Parameter `updateRef`: The CGDisplayStreamUpdateRef
    ///
    /// Parameter `dx`: A pointer to a CGFloat to store the x component of the movement delta
    ///
    /// Parameter `dy`: A pointer to a CGFloat to store the y component of the movement delta
    ///
    /// The delta values describe the offset from the moved rectangles back to the source location.
    ///
    /// # Safety
    ///
    /// - `dx` must be a valid pointer.
    /// - `dy` must be a valid pointer.
    #[doc(alias = "CGDisplayStreamUpdateGetMovedRectsDelta")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub unsafe fn moved_rects_delta(
        update_ref: Option<&CGDisplayStreamUpdate>,
        dx: NonNull<CGFloat>,
        dy: NonNull<CGFloat>,
    ) {
        extern "C-unwind" {
            fn CGDisplayStreamUpdateGetMovedRectsDelta(
                update_ref: Option<&CGDisplayStreamUpdate>,
                dx: NonNull<CGFloat>,
                dy: NonNull<CGFloat>,
            );
        }
        unsafe { CGDisplayStreamUpdateGetMovedRectsDelta(update_ref, dx, dy) }
    }

    /// Return how many frames (if any) have been dropped since the last call to the handler.
    ///
    /// Parameter `updateRef`: The CGDisplayStreamUpdateRef
    ///
    /// Returns: The number of dropped frames
    ///
    /// This call is primarily useful for performance measurement to determine if the client is keeping up with
    /// all WindowServer updates.
    #[doc(alias = "CGDisplayStreamUpdateGetDropCount")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub fn drop_count(update_ref: Option<&CGDisplayStreamUpdate>) -> usize {
        extern "C-unwind" {
            fn CGDisplayStreamUpdateGetDropCount(
                update_ref: Option<&CGDisplayStreamUpdate>,
            ) -> usize;
        }
        unsafe { CGDisplayStreamUpdateGetDropCount(update_ref) }
    }
}

extern "C" {
    /// This may be used to request a subregion of the display to be provided as the source of the display stream.  Use
    /// CGRectCreateDictionaryRepresentation to convert from a CGRect to the value used here.   Note: The coordinate system for the
    /// source rectangle is specified in display logical coordinates and not in pixels, in order to match the normal convention on
    /// HiDPI displays.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamsourcerect?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamSourceRect: &'static CFString;
}

extern "C" {
    /// This may be used to request where within the destination buffer the display updates should be placed. Use
    /// CGRectCreateDictionaryRepresentation to convert from a CGRect to the value used here.   Note: The coordinate system for
    /// the destination rectangle is always specified in output pixels to match the fact that the output buffer size is also
    /// specified in terms of pixels.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamdestinationrect?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamDestinationRect: &'static CFString;
}

extern "C" {
    /// Enable/disable the work the Window Server will do to preserve the display aspect ratio.  By default the Window Server will
    /// assume that it should preserve the original aspect ratio of the source display rect.  If the aspect ratio of the source display and
    /// the display stream destination rect are not the same, black borders will be inserted at the top/bottom or right/left sides of the destination
    /// in order to preserve the source aspect ratio.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreampreserveaspectratio?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamPreserveAspectRatio: &'static CFString;
}

extern "C" {
    /// Set the desired CGColorSpace of the output frames.  By default the color space will be that of the display.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamcolorspace?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamColorSpace: &'static CFString;
}

extern "C" {
    /// Request that the delta between frame updates be at least as much specified by this value.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamminimumframetime?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamMinimumFrameTime: &'static CFString;
}

extern "C" {
    /// Controls whether the cursor is embedded within the provided buffers or not.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamshowcursor?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamShowCursor: &'static CFString;
}

extern "C" {
    /// Controls how many frames deep the frame queue will be.  Defaults to N.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamqueuedepth?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamQueueDepth: &'static CFString;
}

extern "C" {
    /// When outputting frames in 420v or 420f format, this key may be used to control which YCbCr matrix is used
    /// The value should be one of the three kCGDisplayStreamYCbCrMatrix values specified below.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamycbcrmatrix?language=objc)
    #[deprecated = "Please use ScreenCaptureKit instead."]
    pub static kCGDisplayStreamYCbCrMatrix: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamycbcrmatrix_itu_r_709_2?language=objc)
    pub static kCGDisplayStreamYCbCrMatrix_ITU_R_709_2: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamycbcrmatrix_itu_r_601_4?language=objc)
    pub static kCGDisplayStreamYCbCrMatrix_ITU_R_601_4: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgdisplaystreamycbcrmatrix_smpte_240m_1995?language=objc)
    pub static kCGDisplayStreamYCbCrMatrix_SMPTE_240M_1995: &'static CFString;
}

unsafe impl ConcreteType for CGDisplayStream {
    /// Returns the CF "class" ID for CGDisplayStream
    ///
    /// Returns: The CFTypeID of the CGDisplayStream class.
    #[doc(alias = "CGDisplayStreamGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGDisplayStreamGetTypeID() -> CFTypeID;
        }
        unsafe { CGDisplayStreamGetTypeID() }
    }
}

impl CGDisplayStream {
    /// Creates a new CGDisplayStream intended to be used with a CFRunLoop
    ///
    /// This function creates a new CGDisplayStream that is to be used to get a stream of frame updates
    /// from a particular display.
    ///
    /// Parameter `display`: The CGDirectDisplayID to use as the source for generated frames
    ///
    /// Parameter `outputWidth`: The output width (in pixels, not points) of the frames to be generated.  Must not be zero.
    ///
    /// Parameter `outputHeight`: The output height (in pixels, not points) of the frames to be generated.  Must not be zero.
    ///
    /// Parameter `pixelFormat`: The desired CoreVideo/CoreMedia-style pixel format of the output IOSurfaces.  The currently
    /// supported values are:
    ///
    /// 'BGRA' Packed Little Endian ARGB8888
    /// 'l10r' Packed Little Endian ARGB2101010
    /// '420v' 2-plane "video" range YCbCr 4:2:0
    /// '420f' 2-plane "full" range YCbCr 4:2:0
    ///
    ///
    /// Parameter `properties`: Any optional properties of the CGDisplayStream
    ///
    /// Parameter `handler`: A block that will be called for frame deliver.
    ///
    /// Returns: The new CGDisplayStream object.
    ///
    /// # Safety
    ///
    /// - `properties` generics must be of the correct type.
    /// - `handler` must be a valid pointer or null.
    #[doc(alias = "CGDisplayStreamCreate")]
    #[cfg(all(
        feature = "CGDirectDisplay",
        feature = "block2",
        feature = "objc2-io-surface"
    ))]
    #[cfg(not(target_os = "watchos"))]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub unsafe fn new(
        display: CGDirectDisplayID,
        output_width: usize,
        output_height: usize,
        pixel_format: i32,
        properties: Option<&CFDictionary>,
        handler: CGDisplayStreamFrameAvailableHandler,
    ) -> Option<CFRetained<CGDisplayStream>> {
        extern "C-unwind" {
            fn CGDisplayStreamCreate(
                display: CGDirectDisplayID,
                output_width: usize,
                output_height: usize,
                pixel_format: i32,
                properties: Option<&CFDictionary>,
                handler: CGDisplayStreamFrameAvailableHandler,
            ) -> Option<NonNull<CGDisplayStream>>;
        }
        let ret = unsafe {
            CGDisplayStreamCreate(
                display,
                output_width,
                output_height,
                pixel_format,
                properties,
                handler,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a new CGDisplayStream intended to be serviced by a block handler
    ///
    /// This function creates a new CGDisplayStream that is to be used to get a stream of frame updates
    /// from a particular display.
    ///
    /// Parameter `display`: The CGDirectDisplayID to use as the source for generated frames
    ///
    /// Parameter `outputWidth`: The output width (in pixels, not points) of the frames to be generated.  Must not be zero.
    ///
    /// Parameter `outputHeight`: The output height (in pixels, not points) of the frames to be generated.  Must not be zero.
    ///
    /// Parameter `pixelFormat`: The desired CoreVideo/CoreMedia-style pixel format of the output IOSurfaces
    ///
    /// Parameter `properties`: Any optional properties of the CGDisplayStream
    ///
    /// Parameter `queue`: The dispatch_queue_t that will be used to invoke the callback handler.
    ///
    /// Parameter `handler`: A block that will be called for frame deliver.
    ///
    /// Returns: The new CGDisplayStream object.
    ///
    /// # Safety
    ///
    /// - `properties` generics must be of the correct type.
    /// - `queue` possibly has additional threading requirements.
    /// - `handler` must be a valid pointer or null.
    #[doc(alias = "CGDisplayStreamCreateWithDispatchQueue")]
    #[cfg(all(
        feature = "CGDirectDisplay",
        feature = "block2",
        feature = "dispatch2",
        feature = "objc2-io-surface"
    ))]
    #[cfg(not(target_os = "watchos"))]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub unsafe fn with_dispatch_queue(
        display: CGDirectDisplayID,
        output_width: usize,
        output_height: usize,
        pixel_format: i32,
        properties: Option<&CFDictionary>,
        queue: &DispatchQueue,
        handler: CGDisplayStreamFrameAvailableHandler,
    ) -> Option<CFRetained<CGDisplayStream>> {
        extern "C-unwind" {
            fn CGDisplayStreamCreateWithDispatchQueue(
                display: CGDirectDisplayID,
                output_width: usize,
                output_height: usize,
                pixel_format: i32,
                properties: Option<&CFDictionary>,
                queue: &DispatchQueue,
                handler: CGDisplayStreamFrameAvailableHandler,
            ) -> Option<NonNull<CGDisplayStream>>;
        }
        let ret = unsafe {
            CGDisplayStreamCreateWithDispatchQueue(
                display,
                output_width,
                output_height,
                pixel_format,
                properties,
                queue,
                handler,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Begin delivering frame updates to the handler block.
    ///
    /// Parameter `displayStream`: to be started
    ///
    /// Returns: kCGErrorSuccess If the display stream was started, otherwise an error.
    #[doc(alias = "CGDisplayStreamStart")]
    #[cfg(feature = "CGError")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub fn start(display_stream: Option<&CGDisplayStream>) -> CGError {
        extern "C-unwind" {
            fn CGDisplayStreamStart(display_stream: Option<&CGDisplayStream>) -> CGError;
        }
        unsafe { CGDisplayStreamStart(display_stream) }
    }

    /// End delivery of frame updates to the handler block.
    ///
    /// Parameter `displayStream`: to be stopped
    ///
    /// Returns: kCGErrorSuccess If the display stream was stopped, otherwise an error.
    ///
    /// After this call returns, the CGDisplayStream callback function will eventually be called with a
    /// status of kCGDisplayStreamFrameStatusStopped.  After that point it is safe to release the CGDisplayStream.
    /// It is safe to call this function from within the handler block, but the previous caveat still applies.
    #[doc(alias = "CGDisplayStreamStop")]
    #[cfg(feature = "CGError")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub fn stop(display_stream: Option<&CGDisplayStream>) -> CGError {
        extern "C-unwind" {
            fn CGDisplayStreamStop(display_stream: Option<&CGDisplayStream>) -> CGError;
        }
        unsafe { CGDisplayStreamStop(display_stream) }
    }

    /// Return the singleton CFRunLoopSourceRef for a CGDisplayStream.
    ///
    /// Parameter `displayStream`: The CGDisplayStream object
    ///
    /// Returns: The CFRunLoopSource for this displayStream.  Note: This function will return NULL if the
    /// display stream was created via  CGDisplayStreamCreateWithDispatchQueue().
    #[doc(alias = "CGDisplayStreamGetRunLoopSource")]
    #[deprecated = "Please use ScreenCaptureKit instead."]
    #[inline]
    pub unsafe fn run_loop_source(
        display_stream: Option<&CGDisplayStream>,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CGDisplayStreamGetRunLoopSource(
                display_stream: Option<&CGDisplayStream>,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe { CGDisplayStreamGetRunLoopSource(display_stream) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGDisplayStreamUpdate::rects`"]
    pub fn CGDisplayStreamUpdateGetRects(
        update_ref: Option<&CGDisplayStreamUpdate>,
        rect_type: CGDisplayStreamUpdateRectType,
        rect_count: NonNull<usize>,
    ) -> *const CGRect;
}

#[deprecated = "renamed to `CGDisplayStreamUpdate::new_merged_update`"]
#[inline]
pub extern "C-unwind" fn CGDisplayStreamUpdateCreateMergedUpdate(
    first_update: Option<&CGDisplayStreamUpdate>,
    second_update: Option<&CGDisplayStreamUpdate>,
) -> Option<CFRetained<CGDisplayStreamUpdate>> {
    extern "C-unwind" {
        fn CGDisplayStreamUpdateCreateMergedUpdate(
            first_update: Option<&CGDisplayStreamUpdate>,
            second_update: Option<&CGDisplayStreamUpdate>,
        ) -> Option<NonNull<CGDisplayStreamUpdate>>;
    }
    let ret = unsafe { CGDisplayStreamUpdateCreateMergedUpdate(first_update, second_update) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGDisplayStreamUpdate::moved_rects_delta`"]
    pub fn CGDisplayStreamUpdateGetMovedRectsDelta(
        update_ref: Option<&CGDisplayStreamUpdate>,
        dx: NonNull<CGFloat>,
        dy: NonNull<CGFloat>,
    );
}

#[deprecated = "renamed to `CGDisplayStreamUpdate::drop_count`"]
#[inline]
pub extern "C-unwind" fn CGDisplayStreamUpdateGetDropCount(
    update_ref: Option<&CGDisplayStreamUpdate>,
) -> usize {
    extern "C-unwind" {
        fn CGDisplayStreamUpdateGetDropCount(update_ref: Option<&CGDisplayStreamUpdate>) -> usize;
    }
    unsafe { CGDisplayStreamUpdateGetDropCount(update_ref) }
}

#[cfg(all(
    feature = "CGDirectDisplay",
    feature = "block2",
    feature = "objc2-io-surface"
))]
#[cfg(not(target_os = "watchos"))]
#[deprecated = "renamed to `CGDisplayStream::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayStreamCreate(
    display: CGDirectDisplayID,
    output_width: usize,
    output_height: usize,
    pixel_format: i32,
    properties: Option<&CFDictionary>,
    handler: CGDisplayStreamFrameAvailableHandler,
) -> Option<CFRetained<CGDisplayStream>> {
    extern "C-unwind" {
        fn CGDisplayStreamCreate(
            display: CGDirectDisplayID,
            output_width: usize,
            output_height: usize,
            pixel_format: i32,
            properties: Option<&CFDictionary>,
            handler: CGDisplayStreamFrameAvailableHandler,
        ) -> Option<NonNull<CGDisplayStream>>;
    }
    let ret = unsafe {
        CGDisplayStreamCreate(
            display,
            output_width,
            output_height,
            pixel_format,
            properties,
            handler,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(
    feature = "CGDirectDisplay",
    feature = "block2",
    feature = "dispatch2",
    feature = "objc2-io-surface"
))]
#[cfg(not(target_os = "watchos"))]
#[deprecated = "renamed to `CGDisplayStream::with_dispatch_queue`"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayStreamCreateWithDispatchQueue(
    display: CGDirectDisplayID,
    output_width: usize,
    output_height: usize,
    pixel_format: i32,
    properties: Option<&CFDictionary>,
    queue: &DispatchQueue,
    handler: CGDisplayStreamFrameAvailableHandler,
) -> Option<CFRetained<CGDisplayStream>> {
    extern "C-unwind" {
        fn CGDisplayStreamCreateWithDispatchQueue(
            display: CGDirectDisplayID,
            output_width: usize,
            output_height: usize,
            pixel_format: i32,
            properties: Option<&CFDictionary>,
            queue: &DispatchQueue,
            handler: CGDisplayStreamFrameAvailableHandler,
        ) -> Option<NonNull<CGDisplayStream>>;
    }
    let ret = unsafe {
        CGDisplayStreamCreateWithDispatchQueue(
            display,
            output_width,
            output_height,
            pixel_format,
            properties,
            queue,
            handler,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CGError")]
#[deprecated = "renamed to `CGDisplayStream::start`"]
#[inline]
pub extern "C-unwind" fn CGDisplayStreamStart(display_stream: Option<&CGDisplayStream>) -> CGError {
    extern "C-unwind" {
        fn CGDisplayStreamStart(display_stream: Option<&CGDisplayStream>) -> CGError;
    }
    unsafe { CGDisplayStreamStart(display_stream) }
}

#[cfg(feature = "CGError")]
#[deprecated = "renamed to `CGDisplayStream::stop`"]
#[inline]
pub extern "C-unwind" fn CGDisplayStreamStop(display_stream: Option<&CGDisplayStream>) -> CGError {
    extern "C-unwind" {
        fn CGDisplayStreamStop(display_stream: Option<&CGDisplayStream>) -> CGError;
    }
    unsafe { CGDisplayStreamStop(display_stream) }
}

#[deprecated = "renamed to `CGDisplayStream::run_loop_source`"]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayStreamGetRunLoopSource(
    display_stream: Option<&CGDisplayStream>,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CGDisplayStreamGetRunLoopSource(
            display_stream: Option<&CGDisplayStream>,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe { CGDisplayStreamGetRunLoopSource(display_stream) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
