//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(target_vendor = "apple")]
use objc2_quartz_core::*;

use crate::*;

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAutoresizingMaskOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSAutoresizingMaskOptions: NSUInteger {
        const NSViewNotSizable = 0;
        const NSViewMinXMargin = 1;
        const NSViewWidthSizable = 2;
        const NSViewMaxXMargin = 4;
        const NSViewMinYMargin = 8;
        const NSViewHeightSizable = 16;
        const NSViewMaxYMargin = 32;
    }
}

unsafe impl Encode for NSAutoresizingMaskOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSAutoresizingMaskOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBorderType(pub NSUInteger);
impl NSBorderType {
    pub const NSNoBorder: Self = Self(0);
    pub const NSLineBorder: Self = Self(1);
    pub const NSBezelBorder: Self = Self(2);
    pub const NSGrooveBorder: Self = Self(3);
}

unsafe impl Encode for NSBorderType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBorderType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSViewLayerContentsRedrawPolicy(pub NSInteger);
impl NSViewLayerContentsRedrawPolicy {
    pub const NSViewLayerContentsRedrawNever: Self = Self(0);
    pub const NSViewLayerContentsRedrawOnSetNeedsDisplay: Self = Self(1);
    pub const NSViewLayerContentsRedrawDuringViewResize: Self = Self(2);
    pub const NSViewLayerContentsRedrawBeforeViewResize: Self = Self(3);
    pub const NSViewLayerContentsRedrawCrossfade: Self = Self(4);
}

unsafe impl Encode for NSViewLayerContentsRedrawPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSViewLayerContentsRedrawPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSViewLayerContentsPlacement(pub NSInteger);
impl NSViewLayerContentsPlacement {
    #[doc(alias = "NSViewLayerContentsPlacementScaleAxesIndependently")]
    pub const ScaleAxesIndependently: Self = Self(0);
    #[doc(alias = "NSViewLayerContentsPlacementScaleProportionallyToFit")]
    pub const ScaleProportionallyToFit: Self = Self(1);
    #[doc(alias = "NSViewLayerContentsPlacementScaleProportionallyToFill")]
    pub const ScaleProportionallyToFill: Self = Self(2);
    #[doc(alias = "NSViewLayerContentsPlacementCenter")]
    pub const Center: Self = Self(3);
    #[doc(alias = "NSViewLayerContentsPlacementTop")]
    pub const Top: Self = Self(4);
    #[doc(alias = "NSViewLayerContentsPlacementTopRight")]
    pub const TopRight: Self = Self(5);
    #[doc(alias = "NSViewLayerContentsPlacementRight")]
    pub const Right: Self = Self(6);
    #[doc(alias = "NSViewLayerContentsPlacementBottomRight")]
    pub const BottomRight: Self = Self(7);
    #[doc(alias = "NSViewLayerContentsPlacementBottom")]
    pub const Bottom: Self = Self(8);
    #[doc(alias = "NSViewLayerContentsPlacementBottomLeft")]
    pub const BottomLeft: Self = Self(9);
    #[doc(alias = "NSViewLayerContentsPlacementLeft")]
    pub const Left: Self = Self(10);
    #[doc(alias = "NSViewLayerContentsPlacementTopLeft")]
    pub const TopLeft: Self = Self(11);
}

unsafe impl Encode for NSViewLayerContentsPlacement {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSViewLayerContentsPlacement {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

pub type NSTrackingRectTag = NSInteger;

pub type NSToolTipTag = NSInteger;

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSResponder")]
    pub struct NSView;

    #[cfg(feature = "NSResponder")]
    unsafe impl ClassType for NSView {
        #[inherits(NSObject)]
        type Super = NSResponder;
        type Mutability = MainThreadOnly;
    }
);

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
unsafe impl NSAccessibility for NSView {}

#[cfg(all(feature = "NSAccessibilityProtocols", feature = "NSResponder"))]
unsafe impl NSAccessibilityElementProtocol for NSView {}

#[cfg(all(feature = "NSAnimation", feature = "NSResponder"))]
unsafe impl NSAnimatablePropertyContainer for NSView {}

#[cfg(all(feature = "NSAppearance", feature = "NSResponder"))]
unsafe impl NSAppearanceCustomization for NSView {}

#[cfg(feature = "NSResponder")]
unsafe impl NSCoding for NSView {}

#[cfg(all(feature = "NSDragging", feature = "NSResponder"))]
unsafe impl NSDraggingDestination for NSView {}

#[cfg(feature = "NSResponder")]
unsafe impl NSObjectProtocol for NSView {}

#[cfg(all(feature = "NSResponder", feature = "NSUserInterfaceItemIdentification"))]
unsafe impl NSUserInterfaceItemIdentification for NSView {}

extern_methods!(
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method_id(@__retain_semantics Init initWithFrame:)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSWindow")]
        #[method_id(@__retain_semantics Other window)]
        pub fn window(&self) -> Option<Retained<NSWindow>>;

        #[method_id(@__retain_semantics Other superview)]
        pub unsafe fn superview(&self) -> Option<Retained<NSView>>;

        #[method_id(@__retain_semantics Other subviews)]
        pub unsafe fn subviews(&self) -> Retained<NSArray<NSView>>;

        #[method(setSubviews:)]
        pub unsafe fn setSubviews(&self, subviews: &NSArray<NSView>);

        #[method(isDescendantOf:)]
        pub unsafe fn isDescendantOf(&self, view: &NSView) -> bool;

        #[method_id(@__retain_semantics Other ancestorSharedWithView:)]
        pub unsafe fn ancestorSharedWithView(&self, view: &NSView) -> Option<Retained<NSView>>;

        #[method_id(@__retain_semantics Other opaqueAncestor)]
        pub unsafe fn opaqueAncestor(&self) -> Option<Retained<NSView>>;

        #[method(isHidden)]
        pub unsafe fn isHidden(&self) -> bool;

        #[method(setHidden:)]
        pub fn setHidden(&self, hidden: bool);

        #[method(isHiddenOrHasHiddenAncestor)]
        pub unsafe fn isHiddenOrHasHiddenAncestor(&self) -> bool;

        #[method(getRectsBeingDrawn:count:)]
        pub unsafe fn getRectsBeingDrawn_count(
            &self,
            rects: *mut *mut NSRect,
            count: *mut NSInteger,
        );

        #[method(needsToDrawRect:)]
        pub unsafe fn needsToDrawRect(&self, rect: NSRect) -> bool;

        #[method(wantsDefaultClipping)]
        pub unsafe fn wantsDefaultClipping(&self) -> bool;

        #[method(viewDidHide)]
        pub unsafe fn viewDidHide(&self);

        #[method(viewDidUnhide)]
        pub unsafe fn viewDidUnhide(&self);

        #[method(addSubview:)]
        pub unsafe fn addSubview(&self, view: &NSView);

        #[cfg(feature = "NSGraphics")]
        #[method(addSubview:positioned:relativeTo:)]
        pub unsafe fn addSubview_positioned_relativeTo(
            &self,
            view: &NSView,
            place: NSWindowOrderingMode,
            other_view: Option<&NSView>,
        );

        #[method(sortSubviewsUsingFunction:context:)]
        pub unsafe fn sortSubviewsUsingFunction_context(
            &self,
            compare: unsafe extern "C" fn(
                NonNull<NSView>,
                NonNull<NSView>,
                *mut c_void,
            ) -> NSComparisonResult,
            context: *mut c_void,
        );

        #[cfg(feature = "NSWindow")]
        #[method(viewWillMoveToWindow:)]
        pub unsafe fn viewWillMoveToWindow(&self, new_window: Option<&NSWindow>);

        #[method(viewDidMoveToWindow)]
        pub unsafe fn viewDidMoveToWindow(&self);

        #[method(viewWillMoveToSuperview:)]
        pub unsafe fn viewWillMoveToSuperview(&self, new_superview: Option<&NSView>);

        #[method(viewDidMoveToSuperview)]
        pub unsafe fn viewDidMoveToSuperview(&self);

        #[method(didAddSubview:)]
        pub unsafe fn didAddSubview(&self, subview: &NSView);

        #[method(willRemoveSubview:)]
        pub unsafe fn willRemoveSubview(&self, subview: &NSView);

        #[method(removeFromSuperview)]
        pub unsafe fn removeFromSuperview(&self);

        #[method(replaceSubview:with:)]
        pub unsafe fn replaceSubview_with(&self, old_view: &NSView, new_view: &NSView);

        #[method(removeFromSuperviewWithoutNeedingDisplay)]
        pub unsafe fn removeFromSuperviewWithoutNeedingDisplay(&self);

        #[method(viewDidChangeBackingProperties)]
        pub unsafe fn viewDidChangeBackingProperties(&self);

        #[method(postsFrameChangedNotifications)]
        pub unsafe fn postsFrameChangedNotifications(&self) -> bool;

        #[method(setPostsFrameChangedNotifications:)]
        pub fn setPostsFrameChangedNotifications(&self, posts_frame_changed_notifications: bool);

        #[method(resizeSubviewsWithOldSize:)]
        pub unsafe fn resizeSubviewsWithOldSize(&self, old_size: NSSize);

        #[method(resizeWithOldSuperviewSize:)]
        pub unsafe fn resizeWithOldSuperviewSize(&self, old_size: NSSize);

        #[method(autoresizesSubviews)]
        pub unsafe fn autoresizesSubviews(&self) -> bool;

        #[method(setAutoresizesSubviews:)]
        pub unsafe fn setAutoresizesSubviews(&self, autoresizes_subviews: bool);

        #[method(autoresizingMask)]
        pub unsafe fn autoresizingMask(&self) -> NSAutoresizingMaskOptions;

        #[method(setAutoresizingMask:)]
        pub unsafe fn setAutoresizingMask(&self, autoresizing_mask: NSAutoresizingMaskOptions);

        #[method(setFrameOrigin:)]
        pub unsafe fn setFrameOrigin(&self, new_origin: NSPoint);

        #[method(setFrameSize:)]
        pub unsafe fn setFrameSize(&self, new_size: NSSize);

        #[method(frame)]
        pub fn frame(&self) -> NSRect;

        #[method(setFrame:)]
        pub unsafe fn setFrame(&self, frame: NSRect);

        #[method(frameRotation)]
        pub unsafe fn frameRotation(&self) -> CGFloat;

        #[method(setFrameRotation:)]
        pub unsafe fn setFrameRotation(&self, frame_rotation: CGFloat);

        #[method(frameCenterRotation)]
        pub unsafe fn frameCenterRotation(&self) -> CGFloat;

        #[method(setFrameCenterRotation:)]
        pub unsafe fn setFrameCenterRotation(&self, frame_center_rotation: CGFloat);

        #[method(setBoundsOrigin:)]
        pub unsafe fn setBoundsOrigin(&self, new_origin: NSPoint);

        #[method(setBoundsSize:)]
        pub unsafe fn setBoundsSize(&self, new_size: NSSize);

        #[method(boundsRotation)]
        pub unsafe fn boundsRotation(&self) -> CGFloat;

        #[method(setBoundsRotation:)]
        pub unsafe fn setBoundsRotation(&self, bounds_rotation: CGFloat);

        #[method(translateOriginToPoint:)]
        pub unsafe fn translateOriginToPoint(&self, translation: NSPoint);

        #[method(scaleUnitSquareToSize:)]
        pub unsafe fn scaleUnitSquareToSize(&self, new_unit_size: NSSize);

        #[method(rotateByAngle:)]
        pub unsafe fn rotateByAngle(&self, angle: CGFloat);

        #[method(bounds)]
        pub fn bounds(&self) -> NSRect;

        #[method(setBounds:)]
        pub unsafe fn setBounds(&self, bounds: NSRect);

        #[method(isFlipped)]
        pub fn isFlipped(&self) -> bool;

        #[method(isRotatedFromBase)]
        pub unsafe fn isRotatedFromBase(&self) -> bool;

        #[method(isRotatedOrScaledFromBase)]
        pub unsafe fn isRotatedOrScaledFromBase(&self) -> bool;

        #[method(isOpaque)]
        pub unsafe fn isOpaque(&self) -> bool;

        #[method(convertPoint:fromView:)]
        pub fn convertPoint_fromView(&self, point: NSPoint, view: Option<&NSView>) -> NSPoint;

        #[method(convertPoint:toView:)]
        pub unsafe fn convertPoint_toView(&self, point: NSPoint, view: Option<&NSView>) -> NSPoint;

        #[method(convertSize:fromView:)]
        pub unsafe fn convertSize_fromView(&self, size: NSSize, view: Option<&NSView>) -> NSSize;

        #[method(convertSize:toView:)]
        pub unsafe fn convertSize_toView(&self, size: NSSize, view: Option<&NSView>) -> NSSize;

        #[method(convertRect:fromView:)]
        pub unsafe fn convertRect_fromView(&self, rect: NSRect, view: Option<&NSView>) -> NSRect;

        #[method(convertRect:toView:)]
        pub fn convertRect_toView(&self, rect: NSRect, view: Option<&NSView>) -> NSRect;

        #[method(backingAlignedRect:options:)]
        pub unsafe fn backingAlignedRect_options(
            &self,
            rect: NSRect,
            options: NSAlignmentOptions,
        ) -> NSRect;

        #[method(centerScanRect:)]
        pub unsafe fn centerScanRect(&self, rect: NSRect) -> NSRect;

        #[method(convertPointToBacking:)]
        pub unsafe fn convertPointToBacking(&self, point: NSPoint) -> NSPoint;

        #[method(convertPointFromBacking:)]
        pub unsafe fn convertPointFromBacking(&self, point: NSPoint) -> NSPoint;

        #[method(convertSizeToBacking:)]
        pub unsafe fn convertSizeToBacking(&self, size: NSSize) -> NSSize;

        #[method(convertSizeFromBacking:)]
        pub unsafe fn convertSizeFromBacking(&self, size: NSSize) -> NSSize;

        #[method(convertRectToBacking:)]
        pub unsafe fn convertRectToBacking(&self, rect: NSRect) -> NSRect;

        #[method(convertRectFromBacking:)]
        pub unsafe fn convertRectFromBacking(&self, rect: NSRect) -> NSRect;

        #[method(convertPointToLayer:)]
        pub unsafe fn convertPointToLayer(&self, point: NSPoint) -> NSPoint;

        #[method(convertPointFromLayer:)]
        pub unsafe fn convertPointFromLayer(&self, point: NSPoint) -> NSPoint;

        #[method(convertSizeToLayer:)]
        pub unsafe fn convertSizeToLayer(&self, size: NSSize) -> NSSize;

        #[method(convertSizeFromLayer:)]
        pub unsafe fn convertSizeFromLayer(&self, size: NSSize) -> NSSize;

        #[method(convertRectToLayer:)]
        pub unsafe fn convertRectToLayer(&self, rect: NSRect) -> NSRect;

        #[method(convertRectFromLayer:)]
        pub unsafe fn convertRectFromLayer(&self, rect: NSRect) -> NSRect;

        #[method(canDrawConcurrently)]
        pub unsafe fn canDrawConcurrently(&self) -> bool;

        #[method(setCanDrawConcurrently:)]
        pub unsafe fn setCanDrawConcurrently(&self, can_draw_concurrently: bool);

        #[deprecated = "If a view needs display, -drawRect: or -updateLayer will be called automatically when the view is able to draw.  To check whether a view is in a window, call -window.  To check whether a view is hidden, call -isHiddenOrHasHiddenAncestor."]
        #[method(canDraw)]
        pub unsafe fn canDraw(&self) -> bool;

        #[method(setNeedsDisplayInRect:)]
        pub unsafe fn setNeedsDisplayInRect(&self, invalid_rect: NSRect);

        #[method(needsDisplay)]
        pub unsafe fn needsDisplay(&self) -> bool;

        #[method(setNeedsDisplay:)]
        pub unsafe fn setNeedsDisplay(&self, needs_display: bool);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[method(lockFocus)]
        pub unsafe fn lockFocus(&self);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[method(unlockFocus)]
        pub unsafe fn unlockFocus(&self);

        #[deprecated = "To draw, subclass NSView and implement -drawRect:; AppKit's automatic deferred display mechanism will call -drawRect: as necessary to display the view."]
        #[method(lockFocusIfCanDraw)]
        pub unsafe fn lockFocusIfCanDraw(&self) -> bool;

        #[cfg(feature = "NSGraphicsContext")]
        #[deprecated = "Use -[NSView displayRectIgnoringOpacity:inContext:] to draw a view subtree into a graphics context."]
        #[method(lockFocusIfCanDrawInContext:)]
        pub unsafe fn lockFocusIfCanDrawInContext(&self, context: &NSGraphicsContext) -> bool;

        #[method_id(@__retain_semantics Other focusView)]
        pub unsafe fn focusView(mtm: MainThreadMarker) -> Option<Retained<NSView>>;

        #[method(visibleRect)]
        pub fn visibleRect(&self) -> NSRect;

        #[method(display)]
        pub unsafe fn display(&self);

        #[method(displayIfNeeded)]
        pub unsafe fn displayIfNeeded(&self);

        #[method(displayIfNeededIgnoringOpacity)]
        pub unsafe fn displayIfNeededIgnoringOpacity(&self);

        #[method(displayRect:)]
        pub unsafe fn displayRect(&self, rect: NSRect);

        #[method(displayIfNeededInRect:)]
        pub unsafe fn displayIfNeededInRect(&self, rect: NSRect);

        #[method(displayRectIgnoringOpacity:)]
        pub unsafe fn displayRectIgnoringOpacity(&self, rect: NSRect);

        #[method(displayIfNeededInRectIgnoringOpacity:)]
        pub unsafe fn displayIfNeededInRectIgnoringOpacity(&self, rect: NSRect);

        #[method(drawRect:)]
        pub unsafe fn drawRect(&self, dirty_rect: NSRect);

        #[cfg(feature = "NSGraphicsContext")]
        #[method(displayRectIgnoringOpacity:inContext:)]
        pub unsafe fn displayRectIgnoringOpacity_inContext(
            &self,
            rect: NSRect,
            context: &NSGraphicsContext,
        );

        #[cfg(all(feature = "NSBitmapImageRep", feature = "NSImageRep"))]
        #[method_id(@__retain_semantics Other bitmapImageRepForCachingDisplayInRect:)]
        pub unsafe fn bitmapImageRepForCachingDisplayInRect(
            &self,
            rect: NSRect,
        ) -> Option<Retained<NSBitmapImageRep>>;

        #[cfg(all(feature = "NSBitmapImageRep", feature = "NSImageRep"))]
        #[method(cacheDisplayInRect:toBitmapImageRep:)]
        pub unsafe fn cacheDisplayInRect_toBitmapImageRep(
            &self,
            rect: NSRect,
            bitmap_image_rep: &NSBitmapImageRep,
        );

        #[method(viewWillDraw)]
        pub unsafe fn viewWillDraw(&self);

        #[method(scrollPoint:)]
        pub unsafe fn scrollPoint(&self, point: NSPoint);

        #[method(scrollRectToVisible:)]
        pub unsafe fn scrollRectToVisible(&self, rect: NSRect) -> bool;

        #[cfg(feature = "NSEvent")]
        #[method(autoscroll:)]
        pub unsafe fn autoscroll(&self, event: &NSEvent) -> bool;

        #[method(adjustScroll:)]
        pub unsafe fn adjustScroll(&self, new_visible: NSRect) -> NSRect;

        #[deprecated = "Use NSScrollView to achieve scrolling views."]
        #[method(scrollRect:by:)]
        pub unsafe fn scrollRect_by(&self, rect: NSRect, delta: NSSize);

        #[method(translateRectsNeedingDisplayInRect:by:)]
        pub unsafe fn translateRectsNeedingDisplayInRect_by(
            &self,
            clip_rect: NSRect,
            delta: NSSize,
        );

        #[method_id(@__retain_semantics Other hitTest:)]
        pub unsafe fn hitTest(&self, point: NSPoint) -> Option<Retained<NSView>>;

        #[method(mouse:inRect:)]
        pub unsafe fn mouse_inRect(&self, point: NSPoint, rect: NSRect) -> bool;

        #[method_id(@__retain_semantics Other viewWithTag:)]
        pub unsafe fn viewWithTag(&self, tag: NSInteger) -> Option<Retained<NSView>>;

        #[method(tag)]
        pub unsafe fn tag(&self) -> NSInteger;

        #[cfg(feature = "NSEvent")]
        #[method(performKeyEquivalent:)]
        pub unsafe fn performKeyEquivalent(&self, event: &NSEvent) -> bool;

        #[cfg(feature = "NSEvent")]
        #[method(acceptsFirstMouse:)]
        pub unsafe fn acceptsFirstMouse(&self, event: Option<&NSEvent>) -> bool;

        #[cfg(feature = "NSEvent")]
        #[method(shouldDelayWindowOrderingForEvent:)]
        pub unsafe fn shouldDelayWindowOrderingForEvent(&self, event: &NSEvent) -> bool;

        #[method(needsPanelToBecomeKey)]
        pub unsafe fn needsPanelToBecomeKey(&self) -> bool;

        #[method(mouseDownCanMoveWindow)]
        pub unsafe fn mouseDownCanMoveWindow(&self) -> bool;

        #[deprecated = "Use allowedTouchTypes instead"]
        #[method(acceptsTouchEvents)]
        pub unsafe fn acceptsTouchEvents(&self) -> bool;

        #[deprecated = "Use allowedTouchTypes instead"]
        #[method(setAcceptsTouchEvents:)]
        pub unsafe fn setAcceptsTouchEvents(&self, accepts_touch_events: bool);

        #[method(wantsRestingTouches)]
        pub unsafe fn wantsRestingTouches(&self) -> bool;

        #[method(setWantsRestingTouches:)]
        pub unsafe fn setWantsRestingTouches(&self, wants_resting_touches: bool);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[method_id(@__retain_semantics Other makeBackingLayer)]
        pub unsafe fn makeBackingLayer(&self) -> Retained<CALayer>;

        #[method(layerContentsRedrawPolicy)]
        pub unsafe fn layerContentsRedrawPolicy(&self) -> NSViewLayerContentsRedrawPolicy;

        #[method(setLayerContentsRedrawPolicy:)]
        pub unsafe fn setLayerContentsRedrawPolicy(
            &self,
            layer_contents_redraw_policy: NSViewLayerContentsRedrawPolicy,
        );

        #[method(layerContentsPlacement)]
        pub unsafe fn layerContentsPlacement(&self) -> NSViewLayerContentsPlacement;

        #[method(setLayerContentsPlacement:)]
        pub unsafe fn setLayerContentsPlacement(
            &self,
            layer_contents_placement: NSViewLayerContentsPlacement,
        );

        #[method(wantsLayer)]
        pub unsafe fn wantsLayer(&self) -> bool;

        #[method(setWantsLayer:)]
        pub fn setWantsLayer(&self, wants_layer: bool);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[method_id(@__retain_semantics Other layer)]
        pub unsafe fn layer(&self) -> Option<Retained<CALayer>>;

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(target_vendor = "apple")]
        #[method(setLayer:)]
        pub unsafe fn setLayer(&self, layer: Option<&CALayer>);

        #[method(wantsUpdateLayer)]
        pub unsafe fn wantsUpdateLayer(&self) -> bool;

        #[method(updateLayer)]
        pub unsafe fn updateLayer(&self);

        #[method(canDrawSubviewsIntoLayer)]
        pub unsafe fn canDrawSubviewsIntoLayer(&self) -> bool;

        #[method(setCanDrawSubviewsIntoLayer:)]
        pub unsafe fn setCanDrawSubviewsIntoLayer(&self, can_draw_subviews_into_layer: bool);

        #[method(layoutSubtreeIfNeeded)]
        pub unsafe fn layoutSubtreeIfNeeded(&self);

        #[method(layout)]
        pub unsafe fn layout(&self);

        #[method(needsLayout)]
        pub unsafe fn needsLayout(&self) -> bool;

        #[method(setNeedsLayout:)]
        pub unsafe fn setNeedsLayout(&self, needs_layout: bool);

        #[method(alphaValue)]
        pub unsafe fn alphaValue(&self) -> CGFloat;

        #[method(setAlphaValue:)]
        pub unsafe fn setAlphaValue(&self, alpha_value: CGFloat);

        #[method(layerUsesCoreImageFilters)]
        pub unsafe fn layerUsesCoreImageFilters(&self) -> bool;

        #[method(setLayerUsesCoreImageFilters:)]
        pub unsafe fn setLayerUsesCoreImageFilters(&self, layer_uses_core_image_filters: bool);

        #[cfg(feature = "NSShadow")]
        #[method_id(@__retain_semantics Other shadow)]
        pub unsafe fn shadow(&self) -> Option<Retained<NSShadow>>;

        #[cfg(feature = "NSShadow")]
        #[method(setShadow:)]
        pub unsafe fn setShadow(&self, shadow: Option<&NSShadow>);

        #[method(clipsToBounds)]
        pub unsafe fn clipsToBounds(&self) -> bool;

        #[method(setClipsToBounds:)]
        pub unsafe fn setClipsToBounds(&self, clips_to_bounds: bool);

        #[method(postsBoundsChangedNotifications)]
        pub unsafe fn postsBoundsChangedNotifications(&self) -> bool;

        #[method(setPostsBoundsChangedNotifications:)]
        pub unsafe fn setPostsBoundsChangedNotifications(
            &self,
            posts_bounds_changed_notifications: bool,
        );

        #[cfg(feature = "NSScrollView")]
        #[method_id(@__retain_semantics Other enclosingScrollView)]
        pub unsafe fn enclosingScrollView(&self) -> Option<Retained<NSScrollView>>;

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        #[method_id(@__retain_semantics Other menuForEvent:)]
        pub unsafe fn menuForEvent(&self, event: &NSEvent) -> Option<Retained<NSMenu>>;

        #[cfg(feature = "NSMenu")]
        #[method_id(@__retain_semantics Other defaultMenu)]
        pub unsafe fn defaultMenu(mtm: MainThreadMarker) -> Option<Retained<NSMenu>>;

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        #[method(willOpenMenu:withEvent:)]
        pub unsafe fn willOpenMenu_withEvent(&self, menu: &NSMenu, event: &NSEvent);

        #[cfg(all(feature = "NSEvent", feature = "NSMenu"))]
        #[method(didCloseMenu:withEvent:)]
        pub unsafe fn didCloseMenu_withEvent(&self, menu: &NSMenu, event: Option<&NSEvent>);

        #[method_id(@__retain_semantics Other toolTip)]
        pub unsafe fn toolTip(&self) -> Option<Retained<NSString>>;

        #[method(setToolTip:)]
        pub unsafe fn setToolTip(&self, tool_tip: Option<&NSString>);

        #[method(addToolTipRect:owner:userData:)]
        pub unsafe fn addToolTipRect_owner_userData(
            &self,
            rect: NSRect,
            owner: &AnyObject,
            data: *mut c_void,
        ) -> NSToolTipTag;

        #[method(removeToolTip:)]
        pub unsafe fn removeToolTip(&self, tag: NSToolTipTag);

        #[method(removeAllToolTips)]
        pub unsafe fn removeAllToolTips(&self);

        #[method(viewWillStartLiveResize)]
        pub unsafe fn viewWillStartLiveResize(&self);

        #[method(viewDidEndLiveResize)]
        pub unsafe fn viewDidEndLiveResize(&self);

        #[method(inLiveResize)]
        pub unsafe fn inLiveResize(&self) -> bool;

        #[method(preservesContentDuringLiveResize)]
        pub unsafe fn preservesContentDuringLiveResize(&self) -> bool;

        #[method(rectPreservedDuringLiveResize)]
        pub unsafe fn rectPreservedDuringLiveResize(&self) -> NSRect;

        #[cfg(feature = "NSTextInputContext")]
        #[method_id(@__retain_semantics Other inputContext)]
        pub fn inputContext(&self) -> Option<Retained<NSTextInputContext>>;

        #[method(rectForSmartMagnificationAtPoint:inRect:)]
        pub unsafe fn rectForSmartMagnificationAtPoint_inRect(
            &self,
            location: NSPoint,
            visible_rect: NSRect,
        ) -> NSRect;

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[method(userInterfaceLayoutDirection)]
        pub unsafe fn userInterfaceLayoutDirection(&self) -> NSUserInterfaceLayoutDirection;

        #[cfg(feature = "NSUserInterfaceLayout")]
        #[method(setUserInterfaceLayoutDirection:)]
        pub unsafe fn setUserInterfaceLayoutDirection(
            &self,
            user_interface_layout_direction: NSUserInterfaceLayoutDirection,
        );

        #[method(prepareForReuse)]
        pub unsafe fn prepareForReuse(&self);

        #[method(isCompatibleWithResponsiveScrolling)]
        pub unsafe fn isCompatibleWithResponsiveScrolling(mtm: MainThreadMarker) -> bool;

        #[method(prepareContentInRect:)]
        pub unsafe fn prepareContentInRect(&self, rect: NSRect);

        #[method(preparedContentRect)]
        pub unsafe fn preparedContentRect(&self) -> NSRect;

        #[method(setPreparedContentRect:)]
        pub unsafe fn setPreparedContentRect(&self, prepared_content_rect: NSRect);

        #[method(allowsVibrancy)]
        pub unsafe fn allowsVibrancy(&self) -> bool;

        #[method(viewDidChangeEffectiveAppearance)]
        pub unsafe fn viewDidChangeEffectiveAppearance(&self);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSResponder`
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    }
);

extern_protocol!(
    pub unsafe trait NSViewLayerContentScaleDelegate: NSObjectProtocol {
        #[cfg(all(
            feature = "NSResponder",
            feature = "NSWindow",
            feature = "objc2-quartz-core"
        ))]
        #[cfg(target_vendor = "apple")]
        #[optional]
        #[method(layer:shouldInheritContentsScale:fromWindow:)]
        unsafe fn layer_shouldInheritContentsScale_fromWindow(
            &self,
            layer: &CALayer,
            new_scale: CGFloat,
            window: &NSWindow,
        ) -> bool;
    }

    unsafe impl ProtocolType for dyn NSViewLayerContentScaleDelegate {}
);

extern_protocol!(
    pub unsafe trait NSViewToolTipOwner: NSObjectProtocol + IsMainThreadOnly {
        #[cfg(feature = "NSResponder")]
        #[method_id(@__retain_semantics Other view:stringForToolTip:point:userData:)]
        unsafe fn view_stringForToolTip_point_userData(
            &self,
            view: &NSView,
            tag: NSToolTipTag,
            point: NSPoint,
            data: *mut c_void,
        ) -> Retained<NSString>;
    }

    unsafe impl ProtocolType for dyn NSViewToolTipOwner {}
);

extern_methods!(
    /// NSKeyboardUI
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method_id(@__retain_semantics Other nextKeyView)]
        pub unsafe fn nextKeyView(&self) -> Option<Retained<NSView>>;

        #[method(setNextKeyView:)]
        pub unsafe fn setNextKeyView(&self, next_key_view: Option<&NSView>);

        #[method_id(@__retain_semantics Other previousKeyView)]
        pub unsafe fn previousKeyView(&self) -> Option<Retained<NSView>>;

        #[method_id(@__retain_semantics Other nextValidKeyView)]
        pub unsafe fn nextValidKeyView(&self) -> Option<Retained<NSView>>;

        #[method_id(@__retain_semantics Other previousValidKeyView)]
        pub unsafe fn previousValidKeyView(&self) -> Option<Retained<NSView>>;

        #[method(canBecomeKeyView)]
        pub unsafe fn canBecomeKeyView(&self) -> bool;

        #[method(setKeyboardFocusRingNeedsDisplayInRect:)]
        pub unsafe fn setKeyboardFocusRingNeedsDisplayInRect(&self, rect: NSRect);

        #[cfg(feature = "NSGraphics")]
        #[method(focusRingType)]
        pub unsafe fn focusRingType(&self) -> NSFocusRingType;

        #[cfg(feature = "NSGraphics")]
        #[method(setFocusRingType:)]
        pub unsafe fn setFocusRingType(&self, focus_ring_type: NSFocusRingType);

        #[cfg(feature = "NSGraphics")]
        #[method(defaultFocusRingType)]
        pub unsafe fn defaultFocusRingType(mtm: MainThreadMarker) -> NSFocusRingType;

        #[method(drawFocusRingMask)]
        pub unsafe fn drawFocusRingMask(&self);

        #[method(focusRingMaskBounds)]
        pub unsafe fn focusRingMaskBounds(&self) -> NSRect;

        #[method(noteFocusRingMaskChanged)]
        pub unsafe fn noteFocusRingMaskChanged(&self);
    }
);

extern_methods!(
    /// NSPrinting
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(feature = "NSPasteboard")]
        #[method(writeEPSInsideRect:toPasteboard:)]
        pub unsafe fn writeEPSInsideRect_toPasteboard(
            &self,
            rect: NSRect,
            pasteboard: &NSPasteboard,
        );

        #[method_id(@__retain_semantics Other dataWithEPSInsideRect:)]
        pub unsafe fn dataWithEPSInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[cfg(feature = "NSPasteboard")]
        #[method(writePDFInsideRect:toPasteboard:)]
        pub unsafe fn writePDFInsideRect_toPasteboard(
            &self,
            rect: NSRect,
            pasteboard: &NSPasteboard,
        );

        #[method_id(@__retain_semantics Other dataWithPDFInsideRect:)]
        pub unsafe fn dataWithPDFInsideRect(&self, rect: NSRect) -> Retained<NSData>;

        #[method(print:)]
        pub unsafe fn print(&self, sender: Option<&AnyObject>);

        #[method(knowsPageRange:)]
        pub unsafe fn knowsPageRange(&self, range: NSRangePointer) -> bool;

        #[method(heightAdjustLimit)]
        pub unsafe fn heightAdjustLimit(&self) -> CGFloat;

        #[method(widthAdjustLimit)]
        pub unsafe fn widthAdjustLimit(&self) -> CGFloat;

        #[method(adjustPageWidthNew:left:right:limit:)]
        pub unsafe fn adjustPageWidthNew_left_right_limit(
            &self,
            new_right: NonNull<CGFloat>,
            old_left: CGFloat,
            old_right: CGFloat,
            right_limit: CGFloat,
        );

        #[method(adjustPageHeightNew:top:bottom:limit:)]
        pub unsafe fn adjustPageHeightNew_top_bottom_limit(
            &self,
            new_bottom: NonNull<CGFloat>,
            old_top: CGFloat,
            old_bottom: CGFloat,
            bottom_limit: CGFloat,
        );

        #[method(rectForPage:)]
        pub unsafe fn rectForPage(&self, page: NSInteger) -> NSRect;

        #[method(locationOfPrintRect:)]
        pub unsafe fn locationOfPrintRect(&self, rect: NSRect) -> NSPoint;

        #[method(drawPageBorderWithSize:)]
        pub unsafe fn drawPageBorderWithSize(&self, border_size: NSSize);

        #[method_id(@__retain_semantics Other pageHeader)]
        pub unsafe fn pageHeader(&self) -> Retained<NSAttributedString>;

        #[method_id(@__retain_semantics Other pageFooter)]
        pub unsafe fn pageFooter(&self) -> Retained<NSAttributedString>;

        #[deprecated = "This is never invoked and the NSView implementation does nothing"]
        #[method(drawSheetBorderWithSize:)]
        pub unsafe fn drawSheetBorderWithSize(&self, border_size: NSSize);

        #[method_id(@__retain_semantics Other printJobTitle)]
        pub unsafe fn printJobTitle(&self) -> Retained<NSString>;

        #[method(beginDocument)]
        pub unsafe fn beginDocument(&self);

        #[method(endDocument)]
        pub unsafe fn endDocument(&self);

        #[method(beginPageInRect:atPlacement:)]
        pub unsafe fn beginPageInRect_atPlacement(&self, rect: NSRect, location: NSPoint);

        #[method(endPage)]
        pub unsafe fn endPage(&self);
    }
);

extern_methods!(
    /// NSDrag
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(all(
            feature = "NSDragging",
            feature = "NSDraggingItem",
            feature = "NSDraggingSession",
            feature = "NSEvent"
        ))]
        #[method_id(@__retain_semantics Other beginDraggingSessionWithItems:event:source:)]
        pub unsafe fn beginDraggingSessionWithItems_event_source(
            &self,
            items: &NSArray<NSDraggingItem>,
            event: &NSEvent,
            source: &ProtocolObject<dyn NSDraggingSource>,
        ) -> Retained<NSDraggingSession>;

        #[cfg(feature = "NSPasteboard")]
        #[method_id(@__retain_semantics Other registeredDraggedTypes)]
        pub unsafe fn registeredDraggedTypes(&self) -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSPasteboard")]
        #[method(registerForDraggedTypes:)]
        pub unsafe fn registerForDraggedTypes(&self, new_types: &NSArray<NSPasteboardType>);

        #[method(unregisterDraggedTypes)]
        pub unsafe fn unregisterDraggedTypes(&self);
    }
);

// NS_TYPED_ENUM
pub type NSViewFullScreenModeOptionKey = NSString;

extern "C" {
    pub static NSFullScreenModeAllScreens: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    pub static NSFullScreenModeSetting: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    pub static NSFullScreenModeWindowLevel: &'static NSViewFullScreenModeOptionKey;
}

extern "C" {
    pub static NSFullScreenModeApplicationPresentationOptions:
        &'static NSViewFullScreenModeOptionKey;
}

extern_methods!(
    /// NSFullScreenMode
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(feature = "NSScreen")]
        #[method(enterFullScreenMode:withOptions:)]
        pub unsafe fn enterFullScreenMode_withOptions(
            &self,
            screen: &NSScreen,
            options: Option<&NSDictionary<NSViewFullScreenModeOptionKey, AnyObject>>,
        ) -> bool;

        #[method(exitFullScreenModeWithOptions:)]
        pub unsafe fn exitFullScreenModeWithOptions(
            &self,
            options: Option<&NSDictionary<NSViewFullScreenModeOptionKey, AnyObject>>,
        );

        #[method(isInFullScreenMode)]
        pub unsafe fn isInFullScreenMode(&self) -> bool;
    }
);

// NS_TYPED_ENUM
pub type NSDefinitionOptionKey = NSString;

extern "C" {
    pub static NSDefinitionPresentationTypeKey: &'static NSDefinitionOptionKey;
}

// NS_TYPED_ENUM
pub type NSDefinitionPresentationType = NSString;

extern "C" {
    pub static NSDefinitionPresentationTypeOverlay: &'static NSDefinitionPresentationType;
}

extern "C" {
    pub static NSDefinitionPresentationTypeDictionaryApplication:
        &'static NSDefinitionPresentationType;
}

extern_methods!(
    /// NSDefinition
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method(showDefinitionForAttributedString:atPoint:)]
        pub unsafe fn showDefinitionForAttributedString_atPoint(
            &self,
            attr_string: Option<&NSAttributedString>,
            text_baseline_origin: NSPoint,
        );

        #[cfg(feature = "block2")]
        #[method(showDefinitionForAttributedString:range:options:baselineOriginProvider:)]
        pub unsafe fn showDefinitionForAttributedString_range_options_baselineOriginProvider(
            &self,
            attr_string: Option<&NSAttributedString>,
            target_range: NSRange,
            options: Option<&NSDictionary<NSDefinitionOptionKey, AnyObject>>,
            origin_provider: Option<&block2::Block<dyn Fn(NSRange) -> NSPoint>>,
        );
    }
);

extern_methods!(
    /// NSFindIndicator
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method(isDrawingFindIndicator)]
        pub unsafe fn isDrawingFindIndicator(&self) -> bool;
    }
);

extern_methods!(
    /// NSGestureRecognizer
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(feature = "NSGestureRecognizer")]
        #[method_id(@__retain_semantics Other gestureRecognizers)]
        pub unsafe fn gestureRecognizers(&self) -> Retained<NSArray<NSGestureRecognizer>>;

        #[cfg(feature = "NSGestureRecognizer")]
        #[method(setGestureRecognizers:)]
        pub unsafe fn setGestureRecognizers(
            &self,
            gesture_recognizers: &NSArray<NSGestureRecognizer>,
        );

        #[cfg(feature = "NSGestureRecognizer")]
        #[method(addGestureRecognizer:)]
        pub unsafe fn addGestureRecognizer(&self, gesture_recognizer: &NSGestureRecognizer);

        #[cfg(feature = "NSGestureRecognizer")]
        #[method(removeGestureRecognizer:)]
        pub unsafe fn removeGestureRecognizer(&self, gesture_recognizer: &NSGestureRecognizer);
    }
);

extern_methods!(
    /// NSTouchBar
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(feature = "NSTouch")]
        #[method(allowedTouchTypes)]
        pub unsafe fn allowedTouchTypes(&self) -> NSTouchTypeMask;

        #[cfg(feature = "NSTouch")]
        #[method(setAllowedTouchTypes:)]
        pub unsafe fn setAllowedTouchTypes(&self, allowed_touch_types: NSTouchTypeMask);
    }
);

extern_methods!(
    /// NSSafeAreas
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[method(safeAreaInsets)]
        pub unsafe fn safeAreaInsets(&self) -> NSEdgeInsets;

        #[method(additionalSafeAreaInsets)]
        pub unsafe fn additionalSafeAreaInsets(&self) -> NSEdgeInsets;

        #[method(setAdditionalSafeAreaInsets:)]
        pub unsafe fn setAdditionalSafeAreaInsets(&self, additional_safe_area_insets: NSEdgeInsets);

        #[cfg(feature = "NSLayoutGuide")]
        #[method_id(@__retain_semantics Other safeAreaLayoutGuide)]
        pub unsafe fn safeAreaLayoutGuide(&self) -> Retained<NSLayoutGuide>;

        #[method(safeAreaRect)]
        pub unsafe fn safeAreaRect(&self) -> NSRect;

        #[cfg(feature = "NSLayoutGuide")]
        #[method_id(@__retain_semantics Other layoutMarginsGuide)]
        pub unsafe fn layoutMarginsGuide(&self) -> Retained<NSLayoutGuide>;
    }
);

extern_methods!(
    /// NSTrackingArea
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(feature = "NSTrackingArea")]
        #[method(addTrackingArea:)]
        pub unsafe fn addTrackingArea(&self, tracking_area: &NSTrackingArea);

        #[cfg(feature = "NSTrackingArea")]
        #[method(removeTrackingArea:)]
        pub unsafe fn removeTrackingArea(&self, tracking_area: &NSTrackingArea);

        #[cfg(feature = "NSTrackingArea")]
        #[method_id(@__retain_semantics Other trackingAreas)]
        pub unsafe fn trackingAreas(&self) -> Retained<NSArray<NSTrackingArea>>;

        #[method(updateTrackingAreas)]
        pub unsafe fn updateTrackingAreas(&self);

        #[cfg(feature = "NSCursor")]
        #[method(addCursorRect:cursor:)]
        pub fn addCursorRect_cursor(&self, rect: NSRect, object: &NSCursor);

        #[cfg(feature = "NSCursor")]
        #[method(removeCursorRect:cursor:)]
        pub unsafe fn removeCursorRect_cursor(&self, rect: NSRect, object: &NSCursor);

        #[method(discardCursorRects)]
        pub unsafe fn discardCursorRects(&self);

        #[method(resetCursorRects)]
        pub unsafe fn resetCursorRects(&self);

        #[method(addTrackingRect:owner:userData:assumeInside:)]
        pub unsafe fn addTrackingRect_owner_userData_assumeInside(
            &self,
            rect: NSRect,
            owner: &AnyObject,
            data: *mut c_void,
            flag: bool,
        ) -> NSTrackingRectTag;

        #[method(removeTrackingRect:)]
        pub fn removeTrackingRect(&self, tag: NSTrackingRectTag);
    }
);

extern_methods!(
    /// NSDisplayLink
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {}
);

extern_methods!(
    /// NSDeprecated
    #[cfg(feature = "NSResponder")]
    unsafe impl NSView {
        #[cfg(all(feature = "NSEvent", feature = "NSImage", feature = "NSPasteboard"))]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: instead"]
        #[method(dragImage:at:offset:event:pasteboard:source:slideBack:)]
        pub unsafe fn dragImage_at_offset_event_pasteboard_source_slideBack(
            &self,
            image: &NSImage,
            view_location: NSPoint,
            initial_offset: NSSize,
            event: &NSEvent,
            pboard: &NSPasteboard,
            source_obj: &AnyObject,
            slide_flag: bool,
        );

        #[cfg(feature = "NSEvent")]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: instead"]
        #[method(dragFile:fromRect:slideBack:event:)]
        pub unsafe fn dragFile_fromRect_slideBack_event(
            &self,
            filename: &NSString,
            rect: NSRect,
            flag: bool,
            event: &NSEvent,
        ) -> bool;

        #[cfg(feature = "NSEvent")]
        #[deprecated = "Use -beginDraggingSessionWithItems:event:source: with an NSFilePromiseProvider instead"]
        #[method(dragPromisedFilesOfTypes:fromRect:source:slideBack:event:)]
        pub unsafe fn dragPromisedFilesOfTypes_fromRect_source_slideBack_event(
            &self,
            type_array: &NSArray<NSString>,
            rect: NSRect,
            source_object: &AnyObject,
            flag: bool,
            event: &NSEvent,
        ) -> bool;

        #[deprecated]
        #[method(convertPointToBase:)]
        pub unsafe fn convertPointToBase(&self, point: NSPoint) -> NSPoint;

        #[deprecated]
        #[method(convertPointFromBase:)]
        pub unsafe fn convertPointFromBase(&self, point: NSPoint) -> NSPoint;

        #[deprecated]
        #[method(convertSizeToBase:)]
        pub unsafe fn convertSizeToBase(&self, size: NSSize) -> NSSize;

        #[deprecated]
        #[method(convertSizeFromBase:)]
        pub unsafe fn convertSizeFromBase(&self, size: NSSize) -> NSSize;

        #[deprecated]
        #[method(convertRectToBase:)]
        pub unsafe fn convertRectToBase(&self, rect: NSRect) -> NSRect;

        #[deprecated]
        #[method(convertRectFromBase:)]
        pub unsafe fn convertRectFromBase(&self, rect: NSRect) -> NSRect;

        #[deprecated = "This has always returned NO and had no effect on macOS"]
        #[method(performMnemonic:)]
        pub unsafe fn performMnemonic(&self, string: &NSString) -> bool;

        #[deprecated = "This method no longer does anything"]
        #[method(shouldDrawColor)]
        pub unsafe fn shouldDrawColor(&self) -> bool;

        #[deprecated]
        #[method(gState)]
        pub unsafe fn gState(&self) -> NSInteger;

        #[deprecated]
        #[method(allocateGState)]
        pub unsafe fn allocateGState(&self);

        #[deprecated]
        #[method(setUpGState)]
        pub unsafe fn setUpGState(&self);

        #[deprecated]
        #[method(renewGState)]
        pub unsafe fn renewGState(&self);
    }
);

extern "C" {
    pub static NSViewFrameDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSViewFocusDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSViewBoundsDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSViewGlobalFrameDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    pub static NSViewDidUpdateTrackingAreasNotification: &'static NSNotificationName;
}
