/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return false;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean success;
        byte[] titleBytes = Converter.wcsToMbcs(this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        long handle = GTK.gtk_font_chooser_dialog_new(titleBytes, 0L);
        if (this.parent != null) {
            long shellHandle = this.parent.topHandle();
            GTK.gtk_window_set_transient_for(handle, shellHandle);
        }
        long group = GTK.gtk_window_get_group(0L);
        GTK.gtk_window_group_add_window(group, handle);
        GTK.gtk_window_set_modal(handle, true);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            long fontName = OS.pango_font_description_to_string(font.handle);
            int length = C.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            C.memmove(buffer, fontName, (long)length);
            font.dispose();
            OS.g_free(fontName);
            GTK.gtk_font_chooser_set_font(handle, buffer);
        }
        display.addIdleProc();
        Dialog oldModal = null;
        if (GTK.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int response = GTK.gtk_dialog_run(handle);
        GDK.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (GTK.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        boolean bl = success = response == -5;
        if (success) {
            long fontName = GTK.gtk_font_chooser_get_font(handle);
            int length = C.strlen(fontName);
            byte[] buffer = new byte[length + 1];
            C.memmove(buffer, fontName, (long)length);
            OS.g_free(fontName);
            long fontDesc = OS.pango_font_description_from_string(buffer);
            Font font = Font.gtk_new(display, fontDesc);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(fontDesc);
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy(handle);
        if (!success) {
            return null;
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean visible) {
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

